/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.Map;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.directories.address.common.event.HouseModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

@DirectoryItem(eventClass=HouseModifiedEvent.class, serviceClass=AddressService.class)
public class House
extends Id {
    private int cityId;
    private String cityTitle;
    private int areaId;
    private String areaTitle;
    private int streetId;
    private String streetTitle;
    private int quarterId;
    private String quarterTitle;
    private int house;
    private String frac;
    private String comment;
    private String postIndex;
    private int amount;
    private Map<String, String> params;

    @XmlAttribute
    public int getCityId() {
        return this.cityId;
    }

    public void setCityId(int cityId) {
        this.cityId = cityId;
    }

    @XmlAttribute
    public int getAreaId() {
        return this.areaId;
    }

    public void setAreaId(int areaId) {
        this.areaId = areaId;
    }

    @XmlAttribute
    public int getStreetId() {
        return this.streetId;
    }

    public void setStreetId(int streetId) {
        this.streetId = streetId;
    }

    @XmlAttribute
    public int getQuarterId() {
        return this.quarterId;
    }

    public void setQuarterId(int quarterId) {
        this.quarterId = quarterId;
    }

    @XmlAttribute
    public int getHouse() {
        return this.house;
    }

    public void setHouse(int house) {
        this.house = house;
    }

    @XmlAttribute
    public String getFrac() {
        return this.frac;
    }

    public void setFrac(String frac) {
        this.frac = frac;
    }

    public void setHouseAndFrac(String houseAndFrac) {
        this.frac = "";
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < houseAndFrac.length(); ++i) {
            char ch = houseAndFrac.charAt(i);
            if (!Character.isDigit(ch)) {
                this.frac = houseAndFrac.substring(i);
                break;
            }
            str.append(ch);
        }
        this.house = Utils.parseInt(str.toString(), 0);
    }

    public static Object[] getHouseAndFrac(String houseAndFrac) {
        String frac = "";
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < houseAndFrac.length(); ++i) {
            char ch = houseAndFrac.charAt(i);
            if (!Character.isDigit(ch)) {
                frac = houseAndFrac.substring(i);
                break;
            }
            str.append(ch);
        }
        return new Object[]{Utils.parseInt(str.toString(), 0), frac};
    }

    @XmlAttribute
    public String getHouseFrac() {
        StringBuilder buf = new StringBuilder();
        if (this.house > 0) {
            buf.append(this.house);
        }
        if (this.frac != null && !this.frac.isEmpty()) {
            if (Character.isDigit(this.frac.charAt(0))) {
                buf.append('/');
            }
            buf.append(this.frac);
        }
        return buf.toString();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @XmlAttribute
    public String getPostIndex() {
        return this.postIndex;
    }

    public void setPostIndex(String postIndex) {
        this.postIndex = postIndex;
    }

    @XmlAttribute
    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    @XmlAttribute
    public String getCityTitle() {
        return this.cityTitle;
    }

    public void setCityTitle(String cityTitle) {
        this.cityTitle = cityTitle;
    }

    @XmlAttribute
    public String getAreaTitle() {
        return this.areaTitle;
    }

    public void setAreaTitle(String areaTitle) {
        this.areaTitle = areaTitle;
    }

    @XmlAttribute
    public String getStreetTitle() {
        return this.streetTitle;
    }

    public void setStreetTitle(String streetTitle) {
        this.streetTitle = streetTitle;
    }

    @XmlAttribute
    public String getQuarterTitle() {
        return this.quarterTitle;
    }

    public void setQuarterTitle(String quarterTitle) {
        this.quarterTitle = quarterTitle;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("id=").append(this.id);
        buf.append("; areaId=").append(this.areaId);
        buf.append("; streetId=").append(this.streetId);
        buf.append("; quarterId=").append(this.quarterId);
        buf.append("; house=").append(this.house);
        buf.append("; frac=").append(this.frac);
        buf.append("; postIndex=").append(this.postIndex);
        buf.append("; amount=").append(this.amount);
        buf.append("; comment=").append(this.comment);
        return buf.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private House house = new House();

        private Builder() {
        }

        public Builder setId(int id) {
            this.house.id = id;
            return this;
        }

        public Builder setCityId(int cityId) {
            this.house.cityId = cityId;
            return this;
        }

        public Builder setAreaId(int areaId) {
            this.house.areaId = areaId;
            return this;
        }

        public Builder setStreetId(int streetId) {
            this.house.streetId = streetId;
            return this;
        }

        public Builder setQuarterId(int quarterId) {
            this.house.quarterId = quarterId;
            return this;
        }

        public Builder setHouse(int house) {
            this.house.house = house;
            return this;
        }

        public Builder setFrac(String frac) {
            this.house.frac = frac;
            return this;
        }

        public Builder setHouseAndFrac(String houseAndFrac) {
            this.house.frac = "";
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < houseAndFrac.length(); ++i) {
                char ch = houseAndFrac.charAt(i);
                if (!Character.isDigit(ch)) {
                    this.house.frac = houseAndFrac.substring(i);
                    break;
                }
                str.append(ch);
            }
            this.house.house = Utils.parseInt(str.toString(), 0);
            return this;
        }

        public Builder setComment(String comment) {
            this.house.comment = comment;
            return this;
        }

        public Builder setPostIndex(String postIndex) {
            this.house.postIndex = postIndex;
            return this;
        }

        public Builder setAmount(int amount) {
            this.house.amount = amount;
            return this;
        }

        public Builder setCityTitle(String cityTitle) {
            this.house.cityTitle = cityTitle;
            return this;
        }

        public Builder setAreaTitle(String areaTitle) {
            this.house.areaTitle = areaTitle;
            return this;
        }

        public Builder setStreetTitle(String streetTitle) {
            this.house.streetTitle = streetTitle;
            return this;
        }

        public Builder setQuarterTitle(String quarterTitle) {
            this.house.quarterTitle = quarterTitle;
            return this;
        }

        public Builder setParams(Map<String, String> params) {
            this.house.params = params;
            return this;
        }

        public House build() {
            try {
                House house = this.house;
                return house;
            }
            finally {
                this.house = null;
            }
        }
    }
}

