/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.util.ArrayList;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrContract;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrInt;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrMultiList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrType;

@XmlSeeAlso(value={EntityAttrText.class, EntityAttrInt.class, EntityAttrList.class, EntityAttrDate.class, EntityAttrAddress.class, EntityAttrEmail.class, EntityAttrContract.class, EntityAttrBoolean.class, EntityAttrPhone.class, EntityAttrMultiList.class})
public abstract class EntityAttr {
    private EntitySpecAttrType type;
    private int entityId;
    private int entitySpecAttrId;

    public EntityAttr() {
    }

    protected EntityAttr(EntitySpecAttrType type) {
        this(type, 0, 0);
    }

    protected EntityAttr(EntitySpecAttrType type, int entityId, int entitySpecAttrId) {
        this.type = type;
        this.entityId = entityId;
        this.entitySpecAttrId = entitySpecAttrId;
    }

    @XmlAttribute
    public int getType() {
        return this.type.getCode();
    }

    public void setType(int type) {
    }

    @XmlAttribute
    public String getTypeName() {
        return this.type.getTypeName();
    }

    public void setTypeName(String typeName) {
    }

    @XmlAttribute
    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    @XmlAttribute
    public int getEntitySpecAttrId() {
        return this.entitySpecAttrId;
    }

    public void setEntitySpecAttrId(int entitySpecAttrId) {
        this.entitySpecAttrId = entitySpecAttrId;
    }

    public static EntityAttr newInstance(int entitySpecAttrTypeId, int entityId, int entitySpecAttrId) {
        switch (EntitySpecAttrType.getEntitySpecAttrType(entitySpecAttrTypeId)) {
            case TEXT: {
                return new EntityAttrText(entityId, entitySpecAttrId, "");
            }
            case INT: {
                return new EntityAttrInt(entityId, entitySpecAttrId, 0);
            }
            case BOOLEAN: {
                return new EntityAttrBoolean(entityId, entitySpecAttrId, false);
            }
            case LIST: {
                return new EntityAttrList(entityId, entitySpecAttrId, 0, "");
            }
            case DATE: {
                return new EntityAttrDate(entityId, entitySpecAttrId, null);
            }
            case EMAIL: {
                return new EntityAttrEmail(entityId, entitySpecAttrId);
            }
            case PHONE: {
                return new EntityAttrPhone(entityId, entitySpecAttrId);
            }
            case MULTILIST: {
                return new EntityAttrMultiList(entityId, entitySpecAttrId, "", new ArrayList<IdTitle>());
            }
        }
        throw new IllegalArgumentException(String.valueOf(entitySpecAttrTypeId));
    }
}

