/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrType;

@XmlSeeAlso(value={PhoneContact.class})
public class EntityAttrPhone
extends EntityAttr {
    private String data;
    private List<PhoneContact> contactList;

    protected EntityAttrPhone() {
        super(EntitySpecAttrType.PHONE);
    }

    public EntityAttrPhone(int entityId, int entitySpecAttrId) {
        super(EntitySpecAttrType.PHONE, entityId, entitySpecAttrId);
    }

    public EntityAttrPhone(int entityId, int entitySpecAttrId, String phone, String comment) {
        this(entityId, entitySpecAttrId);
        this.addContact(phone, comment);
    }

    @XmlElements(value={@XmlElement(name="contact")})
    public List<PhoneContact> getContactList() {
        return this.contactList;
    }

    public void setContactList(List<PhoneContact> phoneList) {
        this.contactList = phoneList;
    }

    public EntityAttrPhone addContact(String phone, String comment) {
        if (this.contactList == null) {
            this.contactList = new ArrayList<PhoneContact>();
        }
        this.contactList.add(new PhoneContact(phone, comment));
        return this;
    }

    @XmlTransient
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getContactList() != null) {
            for (PhoneContact p : this.getContactList()) {
                sb.append(p.getPhone());
                if (Utils.notBlankString(p.getComment())) {
                    sb.append(" [").append(p.getComment()).append(']');
                }
                sb.append("; ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            }
        }
        return sb.toString();
    }

    @XmlTransient
    public List<String> getPhoneList() {
        List<PhoneContact> list = this.getContactList();
        if (list == null) {
            return new ArrayList<String>(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (PhoneContact contact : list) {
            if (Utils.notBlankString(contact.getPhone())) continue;
            result.add(contact.getPhone());
        }
        return result;
    }

    @XmlTransient
    public List<String> getUnformattedPhoneList() {
        List<PhoneContact> list = this.getContactList();
        if (list == null) {
            return new ArrayList<String>(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (PhoneContact contact : list) {
            String phone = contact.getPhoneUnformatted();
            if (Utils.isBlankString(phone)) continue;
            result.add(phone);
        }
        return result;
    }

    public static String phoneUnformatted(String phone) {
        if (Utils.isEmptyString(phone)) {
            return "";
        }
        StringBuilder sb = null;
        int size = phone.length();
        for (int i = 0; i < size; ++i) {
            char c = phone.charAt(i);
            if (Character.isDigit(c)) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb != null) continue;
            sb = new StringBuilder(phone.length());
            for (int j = 0; j < i; ++j) {
                sb.append(phone.charAt(j));
            }
        }
        if (sb != null) {
            return sb.toString();
        }
        return phone;
    }

    public static class PhoneContact {
        private String phone = null;
        private String comment = null;

        public PhoneContact() {
        }

        public PhoneContact(String phone, String comment) {
            this.phone = phone;
            this.comment = comment;
        }

        @XmlAttribute
        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        @XmlAttribute
        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        @XmlTransient
        public String getPhoneUnformatted() {
            return EntityAttrPhone.phoneUnformatted(this.phone);
        }
    }
}

