/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.util.MacrosFormat;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.event.EntitySpecModifiedEvent;

@DirectoryItem(eventClass=EntitySpecModifiedEvent.class)
public class EntitySpec
extends IdTitle {
    private String entityTitleMacros = "";
    private Set<Integer> moduleIds;
    private int entitySpecTypeId;
    private String comment;
    private boolean hidden;
    private List<EntitySpecAttr> attributeList;
    private static Pattern macrosPattern = Pattern.compile("\\$\\{([\\w:]+)\\}");
    private final transient ThreadLocal<SoftReference<EntityMacrosFormat>> macrosFormat = new ThreadLocal();

    public EntitySpec() {
    }

    public EntitySpec(String title) {
        this.title = title;
    }

    @XmlAttribute
    public Set<Integer> getModuleIds() {
        return this.moduleIds;
    }

    public void setModuleIds(Set<Integer> moduleIds) {
        this.moduleIds = moduleIds;
    }

    @XmlAttribute
    public int getEntitySpecTypeId() {
        return this.entitySpecTypeId;
    }

    public void setEntitySpecTypeId(int entitySpecTypeId) {
        this.entitySpecTypeId = entitySpecTypeId;
    }

    @XmlAttribute
    public String getEntityTitleMacros() {
        return this.entityTitleMacros;
    }

    public void setEntityTitleMacros(String entityTitleMakros) {
        this.entityTitleMacros = entityTitleMakros;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @XmlAttribute
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @XmlElementWrapper
    public List<EntitySpecAttr> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<EntitySpecAttr> attributes) {
        this.attributeList = attributes;
    }

    private MacrosFormat getMacrosFormat() {
        EntityMacrosFormat result;
        SoftReference<EntityMacrosFormat> ref = this.macrosFormat.get();
        if (ref != null && (result = ref.get()) != null) {
            return result;
        }
        result = new EntityMacrosFormat();
        result.setPattern(this.entityTitleMacros);
        this.macrosFormat.set(new SoftReference<EntityMacrosFormat>(result));
        return result;
    }

    public String createEntityTitle(Entity entity) {
        if (Utils.isBlankString(this.entityTitleMacros)) {
            return entity.getTitle();
        }
        try {
            return this.getMacrosFormat().format(new StringBuffer(20), entity).toString();
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    public static String createEntityTitle(int entityId, String title, EntitySpec spec, Map<Integer, EntityAttr> attributes) {
        String macros = spec.getEntityTitleMacros();
        if (Utils.isBlankString(macros)) {
            return title;
        }
        Matcher m = macrosPattern.matcher(macros);
        StringBuffer result = new StringBuffer();
        int end = 0;
        while (m.find()) {
            int start = m.start();
            result.append(macros.substring(end, start));
            result.append(EntitySpec.processTitleMacros(m.group(1), entityId, title, spec, attributes));
            end = m.end();
        }
        result.append(macros.substring(end, macros.length()));
        title = result.toString();
        return title;
    }

    private static int getMacrosParamId(String str) {
        int pos = str.indexOf(58);
        if (pos > 0 && pos < str.length() - 2) {
            return Utils.parseInt(str.substring(pos + 1), 0);
        }
        pos = str.indexOf(95);
        if (pos > 0 && pos < str.length() - 2) {
            return Utils.parseInt(str.substring(pos + 1), 0);
        }
        return 0;
    }

    private static String processTitleMacros(String macros, int entityId, String title, EntitySpec spec, Map<Integer, EntityAttr> attributes) {
        EntityAttr attr;
        if (macros.equals("type")) {
            return spec.getTitle();
        }
        if (macros.equals("id")) {
            return String.valueOf(entityId);
        }
        if (macros.equals("title")) {
            return spec.getTitle();
        }
        if ((macros.startsWith("address:") || macros.startsWith("address:") || macros.startsWith("date:") || macros.startsWith("text:") || macros.startsWith("list:")) && (attr = attributes.get(EntitySpec.getMacrosParamId(macros))) != null) {
            return attr.toString();
        }
        return "";
    }

    class EntityMacrosFormat
    extends MacrosFormat {
        EntityMacrosFormat() {
        }

        @Override
        protected Object invoke(String macros, Object[] args, Object[] globalArgs) {
            Object id;
            EntityAttr attr;
            Map<Integer, EntityAttr> entityAttributes;
            Entity entity = (Entity)globalArgs[0];
            if ("title".equals(macros)) {
                return entity.getTitle();
            }
            if ("attr".equals(macros) && (entityAttributes = entity.getEntityAttributes()) != null && (attr = (id = args[0]) instanceof Integer ? entityAttributes.get((Integer)id) : entityAttributes.get(Utils.parseInt(id.toString()))) != null) {
                return attr.toString();
            }
            return "";
        }
    }
}

