/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.event.EntitySpecAttrModifiedEvent;
import ru.bitel.oss.kernel.entity.common.service.EntityService;

@DirectoryItem(eventClass=EntitySpecAttrModifiedEvent.class, serviceClass=EntityService.class)
public class EntitySpecAttr
extends IdTitle {
    private static final long serialVersionUID = 6770962976574884602L;
    private int type;
    private boolean history;
    private String comment;

    @XmlAttribute
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static String getTypeName(int type) {
        EntitySpecAttrType entitySpecAttrType = EntitySpecAttrType.getEntitySpecAttrType(type);
        return entitySpecAttrType == null ? "unknown" : entitySpecAttrType.getTypeName();
    }

    public String getTypeName() {
        return EntitySpecAttr.getTypeName(this.type);
    }

    @XmlAttribute
    public boolean isHistory() {
        return this.history;
    }

    public void setHistory(boolean history) {
        this.history = history;
    }

    @XmlElement
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public static <A extends EntitySpecAttr> Map<Integer, List<A>> toTypeMap(List<A> entitySpecAttrList) {
        HashMap<Integer, List<A>> result = new HashMap<Integer, List<A>>();
        for (EntitySpecAttr sa : entitySpecAttrList) {
            ArrayList<EntitySpecAttr> list = (ArrayList<EntitySpecAttr>)result.get(sa.getType());
            if (list == null) {
                list = new ArrayList<EntitySpecAttr>();
                result.put(sa.getType(), list);
            }
            list.add(sa);
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private EntitySpecAttr attr = new EntitySpecAttr();

        private Builder() {
        }

        public Builder setId(int value) {
            this.attr.id = value;
            return this;
        }

        public Builder setTitle(String title) {
            this.attr.title = title;
            return this;
        }

        public Builder setType(int type) {
            this.attr.type = type;
            return this;
        }

        public Builder setComment(String comment) {
            this.attr.comment = comment;
            return this;
        }

        public EntitySpecAttr build() {
            try {
                EntitySpecAttr entitySpecAttr = this.attr;
                return entitySpecAttr;
            }
            finally {
                this.attr = null;
            }
        }
    }
}

