/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.Transaction;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.Constants;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsCheckEvent;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebAction(title="CloudPaymets")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("cloudpayments");
    }

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            if (this.context.getRequest().getParameter("check") != null) {
                EventProcessor.getInstance().publish((Event)new CloudPaymentsCheckEvent(this.moduleId, this.contractId, false));
            }
        }
        super.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchParam searchParam = SearchParam.builder().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL)).build();
        SearchResult searchResult = new SearchResult.Builder().setPage(this.getPage()).setSort(new String[]{"createDate:1", "transactionDate:1"}).build();
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            transactionManager.searchTransaction(searchResult, searchParam);
            this.setResultParam("transactions", searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("cloudpayments.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("cloudpayments.sum.max", new BigDecimal(5000));
        String customerAddress = ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(this.contractId)).setCreateDate(new Date())).setAutopayment(false)).build();
        try (TransactionManager transactionManager = new TransactionManager(this.setup.getDBConnection(true), this.moduleId);){
            transactionManager.update(transaction);
        }
        String contractTitle = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle();
        this.setResultParam("publicId", this.moduleSetup.get("cloudpayments.public.id", "test_api_00000000000000000000001"));
        this.setResultParam("description", this.moduleSetup.get("cloudpayments.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
        this.setResultParam("amount", sum);
        this.setResultParam("accountId", contractTitle);
        this.setResultParam("invoiceId", transaction.getId());
        this.setResultParam("contractId", this.contractId);
        this.setResultParam("email", customerAddress);
        this.setResultParam("contentType", ActionResultContentType.json);
    }

    public void autopayment() throws Exception {
        int mode;
        super.autopayment();
        boolean autopaymentEnable = this.moduleSetup.getBoolean("cloudpayments.autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId) && (mode = this.req.getInt("mode", 0)) > -1 && mode < 4) {
            ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            try (AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
                 TransactionManager transactionManager = new TransactionManager(this.setup.getDBConnection(true), this.moduleId);){
                Preferences modeDataMap;
                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
                if (autopayment != null) {
                    if (autopayment.getMode() != AutopaymentMode.OFF) {
                        autopaymentManager.autopaymentOff(autopayment);
                    }
                    if (mode != autopayment.getMode().getCode()) {
                        autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                        autopaymentManager.updateAutopayment(autopayment);
                        autopayment = null;
                    }
                }
                if (autopayment == null) {
                    autopayment = new Autopayment();
                    autopayment.setContractId(this.contractId);
                }
                Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
                if (mode == AutopaymentMode.OFF.getCode()) {
                    autopayment.setMode(AutopaymentMode.OFF);
                    autopayment.setSum(BigDecimal.ZERO);
                    autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                    autopayment.setAccessToken(null);
                } else if (mode == AutopaymentMode.WEEK.getCode()) {
                    this.autopaymentWeek("CLOUDPAYMENTS", modeDataMap, autopayment, Constants.class);
                } else if (mode == AutopaymentMode.MONTH.getCode()) {
                    this.autopaymentMonth("CLOUDPAYMENTS", modeDataMap, autopayment, Constants.class);
                } else if (mode == AutopaymentMode.AUTO.getCode()) {
                    this.autopaymentAuto("CLOUDPAYMENTS", modeDataMap, autopayment, Constants.class);
                }
                autopayment.setModeData(modeDataMap.toString());
                autopaymentManager.updateAutopayment(autopayment);
                if (autopayment.getMode().getCode() != AutopaymentMode.OFF.getCode()) {
                    this.setResultParam("publicId", this.moduleSetup.get("cloudpayments.public.id", "test_api_00000000000000000000001"));
                    this.setResultParam("contentType", ActionResultContentType.json);
                } else {
                    this.execute();
                }
            }
        }
    }
}

