/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.common;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.xml.ws.Holder;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGMaskTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.dispatch.client.common.DispatchMessageStatisticPanel;
import ru.bitel.bgbilling.plugins.dispatch.client.common.FileListPanel;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessage;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;

public class DispatchMessagePanel
extends BGUPanel {
    private static final Class<DispatchService> clazz = DispatchService.class;
    private static final String DATE_FORMAT = "dd.MM.yyyy HH:mm";
    private Dispatch selected;
    private BGUTable table;
    private BGTableModel<DispatchMessage> model;
    private DispatchMessageStatisticPanel statisticPanel = new DispatchMessageStatisticPanel();
    private DispatchMessageEditor messageEditor = new DispatchMessageEditor();
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private BGEditor editor = new BGEditor();
    private JPanel mainPanel;
    private CardLayout switchLayout = new CardLayout();

    protected void jbInit() {
        this.toolBar.setDefaultButtons(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("newItem".equals(actionEvent.getActionCommand())) {
                    DispatchMessagePanel.this.messageEditor.performAction("new");
                } else if ("editItem".equals(actionEvent.getActionCommand())) {
                    DispatchMessagePanel.this.messageEditor.performAction("edit");
                } else if ("deleteItem".equals(actionEvent.getActionCommand())) {
                    DispatchMessagePanel.this.messageEditor.performAction("delete");
                } else if ("refresh".equals(actionEvent.getActionCommand())) {
                    DispatchMessagePanel.this.performAction("refresh");
                }
            }
        });
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem", "refresh"});
        this.model = new BGTableModel<DispatchMessage>("messages"){

            protected void initColumns() {
                this.addColumn("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e", 100, 100, 100, "sent", true);
                this.addColumn("\u0414\u0430\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438", Column.DateTime.class, 140, 160, 180, "sendDate", true);
                this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043d\u043e", Column.DateTime.class, 140, 160, 180, "createDate", true);
                this.addColumn("\u0422\u0435\u043c\u0430", -1, -1, -1, "title", true);
            }
        };
        this.table = new BGUTable(this.model);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DispatchMessagePanel.this.messageEditor.performAction("edit");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f"));
        this.editor.addForm((JComponent)((Object)this.messageEditor));
        this.mainPanel = new JPanel(this.switchLayout);
        this.mainPanel.add((Component)new JScrollPane((Component)this.table), "table");
        this.mainPanel.add((Component)((Object)this.statisticPanel), "statistic");
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.mainPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.setVisible(false);
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (DispatchMessagePanel.this.selected == null || DispatchMessagePanel.this.selected.getId() <= 0) {
                    return;
                }
                List data = ((DispatchService)((ClientContext)DispatchMessagePanel.this.getContext()).getPort(clazz)).getMessageList(DispatchMessagePanel.this.selected.getId(), false);
                DispatchMessagePanel.this.model.setData(data);
                DispatchMessagePanel.this.editor.setVisible(false);
            }
        };
        new AbstractBGUPanel.MenuAction("messages.show_stat", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                DispatchMessage selectedRow = (DispatchMessage)DispatchMessagePanel.this.model.getSelectedRow();
                if (selectedRow != null) {
                    DispatchMessagePanel.this.switchLayout.show(DispatchMessagePanel.this.mainPanel, "statistic");
                    DispatchMessagePanel.this.statisticPanel.setMessage(selectedRow);
                    DispatchMessagePanel.this.statisticPanel.performAction("refresh");
                }
            }
        };
    }

    public void setSelectedDispatch(Dispatch selected) {
        this.selected = selected;
    }

    private class DispatchMessageEditor
    extends BGUPanel {
        private DispatchMessage current = null;
        private JTextField titleField = new JTextField();
        private JTextArea bodyArea = new JTextArea();
        private JButton fromFileButton = new JButton("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430");
        private JLabel createdDateLabel = new JLabel();
        private JLabel sendDateLabel = new JLabel();
        private JLabel sentLabel = new JLabel();
        private JButton editSendDate = new JButton();
        private BGMaskTextField dateTimeField;
        private FileListPanel fileListPanel = new FileListPanel(this, "inclusions", "\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u044f");

        private DispatchMessageEditor() {
        }

        protected void jbInit() {
            this.bodyArea.setMargin(new Insets(3, 3, 3, 3));
            this.dateTimeField = new BGMaskTextField("\u0434\u0434.\u043c\u043c.\u0433\u0433\u0433\u0433 \u0447\u0447:\u043c\u043c", ".: ", new BGMaskTextField.FieldValidator[]{new BGMaskTextField.IntegerValidator(1L, 31L), new BGMaskTextField.IntegerValidator(1L, 12L), new BGMaskTextField.IntegerValidator(1900L, 2999L), new BGMaskTextField.IntegerValidator(0L, 23L), new BGMaskTextField.IntegerValidator(0L, 59L)});
            this.dateTimeField.setHorizontalAlignment(0);
            JPanel leftPart = new JPanel(new GridBagLayout());
            leftPart.setBorder((Border)new BGTitleBorder("\u0421\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435"));
            leftPart.add((Component)new JLabel("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            leftPart.add((Component)this.titleField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            leftPart.add((Component)new JLabel("\u0422\u0435\u043a\u0441\u0442 (\u0432 HTML \u0444\u043e\u0440\u043c\u0430\u0442\u0435):"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            leftPart.add((Component)new JScrollPane(this.bodyArea), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            leftPart.add((Component)this.fromFileButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            JPanel messageInfo = new JPanel(new GridBagLayout());
            messageInfo.setBorder((Border)new BGTitleBorder("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f"));
            messageInfo.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            messageInfo.add((Component)this.createdDateLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            messageInfo.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            messageInfo.add((Component)this.sendDateLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            messageInfo.add((Component)this.editSendDate, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            messageInfo.add((Component)new JLabel("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            messageInfo.add((Component)this.sentLabel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            JPanel rightPart = new JPanel(new GridBagLayout());
            rightPart.add((Component)messageInfo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            rightPart.add((Component)((Object)this.fileListPanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.setLayout(new GridBagLayout());
            this.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
            this.add(leftPart, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add(rightPart, new GridBagConstraints(1, 0, 1, 1, 0.3, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.fromFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        DispatchMessageEditor.this.loadFileContents();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            final JLabel labelTip = new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u0442\u0443:");
            final JDialog dialog = new JDialog(JOptionPane.getRootFrame(), true);
            dialog.setUndecorated(true);
            Dimension size = new Dimension(250, 120);
            dialog.setMinimumSize(size);
            dialog.setMaximumSize(size);
            BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
            okCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if ("ok".equals(actionEvent.getActionCommand()) && DispatchMessageEditor.this.current != null) {
                        DispatchMessageEditor.this.current.setSendDate(TimeUtils.parseDate((String)DispatchMessageEditor.this.dateTimeField.getText(), (String)DispatchMessagePanel.DATE_FORMAT));
                        if (DispatchMessageEditor.this.current.getSendDate() == null) {
                            labelTip.setText("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0434\u0430\u0442\u0430:");
                            labelTip.setForeground(Color.RED);
                            return;
                        }
                        DispatchMessageEditor.this.sendDateLabel.setText(TimeUtils.format((Date)DispatchMessageEditor.this.current.getSendDate(), (String)DispatchMessagePanel.DATE_FORMAT));
                        DispatchMessageEditor.this.editSendDate.setText(DispatchMessageEditor.this.sendDateLabel.getText());
                    }
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            final JPanel content = new JPanel(new GridBagLayout());
            content.setBorder(BorderFactory.createBevelBorder(0));
            content.add((Component)labelTip, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            content.add((Component)this.dateTimeField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            content.add((Component)okCancel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.editSendDate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    labelTip.setText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u0442\u0443:");
                    labelTip.setForeground(Color.BLACK);
                    DispatchMessageEditor.this.dateTimeField.setText(TimeUtils.format((Date)DispatchMessageEditor.this.current.getSendDate(), (String)DispatchMessagePanel.DATE_FORMAT));
                    dialog.setContentPane(content);
                    dialog.setLocation(DispatchMessageEditor.this.editSendDate.getLocationOnScreen());
                    dialog.setVisible(true);
                }
            });
        }

        private void loadFileContents() throws IOException {
            BGFileChooser fileChooser = new BGFileChooser((Component)((Object)this));
            if (fileChooser.showOpenDialog() == 0) {
                this.bodyArea.setText("");
                File f = fileChooser.getSelectedFile();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.bodyArea.append(System.getProperty("line.separator"));
                    this.bodyArea.append(line);
                }
                reader.close();
            }
        }

        private void loadFromCurrent() throws Exception {
            this.titleField.setText(this.current.getTitle());
            this.bodyArea.setText(this.current.getMessageBody());
            this.createdDateLabel.setText(TimeUtils.format((Date)this.current.getCreateDate(), (String)"dd.MM.yyyy HH:mm:ss"));
            this.sendDateLabel.setText(TimeUtils.format((Date)this.current.getSendDate(), (String)DispatchMessagePanel.DATE_FORMAT));
            this.editSendDate.setText(this.sendDateLabel.getText());
            this.sentLabel.setText(this.current.isSent() ? "\u0434\u0430" : "\u043d\u0435\u0442");
            List data = ((DispatchService)((ClientContext)this.getContext()).getPort(clazz)).getMessageInclusions(this.current);
            this.fileListPanel.setData(data);
            this.sendDateLabel.setVisible(this.current.isSent());
            this.editSendDate.setVisible(!this.current.isSent());
            this.titleField.setEditable(!this.current.isSent());
            this.bodyArea.setEditable(!this.current.isSent());
            this.fileListPanel.setButtonsEnabled(!this.current.isSent());
            this.fromFileButton.setEnabled(!this.current.isSent());
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (DispatchMessagePanel.this.selected == null) {
                        return;
                    }
                    DispatchMessageEditor.this.current = new DispatchMessage();
                    DispatchMessageEditor.this.current.setCreateDate(new Date());
                    DispatchMessageEditor.this.current.setSendDate(TimeUtils.nowPlusPeriod((int)12, (int)5));
                    DispatchMessageEditor.this.current.setDispatchId(DispatchMessagePanel.this.selected.getId());
                    DispatchMessageEditor.this.loadFromCurrent();
                    DispatchMessageEditor.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    DispatchMessageEditor.this.current = (DispatchMessage)DispatchMessagePanel.this.model.getSelectedRow();
                    DispatchMessageEditor.this.checkCurrent();
                    DispatchMessageEditor.this.loadFromCurrent();
                    DispatchMessageEditor.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (DispatchMessageEditor.this.current == null && DispatchMessageEditor.this.current.isSent()) {
                        return;
                    }
                    DispatchMessageEditor.this.current.setTitle(DispatchMessageEditor.this.titleField.getText());
                    DispatchMessageEditor.this.current.setMessageBody(DispatchMessageEditor.this.bodyArea.getText());
                    ((DispatchService)((ClientContext)DispatchMessageEditor.this.getContext()).getPort(clazz)).updateMessage(DispatchMessageEditor.this.current);
                    DispatchMessageEditor.this.performActionClose();
                    DispatchMessagePanel.this.performAction("refresh");
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    DispatchMessageEditor.this.current = (DispatchMessage)DispatchMessagePanel.this.model.getSelectedRow();
                    DispatchMessageEditor.this.checkCurrent();
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0438\u0437 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435", 0) == 0) {
                        ((DispatchService)((ClientContext)DispatchMessageEditor.this.getContext()).getPort(clazz)).deleteMessage(DispatchMessageEditor.this.current);
                        DispatchMessagePanel.this.performAction("refresh");
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("upload_file", "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    DispatchMessageEditor.this.checkCurrent();
                    File f = DispatchMessageEditor.this.fileListPanel.getSelectedFile();
                    if (f == null) {
                        return;
                    }
                    FileDataSource fds = new FileDataSource(f);
                    DataHandler dh = new DataHandler((DataSource)fds);
                    Holder holder = new Holder((Object)dh);
                    ((DispatchService)((ClientContext)DispatchMessageEditor.this.getContext()).getPort(clazz)).addMessageInclusion(DispatchMessageEditor.this.current, holder, fds.getName());
                    DispatchMessageEditor.this.fileListPanel.setData(((DispatchService)((ClientContext)DispatchMessageEditor.this.getContext()).getPort(clazz)).getMessageInclusions(DispatchMessageEditor.this.current));
                }
            };
            new AbstractBGUPanel.DefaultAction("delete_file", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    DispatchMessageEditor.this.checkCurrent();
                    BGServerFile selected = DispatchMessageEditor.this.fileListPanel.getSelectedRow();
                    if (selected != null) {
                        ((DispatchService)((ClientContext)DispatchMessageEditor.this.getContext()).getPort(clazz)).deleteMessageInclusion(DispatchMessageEditor.this.current, selected);
                        DispatchMessageEditor.this.fileListPanel.setData(((DispatchService)((ClientContext)DispatchMessageEditor.this.getContext()).getPort(clazz)).getMessageInclusions(DispatchMessageEditor.this.current));
                    }
                }
            };
        }

        private void checkCurrent() throws BGMessageException {
            if (this.current == null) {
                throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            }
            if (this.current.getId() < 0) {
                throw new BGMessageException("\u0421\u043f\u0435\u0440\u0432\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435!");
            }
        }
    }
}

