/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.dao;

import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContractContact;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactTypeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

public class ContactDao
extends AbstractIdDao<Contact> {
    private ContactTypeDao ctDao = null;
    private Map<Integer, Integer> contactToPidMap = new HashMap<Integer, Integer>();
    private ContractParameterManager contractParameterManager = null;

    public ContactDao(Connection con) {
        super(con, 0, "dispatch_contact");
        this.contractParameterManager = new ContractParameterManager(con);
    }

    protected void updateImpl(Contact contact) throws BGException, SQLException {
        if (contact == null) {
            return;
        }
        boolean insert = contact.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET contract_id=?, type_id=?, val=?" + (insert ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int parameterIndex = 1;
            ps.setInt(parameterIndex++, contact.getContractId());
            ps.setInt(parameterIndex++, contact.getContactTypeId());
            ps.setString(parameterIndex++, contact.getValue());
            if (!insert) {
                ps.setInt(parameterIndex++, contact.getId());
            }
            ps.executeUpdate();
            if (insert) {
                contact.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        }
    }

    protected Contact getFromRS(ResultSet rs) throws SQLException, BGException {
        Contact contact = new Contact();
        contact.setContactTypeId(rs.getInt(this.tableName + ".type_id"));
        contact.setContractId(rs.getInt(this.tableName + ".contract_id"));
        contact.setValue(rs.getString(this.tableName + ".val"));
        contact.setId(rs.getInt(this.tableName + ".id"));
        String defaultValue = this.getDefaultValue(contact.getContactTypeId(), contact.getContractId());
        if (Utils.notBlankString((String)defaultValue)) {
            contact.setDefaultValue(defaultValue);
        }
        return contact;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDefaultValue(int contactTypeId, int contractId) {
        try {
            int pid = this.getPid(contactTypeId);
            if (pid <= 0) return null;
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                EntityAttr attr = contractDao.getContractParameter(contractId, pid);
                if (attr == null) return null;
                switch (attr.getType()) {
                    case 9: {
                        List list = ((EntityAttrEmail)attr).getContactList();
                        String string = list.isEmpty() ? null : ((EntityAttrEmail.EmailContact)list.get(0)).getAddress();
                        return string;
                    }
                    case 10: {
                        List list = ((EntityAttrPhone)attr).getUnformattedPhoneList();
                        String string = list.isEmpty() ? null : (String)list.get(0);
                        return string;
                    }
                    case 1: {
                        String string = ((EntityAttrText)attr).getValue();
                        return string;
                    }
                }
                String string = attr.toString();
                return string;
            }
        }
        catch (BGException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private int getPid(int contactTypeId) throws BGException {
        Integer pid = this.contactToPidMap.get(contactTypeId);
        if (pid == null) {
            ContactType ct;
            pid = -1;
            if (this.ctDao == null) {
                this.ctDao = new ContactTypeDao(this.con);
            }
            if ((ct = this.ctDao.get(contactTypeId)) != null) {
                pid = ct.getPid();
            }
            this.contactToPidMap.put(contactTypeId, pid);
        }
        return pid;
    }

    public Contact getContactFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs);
    }

    public List<Contact> getContactsOfContract(int contractId) throws BGException {
        return this.list("contract_id=?", "val", new Object[]{contractId});
    }

    public List<Contact> getContactsOfContract(int contractId, int contactTypeId) throws BGException {
        return this.list("contract_id=? AND type_id=?", "val", new Object[]{contractId, contactTypeId});
    }

    public List<Contact> getContacts(String contactsStr, int contractId) throws BGException {
        ArrayList<Contact> result = new ArrayList<Contact>();
        if (Utils.isBlankString((String)contactsStr)) {
            return result;
        }
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE contract_id=? AND id IN (" + contactsStr + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void deleteByType(int contactTypeId) throws BGException {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE type_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contactTypeId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteContactByContractId(int contractId) throws BGException {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE contract_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<ContractContact> getContracts(String name, int typeId) {
        ArrayList<ContractContact> contacts = new ArrayList<ContractContact>();
        try (PreparedStatement ps = this.getSearchPreparedStatement(name, typeId);){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractContact contact = new ContractContact();
                contact.setId(rs.getInt("id"));
                contact.setContractId(rs.getInt("cid"));
                contact.setContract(rs.getString("title"));
                contact.setValue(rs.getString("val"));
                contact.setComment(rs.getString("comment"));
                contact.setDefaultValue(rs.getString("def"));
                contacts.add(contact);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contacts;
    }

    private PreparedStatement getSearchPreparedStatement(String name, int contactType) throws BGException, SQLException {
        int pid = this.getPid(contactType);
        PreparedStatement ps = null;
        if (pid == -1) {
            String query = "SELECT contact.id, contract.id AS cid, contract.title, contact.val, contract.comment,'' AS def FROM dispatch_contact AS contact INNER JOIN dispatch_contact_type AS contact_type ON contact.type_id = contact_type.id INNER JOIN contract AS contract ON contact.contract_id = contract.id WHERE contact.val LIKE ? AND contact_type.id = ?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, "%" + name.trim() + "%");
            ps.setInt(2, contactType);
        } else {
            ContractParameterPrefType type = this.contractParameterManager.getParamPref(pid).getType();
            if (type.getId() != 1 && type.getId() != 3 && type.getId() != 9) {
                throw new BGException("\u041a\u043e\u043d\u0442\u0430\u043a\u0442 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
            }
            String val = "val";
            if (type.getId() == 3) {
                val = "email";
            } else if (type.getId() == 9) {
                val = "value";
            }
            String tableName = type.getTableName();
            String query = "SELECT contact.id, contract.id AS cid, contract.title, contact.val, contract.comment,param." + val + " AS def FROM dispatch_contact AS contact INNER JOIN dispatch_contact_type AS contact_type ON contact.type_id = contact_type.id INNER JOIN contract AS contract ON contact.contract_id = contract.id LEFT JOIN " + tableName + " AS param ON param.cid = contract.id AND param.pid = " + pid + " WHERE ((contact.val<>'' AND contact.val LIKE ?) OR (contact.val='' AND param." + val + " LIKE ?)) AND contact_type.id = ?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, "%" + name.trim() + "%");
            ps.setString(2, "%" + name.trim() + "%");
            ps.setInt(3, contactType);
        }
        return ps;
    }

    public void recycle() throws BGException {
        if (this.ctDao != null) {
            this.ctDao.recycle();
            this.ctDao = null;
        }
        this.contractParameterManager.close();
        this.contractParameterManager = null;
        super.recycle();
    }
}

