/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.sender;

import bitel.billing.server.util.MailMsg;
import jakarta.activation.DataSource;
import java.io.ByteArrayOutputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.server.mail.MailEmailSender;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.Sender;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class EmailSender
implements Sender {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public void send(Contact contact, String title, String messageBody, List<DataSource> messageFiles) throws BGException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(Contact contact, String title, String messageBody, List<DataSource> messageFiles, Subscription subscription) throws BGException {
        if (contact != null) {
            try {
                Preferences setup = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch").getSetup();
                MailEmailSender mailData = new MailEmailSender();
                mailData.setRecipients(contact.getValueForSend());
                mailData.setSubject(setup.get("message.title.prefix", "") + title);
                if (Utils.notBlankString((String)messageBody)) {
                    mailData.addTextPart("text", messageBody, "text/" + setup.get("message.text.type", "html") + "; charset=utf-8;");
                }
                int count = 1;
                for (DataSource file : messageFiles) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    outputStream.write(file.getInputStream().readAllBytes());
                    mailData.addPart("file" + count++, "attachment", file.getContentType(), file.getName(), outputStream.toByteArray());
                }
                new MailMsg((Preferences)Setup.getSetup()).sendMessage((MailData)mailData);
                if (!logger.isDebugEnabled()) return;
                logger.debug("\t\t\tEmail-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443 " + contact.getValueForSend() + " \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                return;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        } else {
            logger.warn("\t\t\t\u0412 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442! \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c email-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
        }
    }
}

