/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.task;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceFactory;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessage;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.bgbilling.plugins.dispatch.server.PluginServerListener;
import ru.bitel.bgbilling.plugins.dispatch.server.bean.MessageProcessor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.worker.ThreadContext;

public class DispatchWorker
extends TaskBase {
    private static final Logger logger = LogManager.getLogger();
    private static boolean inited = false;
    private static final Object mutex = new Object();
    private static Set<Dispatch> dispatchInSended = null;

    protected boolean initTask() {
        if (logger.isDebugEnabled()) {
            logger.debug("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0437\u0430\u0434\u0430\u0447\u0438 \u0440\u0430\u0441\u0441\u044b\u043b\u044c\u0449\u0438\u043a\u0430 \u043f\u043b\u0430\u0433\u0438\u043d\u0430 Dispatch.");
        }
        if (!inited) {
            PluginServerListener info = new PluginServerListener();
            info.onInitServer("?");
            dispatchInSended = new HashSet<Dispatch>();
            inited = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        ServerContext ctx = new ServerContext(Setup.getSetup(), 0, 0);
        ThreadContext parentContext = ThreadContext.push((ThreadContext)ctx);
        Dispatch dispatch = null;
        try {
            DispatchService ws = (DispatchService)ServiceFactory.newService((ServerContext)ctx, DispatchService.class, (int)0);
            MessageProcessor processor = new MessageProcessor(ctx.getConnection());
            List dispatchList = ws.getDispatchList();
            if (logger.isDebugEnabled()) {
                logger.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0431\u0449\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0440\u0430\u0441\u0441\u044b\u043b\u043e\u043a \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435 " + dispatchList.size() + " \u0448\u0442.");
            }
            for (Dispatch dispatch1 : dispatchList) {
                List messagesToSend;
                boolean isScheduledDispatch;
                if (logger.isDebugEnabled()) {
                    logger.debug("\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430 " + dispatch1.getTitle() + " (#ID:" + dispatch1.getId() + ")");
                }
                dispatch = dispatch1;
                boolean isActive = false;
                boolean inRun = false;
                isActive = dispatch.isActive();
                if (!isActive || (inRun = this.check(dispatch))) {
                    logger.debug("\t\u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u0430({}) \u0438\u043b\u0438 \u0432 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438({}) - \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c", (Object)(!isActive ? 1 : 0), (Object)inRun);
                    continue;
                }
                boolean bl = isScheduledDispatch = dispatch.getRepeatTime() != null;
                if (isScheduledDispatch && !dispatch.getRepeatTime().isTimeTick(this.getOperatingTime())) {
                    logger.debug("\t\u043f\u0435\u0440\u0435\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0430, \u0435\u0449\u0435 \u043d\u0435 \u0432\u0440\u0435\u043c\u044f - \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c");
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\t\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438");
                }
                if ((messagesToSend = ws.getMessageList(dispatch.getId(), true)).size() == 0) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("\t\t\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u0443\u0441\u0442 - \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c");
                    continue;
                }
                this.addDispatch(dispatch);
                if (logger.isDebugEnabled()) {
                    logger.debug("\t\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u043e\u0432 \u0434\u043b\u044f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438");
                }
                List subscriptionList = ws.getActiveSubscriptions(dispatch.getId());
                boolean isPersonalDispatch = dispatch.isPersonal();
                if (isPersonalDispatch) {
                    logger.debug("\t\u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0430");
                    this.removeWrongTimeSubscriptions(subscriptionList);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\t\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439");
                }
                for (DispatchMessage dispatchMessage : messagesToSend) {
                    logger.debug("\t\tC\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: {}", (Object)dispatchMessage.getTitle());
                    processor.send(dispatch, subscriptionList, dispatchMessage, ws);
                }
                this.removeDispatch(dispatch);
            }
            ctx.commit();
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.removeDispatch(dispatch);
            ThreadContext.pop((ThreadContext)ctx, (ThreadContext)parentContext);
        }
    }

    private void removeWrongTimeSubscriptions(List<Subscription> list) {
        Iterator<Subscription> iter = list.iterator();
        while (iter.hasNext()) {
            Subscription subscription = iter.next();
            try {
                if (subscription.getTotalRepeatTime().isTimeTick(this.getOperatingTime())) continue;
                iter.remove();
            }
            catch (NullPointerException e) {
                this.log.error("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0442\u044c \u043d\u0430 \u0432\u0440\u0435\u043c\u044f \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438", (Throwable)e);
            }
        }
    }

    public String getDescription() {
        return "\u041f\u043b\u0430\u0433\u0438\u043d \u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0438: \u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0440\u0430\u0441\u0441\u044b\u043b\u043e\u043a.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean check(Dispatch dispatch) {
        Object object = mutex;
        synchronized (object) {
            return dispatchInSended.contains(dispatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDispatch(Dispatch dispatch) {
        Object object = mutex;
        synchronized (object) {
            dispatchInSended.add(dispatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDispatch(Dispatch dispatch) {
        Object object = mutex;
        synchronized (object) {
            dispatchInSended.remove(dispatch);
        }
    }
}

