/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rcmts.server.servlet;

import bitel.billing.server.contract.bean.ContractModuleManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.dynamic.common.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.rcmts.server.bean.ContractDataHelper;
import ru.bitel.bgbilling.modules.rcmts.server.bean.RCConfigConstants;
import ru.bitel.bgbilling.modules.rcmts.server.bean.RCMtsRequestMethod;
import ru.bitel.bgbilling.modules.rcmts.server.bean.RCMtsResponseBuilder;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

@WebServlet(name="RCMtsExecutor", urlPatterns={"/rcmtsexecutor/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final Logger logger = LogManager.getLogger((String)ModuleExecutor.class.getSimpleName());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.info("Request from MTS. URL >>> " + req.getRequestURL());
        ThreadContext parent = ThreadContext.get();
        ServerContext serverContext = new ServerContext(this.setup, 0, 0);
        resp.setContentType("text/plain");
        ContractDataHelper contractDataHelper = null;
        try (Connection con = this.setup.getDBConnectionFromPool();
             ContractDao contractDao = new ContractDao(con, 0);){
            RCMtsResponseBuilder responseBuilder;
            Contract contract;
            serverContext.init();
            ThreadContext.set((ThreadContext)serverContext);
            int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)req);
            if (moduleId < 0) {
                logger.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c moduleId \u0438\u0437 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 = " + moduleId);
            }
            ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(moduleId));
            RCMtsRequestMethod requestMethod = this.defineRequestMethod(req);
            if (requestMethod == null) {
                String error = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 [" + req.getPathInfo() + "]";
                logger.error(error);
                this.sendError404(error, resp);
                return;
            }
            try {
                contract = this.defineContractByRequest(contractDao, req, requestMethod, moduleSetup);
            }
            catch (BGException ex) {
                logger.error(ex.getMessage());
                this.sendError404(ex.getMessage(), resp);
                contractDao.close();
                if (con != null) {
                    con.close();
                }
                if (contractDataHelper != null) {
                    try {
                        contractDataHelper.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (serverContext != null) {
                    serverContext.destroy();
                }
                ThreadContext.set((ThreadContext)parent);
                return;
            }
            logger.debug("\u041d\u0430\u0448\u043b\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438\u0437 \u0437\u0430\u043f\u0440\u043e\u0441\u0430. contractId=" + contract.getId() + ", contractTitle=" + contract.getTitle());
            ContractModuleManager contractModuleManager = new ContractModuleManager(con);
            boolean contractHasModule = contractModuleManager.getContractModuleSet(contract.getId()).contains(moduleId);
            if (!contractHasModule) {
                boolean autoAddModule = moduleSetup.getBoolean(RCConfigConstants.AUTO_ADD_MODULE_TO_CONTRACT.getKey(), false);
                if (!autoAddModule) {
                    String errorText = "\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0441 \u044d\u0442\u0438\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c - \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.";
                    logger.error(errorText);
                    this.sendError404(errorText, resp);
                    return;
                }
                contractModuleManager.addContractModule(contract.getId(), moduleId);
                serverContext.publishAfterCommit((Event)new ContractModifiedEvent(0, contract.getId()));
            }
            if ((responseBuilder = this.initializateResponceBuilder(serverContext, req, resp, contractDataHelper = new ContractDataHelper(contract, con, moduleId))) == null) {
                logger.error("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f RCMtsResponceBuilder \u0432 \u0434\u0438\u043d.\u043a\u043e\u0434\u0435!!");
                this.sendError404("\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435 \u043f\u0440\u0438 \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430.", resp);
                return;
            }
            resp.setContentType("application/json");
            responseBuilder.response(requestMethod);
            return;
        }
        catch (Exception e) {
            String errorText = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + e;
            logger.error(errorText);
            this.sendError404(errorText, resp);
            return;
        }
        finally {
            if (contractDataHelper != null) {
                try {
                    contractDataHelper.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (serverContext != null) {
                serverContext.destroy();
            }
            ThreadContext.set((ThreadContext)parent);
        }
    }

    private Contract defineContractByRequest(ContractDao contractDao, HttpServletRequest request, RCMtsRequestMethod requestMethod, ModuleSetup moduleSetup) throws BGException, IOException {
        Contract contract = null;
        String[] path = request.getPathInfo().split("/");
        int cid = -1;
        String contractTitle = null;
        switch (requestMethod) {
            case GET_VGROUPS: {
                cid = Utils.parseInt((String)request.getHeader("userid"), (int)-1);
                if (cid < 0) {
                    cid = Utils.parseInt((String)request.getHeader("agrmid"), (int)-1);
                }
                if (cid >= 0) break;
                cid = Utils.parseInt((String)request.getHeader("vgid"), (int)-1);
                break;
            }
            case GET_ACCOUNTS: {
                cid = Utils.parseInt((String)request.getHeader("userid"), (int)-1);
                contractTitle = request.getHeader("agrmnum");
                String prefix = moduleSetup.get(RCConfigConstants.MTS_ACCOUNT_PREFIX.getKey());
                if (contractTitle == null || !Utils.notBlankString((String)prefix) || !contractTitle.startsWith(prefix)) break;
                contractTitle = contractTitle.replaceFirst(prefix, "");
                break;
            }
            case BLOCK_VGROUPS: {
                cid = Utils.parseInt((String)path[5], (int)-1);
                break;
            }
            case TARIFS_RASP: 
            case GET_TARIF_RASP: 
            case DEL_TARIF_RASP: 
            case GET_AGREEMENTS: {
                if (path.length < 5) break;
                cid = Utils.parseInt((String)path[4], (int)-1);
            }
        }
        if (cid < 0 && Utils.isBlankString(contractTitle)) {
            throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c id \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438\u0437 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        if (cid > 0) {
            contract = (Contract)contractDao.get(cid);
        } else if (Utils.notBlankString(contractTitle)) {
            contract = contractDao.getByTitle(contractTitle);
        }
        if (contract == null) {
            throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0434\u043b\u044f cid = " + cid + ", title = " + contractTitle);
        }
        logger.info("Was finded contract with ID=" + contract.getId() + ", and title=" + contract.getTitle());
        return contract;
    }

    private RCMtsRequestMethod defineRequestMethod(HttpServletRequest request) {
        String[] uriParts = request.getRequestURI().split("/");
        if (uriParts == null || uriParts.length < 5) {
            return null;
        }
        RCMtsRequestMethod method = RCMtsRequestMethod.defineMethod(uriParts[5]);
        if (method == null) {
            method = RCMtsRequestMethod.defineMethod(uriParts[6]);
        }
        return method;
    }

    private RCMtsResponseBuilder initializateResponceBuilder(ServerContext serverContext, HttpServletRequest request, HttpServletResponse response, ContractDataHelper contractDataHelper) throws BGException {
        RCMtsResponseBuilder customResponseBuilder;
        List dynamicClasses = ((DynamicCodeService)serverContext.getService(DynamicCodeService.class, 0)).getDynamicClassesByInterface(RCMtsResponseBuilder.class.getName());
        if (Utils.isEmptyCollection((Collection)dynamicClasses)) {
            logger.error("DynCodeService -> \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043d\u0438 \u043e\u0434\u043d\u0443 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e RCMtsResponceBuilder");
            return null;
        }
        DynamicClass implClass = dynamicClasses.stream().filter(c -> !c.getClassName().contains("Default")).findFirst().orElse((DynamicClass)dynamicClasses.get(0));
        DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
        try {
            Class[] types = new Class[]{HttpServletRequest.class, HttpServletResponse.class, ContractDataHelper.class};
            customResponseBuilder = (RCMtsResponseBuilder)dynamicClassManager.newInstance(RCMtsResponseBuilder.class, implClass.getClassName(), types, new Object[]{request, response, contractDataHelper});
        }
        catch (BGException ex) {
            logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043a\u043b\u0430\u0441\u0441\u0430-\u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 RCMtsResponceBuilder");
            return null;
        }
        return customResponseBuilder;
    }

    private void sendError404(String text, HttpServletResponse response) throws IOException {
        JSONObject detail = new JSONObject();
        detail.put("detail", (Object)text);
        response.setStatus(404);
        response.getOutputStream().write(detail.toString().getBytes(StandardCharsets.UTF_8));
    }
}

