/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bvcom.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.bvcom.common.bean.Transaction;
import ru.bitel.bgbilling.modules.bvcom.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.bvcom.common.service.BVComService;
import ru.bitel.bgbilling.modules.bvcom.server.bean.BVParams;
import ru.bitel.bgbilling.modules.bvcom.server.bean.Constants;
import ru.bitel.bgbilling.modules.bvcom.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Bvcom")
public class ActionDoTransaction
extends AbstractPaymentAction {
    private BVParams params;
    private BVComService service;

    public ActionDoTransaction() {
        super("bvcom");
    }

    @PostConstruct
    public void init() {
        this.params = new BVParams(Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)));
        try {
            this.service = (BVComService)this.context.newService(BVComService.class, this.moduleId);
        }
        catch (BGException e) {
            e.printStackTrace();
        }
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws BGException {
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(null, this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
            transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.setResultParam("transactions", searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("bvcom.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("bvcom.sum.max", new BigDecimal(5000));
        String customerAddress = ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        try (TransactionManager transactionManager = new TransactionManager(this.setup.getDBConnection(true), this.moduleId);){
            transactionManager.registerOrder(this.contractId, ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle(), customerAddress, sum, this.getResult(), this.context.getRequest().getLocalAddr());
        }
        Object redirect = this.getResultParam("redirect");
        if (redirect != null) {
            try {
                this.setResultParam("contentType", ActionResultContentType.binary);
                this.context.getResponse().sendRedirect(String.valueOf(redirect));
                return;
            }
            catch (IOException ex) {
                this.execute();
                throw new BGMessageException(ex.getMessage());
            }
        }
        this.execute();
        throw new BGMessageException(this.getResultParam("error-message") + " [errorCode=" + this.getResultParam("error-code") + "; type=" + this.getResultParam("type") + "]");
    }

    public Result<Transaction> oldPay() throws Exception {
        Result result = new Result();
        BigDecimal sum = this.req.getBigDecimal("summa", BigDecimal.ZERO);
        if (this.params.getProtocolVersion() == 2) {
            if (sum.compareTo(BigDecimal.ZERO) > 0) {
                result.setAttribute("bvc_pay", (Object)4);
            } else {
                result.setAttribute("bvc_pay", (Object)3);
            }
        } else if (sum.compareTo(BigDecimal.ZERO) > 0) {
            Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(this.contractId)).setSum(sum)).build();
            this.service.addTransaction(transaction);
            String client = this.params.getClient();
            String currency = String.valueOf(BVParams.getOldProtocolCurrency());
            String number = this.params.getTransactionFormat().format(transaction.getId());
            MessageDigest messageDigest = MessageDigest.getInstance("md5");
            messageDigest.update(client.getBytes("ISO8859-1"));
            messageDigest.update(new String("|").getBytes("ISO8859-1"));
            messageDigest.update(number.getBytes("ISO8859-1"));
            messageDigest.update(new String("|").getBytes("ISO8859-1"));
            messageDigest.update(Utils.formatCost((BigDecimal)sum).getBytes("ISO8859-1"));
            messageDigest.update(new String("|").getBytes("ISO8859-1"));
            messageDigest.update(currency.getBytes("ISO8859-1"));
            messageDigest.update(new String("|").getBytes("ISO8859-1"));
            messageDigest.update(this.params.getKey().getBytes("ISO8859-1"));
            String sign = Utils.bytesToHexString((byte[])messageDigest.digest()).toLowerCase();
            result.setAttribute("client", (Object)client);
            result.setAttribute("number", (Object)number);
            result.setAttribute("amount", (Object)Utils.formatCost((BigDecimal)sum));
            result.setAttribute("currency", (Object)currency);
            result.setAttribute("description", (Object)this.params.getComment());
            result.setAttribute("sign", (Object)sign);
            result.setAttribute("bvc_pay", (Object)"2");
            result.setAttribute("url", (Object)this.params.getResultUrl());
        }
        return result;
    }
}

