/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn;

import bitel.billing.server.load.ProcessIn;
import bitel.billing.server.load.bean.Source;
import bitel.billing.server.netflow.ipn.NFUtil;
import bitel.billing.server.util.ByteParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Calendar;
import ru.bitel.bgbilling.modules.ipn.server.LogRecord;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public class BinaryLogProcessIn
extends ProcessIn {
    private InputStream inputStream;
    private byte[] data = new byte[20];
    private ByteParser byteParser = new ByteParser(this.data);

    public BinaryLogProcessIn(Setup setup, Source source, Calendar hour) {
        super(setup, source, hour);
        File file = NFUtil.getLogFile((DefaultServerSetup)setup, source.getId(), hour, false);
        try {
            if (file.exists()) {
                this.inputStream = new BufferedInputStream(new FileInputStream(file), 100000);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BinaryLogProcessIn(File logDir, Calendar hour) {
        super(null, null, hour);
        StringBuilder path = new StringBuilder(logDir.getAbsolutePath());
        path.append(TimeUtils.format((Calendar)hour, (String)"/yyyy/MM/dd"));
        path.append("/log_");
        path.append(new DecimalFormat("00").format(hour.get(11)));
        File file = new File(path.toString());
        try {
            this.inputStream = new BufferedInputStream(new FileInputStream(file), 100000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getRecord() {
        LogRecord result = null;
        if (this.inputStream == null) {
            return result;
        }
        try {
            if (this.inputStream.read(this.data) == 20) {
                result = new LogRecord();
                result.fromIp = this.byteParser.getLong(0, 4, "fromAddr");
                result.toIp = this.byteParser.getLong(4, 4, "toAddr");
                result.fromIface = this.byteParser.getInt(8, 2, "fromIface");
                result.toIface = this.byteParser.getInt(10, 2, "toIface");
                result.fromPort = this.byteParser.getInt(12, 2, "fromPort");
                result.toPort = this.byteParser.getInt(14, 2, "toPort");
                result.amount = this.byteParser.getLong(16, 4, "amount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void finishProcess() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

