/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.util.terminal.AbstractTerminalSession;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.ipn.server.AbstractMikrotikGateWorker;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.bgbilling.modules.ipn.server.bean.command.GateCommandUtil;
import ru.bitel.bgbilling.server.util.ssh.SSHSession;
import ru.bitel.common.Preferences;

public class MikrotikGateWorker
extends AbstractMikrotikGateWorker {
    @Override
    protected void doSync() {
        String host = this.gate.getHost();
        int port = this.gate.getPort();
        Preferences gateSetup = new Preferences(this.gate.getConfig(), "\r\n");
        String login = gateSetup.get("login", "root");
        String pswd = this.gate.getKeyword();
        if (this.log.isDebugEnabled()) {
            this.log.debug(" gate: " + host + ":" + port + " login: " + login + " pswd: " + pswd);
        }
        SSHSession session = null;
        int timeout = gateSetup.getInt("timeout", 0);
        try {
            session = new SSHSession(host, port, login, pswd);
            session.setTimeout(timeout);
            session.setRegexp("\\[.+?@.+?\\] >.*\\[.+?@.+?\\] >");
            session.connect();
            this.processSession((AbstractTerminalSession)session);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (BGException e) {
                    this.log.error((Object)e);
                }
            }
        }
    }

    public static String generateRule(String addresses, GateType gateType, RuleType ruleType, int cid) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("\\{CID\\}", String.valueOf(cid));
        String ruleText = GateCommandUtil.getRule(gateType, ruleType);
        String rule = GateCommandUtil.generateRule(ruleText, addresses, replacements, ruleType);
        return rule;
    }
}

