/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.Iface;
import ru.bitel.bgbilling.modules.ipn.server.bean.IfaceManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.Zone;
import ru.bitel.bgbilling.modules.ipn.server.bean.ZoneManager;

public class ActionIface
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int sourceId = this.getIntParameter("source_id", 0);
        if (this.mid <= 0 || sourceId <= 0) {
            throw new BGIllegalArgumentException();
        }
        Map<Integer, Zone> zoneMap = new ZoneManager(this.con, this.mid).getZoneMap();
        List<Iface> ifaceList = new IfaceManager(this.con, this.mid).getSourceIfaceList(sourceId);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (Iface iface : ifaceList) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(iface.getId()));
            row.setAttribute("number", String.valueOf(iface.getNumber()));
            row.setAttribute("title", iface.getTitle());
            row.setAttribute("zone_id", String.valueOf(iface.getZoneId()));
            row.setAttribute("source_id", String.valueOf(iface.getSourceId()));
            Zone zone = zoneMap.get(iface.getZoneId());
            if (zone == null) continue;
            row.setAttribute("zone", zone.getTitle());
        }
    }
}

