/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.radius;

import bitel.billing.server.processor.ipn.IPNSession;
import java.net.InetAddress;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.modules.ipn.server.radius.IPNLogin;
import ru.bitel.bgbilling.modules.ipn.server.radius.IPNNasConnection;
import ru.bitel.bgbilling.modules.ipn.server.radius.IPNRadiusProcessor;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class IPNNas
extends Nas<IPNNasConnection, DefaultServerSetup, IPNRadiusProcessor> {
    protected Map<String, IPNLogin> logins = new HashMap<String, IPNLogin>();
    private Map<String, List<IPNNasConnection>> userNameConnectionMap = new HashMap<String, List<IPNNasConnection>>(1024);

    public IPNNas(DefaultServerSetup setup, int moduleId, IPNRadiusProcessor processor, int id, IPNNas oldNas, InetAddress nasIPAddress, String nasIdentifier, int vendorCode, ParameterMap conf, byte[] secret, ConcurrentMap<Object, IPNNasConnection> connections, String script, NasConnectionInspector inspector) {
        super((Preferences)setup, moduleId, (RadiusProcessor)processor, id, (Nas)oldNas, nasIPAddress, nasIdentifier, vendorCode, conf, secret, connections, script, inspector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPNNasConnection setConnection(IPNNasConnection nasCon, RadiusPacket request, Connection zzz, Connection zzz2) {
        IPNNasConnection result = null;
        if (nasCon != null && request != null) {
            IPNSession session = (IPNSession)nasCon.getSession();
            if (request.getAttribute(-1, 5) != null) {
                List<IPNNasConnection> connections;
                Map<String, List<IPNNasConnection>> map;
                String loginName;
                long port = Utils.unsignedIntToLong((int)request.getIntAttribute(-1, 5, Integer.valueOf(0)));
                String _NAS_Port = String.valueOf(port);
                IPNNasConnection oldConnection = (IPNNasConnection)((Object)this.connections.get(_NAS_Port));
                if (oldConnection != null) {
                    loginName = ((IPNSession)oldConnection.getSession()).getLoginName();
                    map = this.userNameConnectionMap;
                    synchronized (map) {
                        connections = this.userNameConnectionMap.get(loginName);
                        if (connections != null) {
                            connections.remove((Object)oldConnection);
                        }
                    }
                }
                session.setNasId(this.getId());
                session.setNasPort(_NAS_Port);
                this.connections.put(_NAS_Port, nasCon);
                loginName = ((IPNSession)nasCon.getSession()).getLoginName();
                map = this.userNameConnectionMap;
                synchronized (map) {
                    connections = this.userNameConnectionMap.get(loginName);
                    if (connections == null) {
                        connections = new ArrayList<IPNNasConnection>(5);
                        this.userNameConnectionMap.put(loginName, connections);
                    }
                    connections.add(nasCon);
                }
                result = nasCon;
            }
        }
        return result;
    }

    public IPNNasConnection startConnection(RadiusListenerWorker<?> req, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) {
        String nasPort;
        IPNNasConnection nasCon;
        RadiusAttribute.RadiusAttributeInteger nasPortAttribute;
        if (request != null && (nasPortAttribute = (RadiusAttribute.RadiusAttributeInteger)request.getAttribute(-1, 5)) != null && (nasCon = (IPNNasConnection)((Object)this.connections.get(nasPort = String.valueOf(Utils.unsignedIntToLong((int)((Integer)nasPortAttribute.getValue())))))) != null) {
            nasCon.startConnection(this, request);
            return nasCon;
        }
        return null;
    }

    public IPNNasConnection updateConnection(RadiusListenerWorker<?> req, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPNNasConnection stopConnection(RadiusListenerWorker<?> req, RadiusPacket request, RadiusPacket response, ConnectionSet dbCon) {
        long port;
        String _NAS_Port;
        IPNNasConnection con;
        if (request != null && request.getAttribute(-1, 5) != null && (con = (IPNNasConnection)((Object)this.connections.get(_NAS_Port = String.valueOf(port = Utils.unsignedIntToLong((int)request.getIntAttribute(-1, 5, Integer.valueOf(0))))))) != null) {
            this.connections.remove(_NAS_Port);
            Map<String, List<IPNNasConnection>> map = this.userNameConnectionMap;
            synchronized (map) {
                List<IPNNasConnection> connections = this.userNameConnectionMap.get(((IPNSession)con.getSession()).getLoginName());
                if (connections != null) {
                    connections.remove((Object)con);
                    return con;
                }
            }
        }
        return null;
    }

    public void set(String login, IPNLogin ipnLogin) {
        this.logins.put(login, ipnLogin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killByLoginName(String loginName) {
        Map<String, List<IPNNasConnection>> map = this.userNameConnectionMap;
        synchronized (map) {
            List<IPNNasConnection> connections = this.userNameConnectionMap.get(loginName);
            if (connections != null) {
                for (IPNNasConnection con : connections) {
                    con.kill(this);
                }
                this.userNameConnectionMap.remove(loginName);
            }
        }
    }
}

