/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.server.bean;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelContractTariff;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelTariff;
import ru.bitel.bgbilling.modules.runtel.server.bean.RunTelContract;
import ru.bitel.bgbilling.modules.runtel.server.servlet.ModuleExecutor;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class RuntelManager {
    private static final Logger log = LogManager.getLogger();
    private ModuleSetup moduleSetup = null;

    public RuntelManager(int moduleId) {
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
    }

    public String getToken() {
        String runtelVersion = this.moduleSetup.get("runtel.version", "2");
        String action = "2".equals(runtelVersion) ? "auth" : "login";
        JSONObject jsonObject = this.getRequestJsonObject(action, "User");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("login", (Object)this.moduleSetup.get("runtel.login"));
        paramsJsonObject.put("password", (Object)this.moduleSetup.get("runtel.password"));
        jsonObject.put("params", (Object)paramsJsonObject);
        String token = null;
        try {
            JSONObject bodyJsonObject;
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200 && (bodyJsonObject = responceJsonObject.optJSONObject("body")) != null) {
                token = bodyJsonObject.optString("token", null);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return token;
    }

    public SearchResult<JSONObject> getCustomerList(String name, String status) {
        SearchResult result = new SearchResult();
        List list = result.getList();
        JSONObject jsonObject = this.getRequestJsonObject("list", "customer");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("name", (Object)name);
        paramsJsonObject.put("status", (Object)status);
        jsonObject.put("params", (Object)paramsJsonObject);
        try {
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200) {
                int recordCount = responceJsonObject.optInt("total_count");
                int pageSize = responceJsonObject.optInt("limit");
                int pageIndex = (responceJsonObject.optInt("offset") - responceJsonObject.optInt("offset") % pageSize) / pageSize + 1;
                Page page = new Page(pageIndex, pageSize);
                page.setRecordCount(recordCount);
                result.setPage(page);
                JSONArray listJsonArray = responceJsonObject.optJSONArray("list");
                if (listJsonArray != null) {
                    listJsonArray.forEach(e -> list.add((JSONObject)e));
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)e2);
            e2.printStackTrace();
        }
        return result;
    }

    public int appendCustomer(int customerId, String customerTitle, String customerBrand, String city, String status) {
        JSONObject jsonObject = this.getRequestJsonObject("append", "customer");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("bid", (Object)String.valueOf(customerId));
        paramsJsonObject.put("name", (Object)customerTitle);
        paramsJsonObject.put("brand", (Object)customerBrand);
        paramsJsonObject.put("city", (Object)city);
        paramsJsonObject.put("status", (Object)status);
        jsonObject.put("params", (Object)paramsJsonObject);
        int id = -1;
        try {
            JSONObject bodyJsonObject;
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200 && (bodyJsonObject = responceJsonObject.optJSONObject("body")) != null) {
                id = bodyJsonObject.optInt("id", 0);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return id;
    }

    public int updateCustomer(int customerId, String customerTitle) {
        JSONObject jsonObject = this.getRequestJsonObject("update", "customer");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("bid", (Object)String.valueOf(customerId));
        paramsJsonObject.put("name", (Object)customerTitle);
        jsonObject.put("params", (Object)paramsJsonObject);
        int id = -1;
        try {
            JSONObject bodyJsonObject;
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200 && (bodyJsonObject = responceJsonObject.optJSONObject("body")) != null) {
                id = bodyJsonObject.optInt("id", 0);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return id;
    }

    public boolean deleteCustomer(int customerId) {
        JSONObject jsonObject = this.getRequestJsonObject("delete", "customer");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("bid", (Object)String.valueOf(customerId));
        jsonObject.put("params", (Object)paramsJsonObject);
        boolean result = false;
        try {
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200) {
                result = true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return result;
    }

    public SearchResult<JSONObject> getContractList(int customerId, LocalDate dateFrom) {
        SearchResult result = new SearchResult();
        List list = result.getList();
        JSONObject jsonObject = this.getRequestJsonObject("list", "contract");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("customer_bid", customerId);
        paramsJsonObject.put("start_from", (Object)String.valueOf(dateFrom));
        jsonObject.put("params", (Object)paramsJsonObject);
        try {
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200) {
                int recordCount = responceJsonObject.optInt("total_count");
                int pageSize = responceJsonObject.optInt("limit");
                int pageIndex = (responceJsonObject.optInt("offset") - responceJsonObject.optInt("offset") % pageSize) / pageSize + 1;
                Page page = new Page(pageIndex, pageSize);
                page.setRecordCount(recordCount);
                result.setPage(page);
                JSONArray listJsonArray = responceJsonObject.optJSONArray("list");
                if (listJsonArray != null) {
                    listJsonArray.forEach(e -> list.add((JSONObject)e));
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)e2);
            e2.printStackTrace();
        }
        return result;
    }

    public int appendContract(int customerId, String contractTitle, String pbxDomain, LocalDate dateFrom, String status, String email, int hostId) {
        JSONObject jsonObject = this.getRequestJsonObject("append", "contract");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("customer_bid", (Object)String.valueOf(customerId));
        paramsJsonObject.put("name", (Object)contractTitle);
        paramsJsonObject.put("pbx_domain", (Object)pbxDomain);
        paramsJsonObject.put("start_from", (Object)String.valueOf(dateFrom));
        paramsJsonObject.put("status", (Object)status);
        paramsJsonObject.putOpt("email", (Object)email);
        paramsJsonObject.putOpt("host_id", (Object)hostId);
        jsonObject.put("params", (Object)paramsJsonObject);
        int id = -1;
        try {
            JSONObject bodyJsonObject;
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200 && (bodyJsonObject = responceJsonObject.optJSONObject("body")) != null) {
                id = bodyJsonObject.optInt("id", 0);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return id;
    }

    public int updateContract(int contractId, LocalDate dateTo, String status) {
        JSONObject jsonObject = this.getRequestJsonObject("update", "contract");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("bid", (Object)String.valueOf(contractId));
        paramsJsonObject.put("start_to", (Object)String.valueOf(dateTo));
        paramsJsonObject.put("status", (Object)status);
        jsonObject.put("params", (Object)paramsJsonObject);
        int id = -1;
        try {
            JSONObject bodyJsonObject;
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200 && (bodyJsonObject = responceJsonObject.optJSONObject("body")) != null) {
                id = bodyJsonObject.optInt("id", 0);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return id;
    }

    public boolean deleteContract(int contractId) {
        JSONObject jsonObject = this.getRequestJsonObject("delete", "contract");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("bid", (Object)String.valueOf(contractId));
        jsonObject.put("params", (Object)paramsJsonObject);
        boolean result = false;
        try {
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200) {
                result = true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return result;
    }

    public SearchResult<JSONObject> getContractAnnexList(int contractId, LocalDate dateFrom) {
        SearchResult result = new SearchResult();
        List list = result.getList();
        JSONObject jsonObject = this.getRequestJsonObject("list", "contract_annex");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("contract_bid", (Object)String.valueOf(contractId));
        jsonObject.put("params", (Object)paramsJsonObject);
        try {
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200) {
                int recordCount = responceJsonObject.optInt("total_count");
                int pageSize = responceJsonObject.optInt("limit");
                int pageIndex = (responceJsonObject.optInt("offset") - responceJsonObject.optInt("offset") % pageSize) / pageSize + 1;
                Page page = new Page(pageIndex, pageSize);
                page.setRecordCount(recordCount);
                result.setPage(page);
                JSONArray listJsonArray = responceJsonObject.optJSONArray("list");
                if (listJsonArray != null) {
                    listJsonArray.forEach(e -> list.add((JSONObject)e));
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)e2);
            e2.printStackTrace();
        }
        return result;
    }

    public int appendContractAnnex(int contractId, int tariffId, String name, Period period, String status, Map<String, Integer> services) {
        JSONObject jsonObject = this.getRequestJsonObject("append", "contract_annex");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("contract_bid", (Object)String.valueOf(contractId));
        paramsJsonObject.put("name", (Object)name);
        paramsJsonObject.put("date_start", (Object)String.valueOf(period.getLocalDateFrom()));
        paramsJsonObject.putOpt("date_end", (Object)String.valueOf(period.getLocalDateTo()));
        paramsJsonObject.put("status", (Object)status);
        paramsJsonObject.put("tariff", tariffId);
        JSONObject extensionJsonObject = new JSONObject();
        for (Map.Entry<String, Integer> service : services.entrySet()) {
            extensionJsonObject.put(service.getKey(), (Object)service.getValue());
        }
        paramsJsonObject.put("extension", (Object)extensionJsonObject);
        jsonObject.put("params", (Object)paramsJsonObject);
        int id = -1;
        try {
            JSONObject bodyJsonObject;
            JSONObject responceJsonObject;
            int code;
            if (log.isDebugEnabled()) {
                log.debug("Send data: {}", (Object)jsonObject.toString());
            }
            if ((code = (responceJsonObject = new JSONObject(this.doRequest(jsonObject, null))).optInt("code", 0)) == 200 && (bodyJsonObject = responceJsonObject.optJSONObject("body")) != null) {
                id = bodyJsonObject.optInt("id", 0);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return id;
    }

    public int updateContractAnnex(int contractId, LocalDate dateTo, String status) {
        JSONObject jsonObject = this.getRequestJsonObject("update", "contract_annex");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("contract_bid", (Object)String.valueOf(contractId));
        paramsJsonObject.putOpt("date_end", (Object)String.valueOf(dateTo));
        paramsJsonObject.put("status", (Object)status);
        jsonObject.put("params", (Object)paramsJsonObject);
        int id = -1;
        try {
            JSONObject bodyJsonObject;
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200 && (bodyJsonObject = responceJsonObject.optJSONObject("body")) != null) {
                id = bodyJsonObject.optInt("id", 0);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return id;
    }

    public boolean deleteContractAnnex(int contractAnnexId) {
        JSONObject jsonObject = this.getRequestJsonObject("delete", "contract");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("bid", (Object)String.valueOf(contractAnnexId));
        jsonObject.put("params", (Object)paramsJsonObject);
        boolean result = false;
        try {
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200) {
                result = true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return result;
    }

    public SearchResult<JSONObject> getContractAnnexRowList(int contractAnnexId, LocalDate dateFrom) {
        SearchResult result = new SearchResult();
        List list = result.getList();
        JSONObject jsonObject = this.getRequestJsonObject("list", "contract_annex_row");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("contract_annex_bid", contractAnnexId);
        jsonObject.put("params", (Object)paramsJsonObject);
        try {
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200) {
                int recordCount = responceJsonObject.optInt("total_count");
                int pageSize = responceJsonObject.optInt("limit");
                int pageIndex = (responceJsonObject.optInt("offset") - responceJsonObject.optInt("offset") % pageSize) / pageSize + 1;
                Page page = new Page(pageIndex, pageSize);
                page.setRecordCount(recordCount);
                result.setPage(page);
                JSONArray listJsonArray = responceJsonObject.optJSONArray("list");
                if (listJsonArray != null) {
                    listJsonArray.forEach(e -> list.add((JSONObject)e));
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)e2);
            e2.printStackTrace();
        }
        return result;
    }

    public int appendContractAnnexRow(int contractAnnexId, String tariffId, int count) {
        JSONObject jsonObject = this.getRequestJsonObject("append", "contract_annex_row");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("contract_bid", (Object)String.valueOf(contractAnnexId));
        paramsJsonObject.put("tariff_bid", (Object)tariffId);
        paramsJsonObject.put("count", count);
        jsonObject.put("params", (Object)paramsJsonObject);
        int id = -1;
        try {
            JSONObject bodyJsonObject;
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200 && (bodyJsonObject = responceJsonObject.optJSONObject("body")) != null) {
                id = bodyJsonObject.optInt("id", 0);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return id;
    }

    public int updateContractAnnexRow(int contractAnnexRowId, int count) {
        JSONObject jsonObject = this.getRequestJsonObject("update", "contract_annex_row");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("id", contractAnnexRowId);
        paramsJsonObject.put("count", count);
        jsonObject.put("params", (Object)paramsJsonObject);
        int id = -1;
        try {
            JSONObject bodyJsonObject;
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200 && (bodyJsonObject = responceJsonObject.optJSONObject("body")) != null) {
                id = bodyJsonObject.optInt("id", 0);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return id;
    }

    public boolean deleteContractAnnexRow(int contractAnnexRowId) {
        JSONObject jsonObject = this.getRequestJsonObject("delete", "contract_annex_row");
        JSONObject paramsJsonObject = new JSONObject();
        paramsJsonObject.put("id", contractAnnexRowId);
        jsonObject.put("params", (Object)paramsJsonObject);
        boolean result = false;
        try {
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, null));
            int code = responceJsonObject.optInt("code", 0);
            if (code == 200) {
                result = true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return result;
    }

    public boolean syncData(List<RunTelContract> contracts, Map<Integer, RunTelTariff> tariffs, String token) {
        if (contracts == null || tariffs == null) {
            return false;
        }
        JSONObject jsonObject = this.getRequestJsonObject("sync", "BGBilling");
        JSONArray contractListJSONArray = new JSONArray();
        for (RunTelContract runTelContract : contracts) {
            RunTelTariff runTelTariff;
            JSONObject contractJsonObject = new JSONObject();
            contractJsonObject.put("bid", (Object)String.valueOf(runTelContract.getContractId()));
            contractJsonObject.put("name", (Object)runTelContract.getContractTitle());
            contractJsonObject.putOpt("customer_name", (Object)(Utils.notBlankString((String)runTelContract.getContractComment()) ? runTelContract.getContractComment() : runTelContract.getContractTitle()));
            contractJsonObject.putOpt("signing_date", (Object)String.valueOf(runTelContract.getPeriod().getLocalDateFrom()));
            contractJsonObject.put("status", (Object)(runTelContract.getStatus() == 1 ? "e" : "d"));
            contractJsonObject.putOpt("email", (Object)(runTelContract.getEmail() == null ? "user@abcdfe.ru" : runTelContract.getEmail()));
            contractJsonObject.putOpt("hash", (Object)this.getHash(contractJsonObject));
            RunTelContractTariff runTelContractTariff = runTelContract.getTariff();
            if (runTelContractTariff != null && (runTelTariff = tariffs.get(runTelContractTariff.getTariffId())) != null) {
                Object key2;
                LocalDateTime dateEnd = runTelContractTariff.getPeriod().getLocalDateTimeTo();
                JSONObject annexJsonObject = new JSONObject();
                annexJsonObject.put("number", (Object)(runTelTariff.getTitle() + "-" + TimeUtils.format((Date)runTelContractTariff.getPeriod().getDateFrom(), (String)"yyyyMMdd")));
                annexJsonObject.put("date_start", (Object)this.getFormatDateTime(runTelContractTariff.getPeriod().getLocalDateTimeFrom().truncatedTo(ChronoUnit.SECONDS)));
                annexJsonObject.putOpt("date_end", (Object)this.getFormatDateTime(dateEnd != null ? dateEnd.truncatedTo(ChronoUnit.SECONDS) : null));
                annexJsonObject.put("status", (Object)"e");
                annexJsonObject.put("tariff_id", (Object)String.valueOf(runTelContractTariff.getTariffId()));
                annexJsonObject.putOpt("hash", (Object)this.getHash(annexJsonObject));
                LinkedHashMap<String, Integer> extensionMap = new LinkedHashMap<String, Integer>();
                JSONObject tariffJsonObject = new JSONObject(runTelTariff.getConfig());
                JSONObject includeJsonObject = tariffJsonObject.optJSONObject("include");
                for (Object key2 : includeJsonObject.keySet()) {
                    if (!((String)key2).startsWith("runtel")) continue;
                }
                JSONObject additionalJsonObject = new JSONObject(runTelContractTariff.getConfig());
                key2 = includeJsonObject.keySet().iterator();
                while (key2.hasNext()) {
                    String key3 = (String)key2.next();
                    if (!key3.startsWith("runtel")) continue;
                    extensionMap.put(key3, extensionMap.getOrDefault(key3, 0) + additionalJsonObject.optInt(key3, 0));
                }
                JSONObject extensionJsonObject = new JSONObject();
                for (Map.Entry entry : extensionMap.entrySet()) {
                    extensionJsonObject.put((String)entry.getKey(), entry.getValue());
                }
                extensionJsonObject.putOpt("hash", (Object)this.getHash(extensionJsonObject));
                annexJsonObject.put("extension", (Object)extensionJsonObject);
                contractJsonObject.put("annex", (Object)annexJsonObject);
            }
            contractListJSONArray.put((Object)contractJsonObject);
        }
        JSONObject contractListJsonObject = new JSONObject();
        contractListJsonObject.put("contract_list", (Object)contractListJSONArray);
        jsonObject.put("params", (Object)contractListJsonObject);
        boolean result = false;
        try {
            int code;
            if (log.isTraceEnabled()) {
                log.trace("TOKEN: " + token);
                log.trace("\u0417\u0410\u041f\u0420\u041e\u0421: " + jsonObject.toString());
            }
            JSONObject responceJsonObject = new JSONObject(this.doRequest(jsonObject, token));
            if (log.isTraceEnabled()) {
                log.trace("\u041e\u0422\u0412\u0415\u0422: " + responceJsonObject.toString());
            }
            if ((code = responceJsonObject.optInt("code", 0)) == 200) {
                JSONObject errorsJsonObject;
                result = true;
                JSONObject bodyJsonObject = responceJsonObject.optJSONObject("body");
                if (bodyJsonObject != null && (errorsJsonObject = bodyJsonObject.optJSONObject("errors")) != null && errorsJsonObject.length() > 0) {
                    log.error(responceJsonObject.toString());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return result;
    }

    public static JSONObject getResponse(ModuleExecutor.Action action) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("action", (Object)action.getAction());
        jsonObject.put("action_id", (Object)action.getActionId());
        jsonObject.put("obj", (Object)action.getObj());
        Page page = action.getPage();
        if (page != null) {
            jsonObject.put("limit", page.getPageSize());
            jsonObject.put("offset", (page.getPageIndex() == 1 ? 0 : page.getPageIndex() - 1) * page.getPageSize());
            jsonObject.put("count", page.getRecordCount());
        }
        return jsonObject;
    }

    private String getFormatDateTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "";
        }
        OffsetDateTime offsetDateTime = localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime();
        return offsetDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private JSONObject getRequestJsonObject(String action, String obj) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("action", (Object)action);
        jsonObject.put("action_id", (Object)String.valueOf(System.currentTimeMillis()));
        jsonObject.put("obj", (Object)obj);
        return jsonObject;
    }

    private String doRequest(JSONObject jsonObject, String token) throws IOException {
        String runtelVersion = this.moduleSetup.get("runtel.version", "2");
        String runtelURL = "https://villaribo.runtel.ru/integration/ext_bill/bgb/v2/";
        String runtelTokenHeaderName = "Authorization";
        String runtelTokenHeaderValuePrefix = "Bearer ";
        switch (runtelVersion) {
            case "1": {
                runtelURL = "https://villaribo.runtel.ru/integration/ext_bill/bgb/v1/";
                runtelTokenHeaderName = "Token";
                runtelTokenHeaderValuePrefix = "";
                break;
            }
            case "2": {
                runtelURL = "https://villaribo.runtel.ru/integration/ext_bill/bgb/v2/";
                runtelTokenHeaderName = "Authorization";
                runtelTokenHeaderValuePrefix = "Bearer ";
                break;
            }
        }
        URL url = new URL(this.moduleSetup.get("runtel.url", runtelURL));
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setConnectTimeout(this.moduleSetup.getInt("runtel.request.timeout", 10000));
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        if (token != null) {
            httpURLConnection.setRequestProperty(runtelTokenHeaderName, runtelTokenHeaderValuePrefix + token);
        }
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(jsonObject.toString().getBytes());
        outputStream.close();
        httpURLConnection.connect();
        StringBuilder resultJson = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        if (br.ready()) {
            String line = null;
            resultJson = new StringBuilder();
            while ((line = br.readLine()) != null) {
                resultJson.append(line);
            }
        }
        httpURLConnection.disconnect();
        return resultJson.toString();
    }

    private String getHash(JSONObject jsonObject) {
        if (jsonObject != null) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                for (String key : jsonObject.keySet()) {
                    digest.update(String.valueOf(jsonObject.get(key)).getBytes("UTF-8"));
                }
                return Utils.bytesToHexString((byte[])digest.digest());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

