/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.common.event.access.om;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.om.AccountOrderEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntime;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.sql.ConnectionSet;

@EventType(autoAcknowledge=false, timeToLive=691200000L)
@XmlRootElement
public class OmTvAccountModifyEvent
extends QueueEvent {
    private static final Logger logger = LogManager.getLogger();
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(OmTvAccountModifyEvent.class);
    private final int deviceId;
    private final TvAccount oldTvAccount;
    private final TvAccount newTvAccount;
    @XmlAttribute
    private final short newState;

    protected OmTvAccountModifyEvent() {
        super(-1, -1, -1);
        this.deviceId = -1;
        this.oldTvAccount = null;
        this.newTvAccount = null;
        this.newState = (short)-1;
    }

    public OmTvAccountModifyEvent(int moduleId, int deviceId, TvAccount oldTvAccount, TvAccount newTvAccount, short newState) {
        super(moduleId, oldTvAccount != null ? oldTvAccount.getContractId() : newTvAccount.getContractId(), -1);
        this.deviceId = deviceId;
        this.oldTvAccount = oldTvAccount;
        this.newTvAccount = newTvAccount;
        this.newState = newState;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.oldTvAccount != null ? this.oldTvAccount.getDeviceId() : this.newTvAccount.getDeviceId());
    }

    public TvAccount getOldTvAccount() {
        return this.oldTvAccount;
    }

    public TvAccount getNewTvAccount() {
        return this.newTvAccount;
    }

    public short getNewState() {
        return this.newState;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ").append(this.deviceId);
        sb.append("; oldTvAccount: ").append(this.oldTvAccount);
        sb.append("; newTvAccount: ").append(this.newTvAccount);
        sb.append("; newState: ").append(this.newState);
    }

    public AccountOrderEvent toOmEvent(TvAccess access, ConnectionSet connectionSet, Date now) throws BGException {
        Set<Integer> newDeviceOptionIds;
        Set<Integer> oldDeviceOptionIds;
        short deviceState;
        TvAccountSpecRuntime tvAccountSpecRuntime;
        int eventType;
        int newDeviceId;
        int oldDeviceId;
        Integer tvAccountId;
        TvAccount oldTvAccount = this.getOldTvAccount();
        TvAccount newTvAccount = this.getNewTvAccount();
        if (oldTvAccount != null && newTvAccount != null) {
            tvAccountId = newTvAccount.getId();
            oldDeviceId = oldTvAccount.getDeviceId();
            newDeviceId = newTvAccount.getDeviceId();
            eventType = 2;
        } else if (newTvAccount != null) {
            tvAccountId = newTvAccount.getId();
            oldDeviceId = 0;
            newDeviceId = newTvAccount.getDeviceId();
            eventType = 1;
        } else {
            tvAccountId = oldTvAccount.getId();
            oldDeviceId = oldTvAccount.getDeviceId();
            newDeviceId = 0;
            eventType = 3;
        }
        if (newDeviceId <= 0 || oldDeviceId > 0) {
            // empty if block
        }
        TvAccountRuntime tvAccountRuntime = access.tvAccountRuntimeMap.get(tvAccountId);
        boolean tvAccountRuntimeFromCache = false;
        if (tvAccountRuntime == null) {
            switch (eventType) {
                case 1: {
                    tvAccountRuntime = access.tvAccountRuntimeMap.addRuntime(connectionSet, newTvAccount);
                    tvAccountSpecRuntime = (TvAccountSpecRuntime)access.tvAccountSpecRuntimeMap.get(newTvAccount.getSpecId());
                    break;
                }
                case 3: {
                    tvAccountRuntime = access.tvAccountRuntimeMap.newRuntime(connectionSet, oldTvAccount);
                    tvAccountSpecRuntime = (TvAccountSpecRuntime)access.tvAccountSpecRuntimeMap.get(oldTvAccount.getSpecId());
                    break;
                }
                default: {
                    logger.error("TvAccountRuntime not found with tvAccountId=" + tvAccountId);
                    return null;
                }
            }
            deviceState = -1;
            oldDeviceOptionIds = Collections.emptySet();
        } else {
            tvAccountSpecRuntime = (TvAccountSpecRuntime)tvAccountRuntime.tvAccountSpecRef.get();
            deviceState = tvAccountRuntime.getTvAccount().getDeviceState();
            oldDeviceOptionIds = tvAccountRuntime.getTvAccount().getDeviceOptionIds();
            if (tvAccountRuntime.isCreated()) {
                tvAccountRuntimeFromCache = true;
            }
        }
        if (tvAccountRuntime == null) {
            logger.error("tvAccountRuntime is null. Skipping task");
            return null;
        }
        if (tvAccountRuntime.getTvAccount().getParentId() > 0) {
            logger.error("TvAccount is child " + tvAccountId);
            return null;
        }
        tvAccountRuntime.setCreated(true);
        if (tvAccountRuntimeFromCache && eventType == 1 && deviceState != -1) {
            eventType = 2;
            oldTvAccount = tvAccountRuntime.getTvAccount();
        }
        if (oldDeviceOptionIds == null) {
            oldDeviceOptionIds = Collections.emptySet();
        }
        if ((newDeviceOptionIds = access.tvAccountOptionSet(connectionSet, tvAccountRuntime, new Date())) == null) {
            newDeviceOptionIds = oldDeviceOptionIds;
        }
        return new AccountOrderEvent(access, (Event)this, this.deviceId, tvAccountRuntime, eventType, tvAccountId.intValue(), tvAccountSpecRuntime.tvAccountSpec, oldTvAccount, newTvAccount, deviceState, this.getNewState(), oldDeviceOptionIds, newDeviceOptionIds, 0);
    }
}

