/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.common.event.access.om;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.om.AbstractOrderEvent;
import ru.bitel.bgbilling.apps.tv.access.om.AccountOrderEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntime;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

@EventType(autoAcknowledge=false, timeToLive=691200000L)
@XmlRootElement
public class OmTvAccountServicesModify
extends QueueEvent {
    private static final transient Logger logger = LogManager.getLogger();
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int tvAccountId;
    @XmlAttribute
    private final Set<Integer> serviceIds;

    protected OmTvAccountServicesModify() {
        this.deviceId = -1;
        this.tvAccountId = -1;
        this.serviceIds = null;
    }

    public OmTvAccountServicesModify(int moduleId, int userId, TvAccount tvAccount, Set<Integer> optionSet) {
        this(moduleId, tvAccount.getContractId(), userId, tvAccount.getDeviceId(), tvAccount.getId(), optionSet);
    }

    private OmTvAccountServicesModify(int moduleId, int contractId, int userId, int deviceId, int tvAccountId, Set<Integer> serviceIds) {
        super(moduleId, contractId, userId);
        this.deviceId = deviceId;
        this.tvAccountId = tvAccountId;
        this.serviceIds = serviceIds;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getTvAccountId() {
        return this.tvAccountId;
    }

    public Set<Integer> getServiceIds() {
        return this.serviceIds;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; tvAccountId: ");
        sb.append(this.tvAccountId);
        sb.append("; serviceIds: ");
        sb.append(Utils.toString(this.serviceIds));
    }

    public AccountOrderEvent toOmEvent(TvAccess access, ConnectionSet connectionSet, Date now) throws BGException {
        Set<Integer> newDeviceOptionIds;
        TvAccountRuntime tvAccountRuntime = access.tvAccountRuntimeMap.get(Integer.valueOf(this.tvAccountId));
        if (tvAccountRuntime == null) {
            logger.error("TvAccountRuntime not found with id=" + this.tvAccountId);
            return null;
        }
        TvAccount tvAccount = tvAccountRuntime.getTvAccount();
        if (tvAccount.getParentId() > 0) {
            logger.error("TvAccount is child " + this.tvAccountId);
            return null;
        }
        Set<Integer> oldDeviceOptionIds = tvAccount.getDeviceOptionIds();
        if (oldDeviceOptionIds == null) {
            oldDeviceOptionIds = Collections.emptySet();
        }
        if ((newDeviceOptionIds = access.tvAccountOptionSet(connectionSet, tvAccountRuntime, new Date())) == null) {
            newDeviceOptionIds = oldDeviceOptionIds;
        }
        List childrenAccounts = AbstractOrderEvent.getTvAccountChildren((TvAccountRuntimeMap)access.tvAccountRuntimeMap, (int)tvAccount.getId(), (long)now.getTime());
        tvAccount.setChildren(childrenAccounts);
        AccountOrderEvent result = new AccountOrderEvent(access, (Event)this, 0, tvAccountRuntime, 2, tvAccount.getId(), ((TvAccountSpecRuntime)tvAccountRuntime.tvAccountSpecRef.get()).tvAccountSpec, tvAccount, tvAccount, tvAccount.getDeviceState(), tvAccount.getDeviceState(), oldDeviceOptionIds, newDeviceOptionIds, 0);
        return result;
    }
}

