/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.common.event.access.om;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.om.AbstractOrderEvent;
import ru.bitel.bgbilling.apps.tv.access.om.AccountOrderEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntime;
import ru.bitel.common.sql.ConnectionSet;

@EventType(autoAcknowledge=false, timeToLive=691200000L)
@XmlRootElement
public class OmTvAccountStateModifyEvent
extends QueueEvent {
    private static final transient Logger logger = LogManager.getLogger();
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int tvAccountId;
    @XmlAttribute
    private final short state;
    @XmlAttribute
    private final int accessCode;
    private final boolean recheck;

    protected OmTvAccountStateModifyEvent() {
        this.deviceId = -1;
        this.tvAccountId = -1;
        this.state = (short)-1;
        this.accessCode = -1;
        this.recheck = false;
    }

    public OmTvAccountStateModifyEvent(int moduleId, int userId, TvAccount tvAccount, short state, int accessCode) {
        this(moduleId, tvAccount.getContractId(), userId, tvAccount.getDeviceId(), tvAccount.getId(), 0L, state, accessCode, false);
    }

    public OmTvAccountStateModifyEvent(int moduleId, int userId, TvAccount tvAccount, short state, int accessCode, boolean recheck) {
        this(moduleId, tvAccount.getContractId(), userId, tvAccount.getDeviceId(), tvAccount.getId(), 0L, state, accessCode, recheck);
    }

    public OmTvAccountStateModifyEvent(int moduleId, int contractId, int userId, int deviceId, int tvAccountId, long connectionId, short state, int accessCode, boolean recheck) {
        super(moduleId, contractId, userId);
        this.deviceId = deviceId;
        this.tvAccountId = tvAccountId;
        this.state = state;
        this.accessCode = accessCode;
        this.recheck = recheck;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getTvAccountId() {
        return this.tvAccountId;
    }

    public short getState() {
        return this.state;
    }

    public int getAccessCode() {
        return this.accessCode;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; tvAccountId: ");
        sb.append(this.tvAccountId);
        sb.append("; state: ");
        sb.append(this.state);
        sb.append("; accessCode: ");
        sb.append(this.accessCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountOrderEvent toOmEvent(TvAccess access, ConnectionSet connectionSet, Date now) throws BGException {
        boolean forceRecheck;
        TvAccountRuntime tvAccountRuntime = access.tvAccountRuntimeMap.get(Integer.valueOf(this.tvAccountId));
        if (tvAccountRuntime == null) {
            logger.error("TvAccountRuntime not found with id=" + this.tvAccountId);
            return null;
        }
        TvAccount tvAccount = tvAccountRuntime.getTvAccount();
        short oldState = tvAccount.getDeviceState();
        if (tvAccount.getParentId() > 0) {
            logger.error("TvAccount is child " + this.tvAccountId);
            return null;
        }
        if (oldState == this.getState()) {
            logger.debug("TvAccount state already " + this.getState());
            return null;
        }
        short newState = this.state;
        Set<Integer> newDeviceOptionIds = null;
        boolean bl = forceRecheck = System.currentTimeMillis() - this.getTimestamp() > 3600000L;
        if (forceRecheck || this.recheck) {
            switch (newState) {
                case 0: {
                    AuthResult authResult;
                    if (forceRecheck) {
                        logger.info("Recieved old event, force reauthorization");
                        authResult = access.authorization(connectionSet, tvAccountRuntime, now, null);
                        short s = newState = authResult.accessCode == 0 ? (short)1 : 0;
                        if (oldState == newState) {
                            logger.debug("TvAccount state already " + newState);
                            return null;
                        }
                        if (authResult.accessCode != 0) break;
                        newDeviceOptionIds = authResult.optionSet;
                        break;
                    }
                    if (this.accessCode != 12) break;
                    authResult = access.authorization(connectionSet, tvAccountRuntime, now, null);
                    if (authResult.req != null && authResult.req.isIgnoreBalanceInsufficient()) {
                        logger.info("Skip disable tvAccount by balance (ignoreBalanceInsufficient)");
                        return null;
                    }
                    if (authResult.accessCode != 0) break;
                    newDeviceOptionIds = authResult.optionSet;
                    break;
                }
                case 1: {
                    AuthResult authResult = access.authorization(connectionSet, tvAccountRuntime, now, null);
                    switch (authResult.accessCode) {
                        case 20: 
                        case 44: {
                            logger.info("Skip enable serv by accessCode=" + authResult.accessCode);
                            return null;
                        }
                        case 0: {
                            newDeviceOptionIds = authResult.optionSet;
                            break;
                        }
                    }
                    if (!forceRecheck) break;
                    logger.info("Recieved old event, force reauthorization");
                    short s = newState = authResult.accessCode == 0 ? (short)1 : 0;
                    if (oldState != newState) break;
                    logger.debug("TvAccount state already " + newState);
                    return null;
                }
            }
        }
        if (oldState == -1 && this.getState() == -1) {
            logger.error("DeviceState DELETED in OmTvAccountStateModifyEvent!");
            return null;
        }
        tvAccountRuntime.lock();
        try {
            AccountOrderEvent result;
            List childrenAccounts = AbstractOrderEvent.getTvAccountChildren((TvAccountRuntimeMap)access.tvAccountRuntimeMap, (int)tvAccount.getId(), (long)now.getTime());
            tvAccount.setChildren(childrenAccounts);
            Set<Integer> oldDeviceOptionIds = tvAccount.getDeviceOptionIds();
            if (oldDeviceOptionIds == null) {
                oldDeviceOptionIds = Collections.emptySet();
            }
            if (newDeviceOptionIds == null && (newDeviceOptionIds = access.tvAccountOptionSet(connectionSet, tvAccountRuntime, now)) == null) {
                newDeviceOptionIds = oldDeviceOptionIds;
            }
            int eventType = 2;
            if (!(oldState != 1 && oldState != 0 || this.state != 1 && this.state != 0)) {
                eventType = 4;
            }
            AccountOrderEvent accountOrderEvent = result = new AccountOrderEvent(access, (Event)this, this.deviceId, tvAccountRuntime, eventType, this.tvAccountId, ((TvAccountSpecRuntime)tvAccountRuntime.tvAccountSpecRef.get()).tvAccountSpec, tvAccount, tvAccount, oldState, this.getState(), oldDeviceOptionIds, newDeviceOptionIds, this.accessCode);
            return accountOrderEvent;
        }
        finally {
            tvAccountRuntime.unlock();
        }
    }
}

