/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client;

import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelMonth;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.time.LocalDate;
import java.util.Date;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractGroupService;
import ru.bitel.bgbilling.modules.tv.common.service.TvService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUCheckList;

public class TvRecalculatorPanel
extends BGUPanel {
    private BGUCheckList<ContractGroup> contractGroups;
    private BGControlPanelContractSelect contracts;
    private BGControlPanelMonth period;
    private BGTextField email;
    AbstractBGUPanel.DefaultAction refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ContractGroupService contractGroupService = (ContractGroupService)((ClientContext)TvRecalculatorPanel.this.getContext()).getPort(ContractGroupService.class, 0);
            TvRecalculatorPanel.this.contractGroups.setData(contractGroupService.contractGroupList(false, "title"));
        }
    };
    AbstractBGUPanel.DefaultAction recalculate = new AbstractBGUPanel.DefaultAction("recalculate", "\u0417\u0430\u043f\u0443\u0441\u043a"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            LocalDate calendar = TvRecalculatorPanel.this.period.getLocalDate();
            calendar = calendar.withDayOfMonth(1);
            Date dateFrom = TimeUtils.convertLocalDateToDate((LocalDate)calendar);
            calendar = calendar.plusMonths(1L).minusDays(1L);
            Date dateTo = TimeUtils.convertLocalDateToDate((LocalDate)calendar);
            TvService tvService = (TvService)((ClientContext)TvRecalculatorPanel.this.getContext()).getPort(TvService.class);
            tvService.recalculate(TvRecalculatorPanel.this.email.getText(), dateFrom, dateTo, TvRecalculatorPanel.this.contractGroups.getSelectedIds(), Utils.toIntegerSet((String)TvRecalculatorPanel.this.contracts.getContracts()));
        }
    };

    public TvRecalculatorPanel() {
        super((LayoutManager)new GridBagLayout());
    }

    protected void jbInit() throws Exception {
        this.contractGroups = new BGUCheckList();
        this.contracts = new BGControlPanelContractSelect();
        this.period = new BGControlPanelMonth();
        this.email = new BGTextField();
        this.add(BGSwingUtilites.wrapBorder(this.contractGroups, (String)"\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432"), new GridBagConstraints(0, 0, 1, 4, 0.3, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.contracts, new GridBagConstraints(1, 0, 1, 1, 0.7, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder((JComponent)this.period, (String)"\u041f\u0435\u0440\u0438\u043e\u0434", (boolean)false), new GridBagConstraints(1, 1, 1, 1, 0.7, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel start = new JPanel(new GridBagLayout());
        start.add((Component)new JLabel("\u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043d\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 3), 0, 0));
        start.add((Component)this.email, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        start.add((Component)new BGButton((Action)this.recalculate), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder((JPanel)start, (String)"\u041f\u0443\u0441\u043a"), new GridBagConstraints(1, 2, 1, 1, 0.7, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(1, 3, 1, 1, 0.7, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

