/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.accounting;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.accounting.ProductPeriodRuntimeQueue;
import ru.bitel.bgbilling.apps.tv.accounting.TvAccounting;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.tv.common.bean.ProlongationType;
import ru.bitel.bgbilling.modules.tv.server.ProductManager;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeRoot;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvTarifficationManager;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.TimeoutMap;
import ru.bitel.common.worker.BatchWorker;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductPeriodDao;

public final class ProductPeriodWorker
extends BatchWorker<ProductPeriodRuntimeQueue.Entry, TvTariffWorkerContext> {
    private static final Logger logger = LogManager.getLogger();
    private final TvAccounting tvAccounting;
    private final ProductPeriodRuntimeQueue queue;
    private final PoolEventPublisher<ContractBalanceChangedEvent> balanceEP;
    private ConnectionSet connectionSet;
    private ProductManager productPeriodManager;
    private ProductPeriodDao productPeriodDao;
    private TvTarifficationManager tvTarifficationManager;
    private final TimeoutMap<Task, Boolean> processedTasksMap = new TimeoutMap("prcssdTsksMap-worker");
    private final Comparator<ProductPeriodRuntimeList.ProductPeriodItem> comparator = new Comparator<ProductPeriodRuntimeList.ProductPeriodItem>(){

        @Override
        public int compare(ProductPeriodRuntimeList.ProductPeriodItem o1, ProductPeriodRuntimeList.ProductPeriodItem o2) {
            try {
                ProductSpecRuntime productSpecRuntime1 = (ProductSpecRuntime)ProductPeriodWorker.this.tvAccounting.productSpecRuntimeMap.get(o1.productSpecId);
                ProductSpecRuntime productSpecRuntime2 = (ProductSpecRuntime)ProductPeriodWorker.this.tvAccounting.productSpecRuntimeMap.get(o2.productSpecId);
                return productSpecRuntime2.productSpec.getId() - productSpecRuntime1.productSpec.getId();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                return 0;
            }
        }
    };

    public ProductPeriodWorker(TvAccounting tvAccounting, ProductPeriodRuntimeQueue queue) {
        this.tvAccounting = tvAccounting;
        this.queue = queue;
        logger.info("Starting ProductPeriodWorker");
        this.balanceEP = EventProcessor.getInstance().newPoolEventPublisher(ContractBalanceChangedEvent.class, 0);
        this.context = new TvTariffWorkerContext(tvAccounting.setup, tvAccounting.moduleId);
        new Thread((Runnable)((Object)this), "product-period-worker").start();
    }

    protected ProductPeriodRuntimeQueue.Entry takeImpl() throws BGException, InterruptedException {
        return this.queue.take();
    }

    protected ProductPeriodRuntimeQueue.Entry pollImpl(long timeout) throws InterruptedException, BGException {
        return this.queue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runWorker() throws BGException {
        try {
            this.connectionSet = ((TvTariffWorkerContext)this.context).getConnectionSet();
            Connection con = this.connectionSet.getConnection();
            this.productPeriodManager = new ProductManager((ServerContext)this.context, this.tvAccounting.moduleId);
            this.productPeriodDao = new ProductPeriodDao(con, 0);
            this.tvTarifficationManager = new TvTarifficationManager(((TvTariffWorkerContext)this.context).getSetup(), ((TvTariffWorkerContext)this.context).getConnectionSet(), this.tvAccounting.moduleId, this.balanceEP);
            boolean bl = this.doTasks();
            return bl;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (this.productPeriodManager != null) {
                    this.productPeriodManager.recycle();
                    this.productPeriodManager = null;
                }
                if (this.productPeriodDao != null) {
                    this.productPeriodDao = null;
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            ((TvTariffWorkerContext)this.context).recycle();
            if (this.connectionSet != null) {
                this.connectionSet = null;
            }
        }
        return false;
    }

    public Object doTask(ProductPeriodRuntimeQueue.Entry task) throws BGException {
        boolean deadlockFound;
        TvAccountRuntimeRoot tvAccountRuntime;
        logger.debug("doTask");
        switch (task.key.type) {
            case 1: {
                logger.debug("Found product period start event " + task.key.productId + ":" + task.key.periodId);
                break;
            }
            case 2: {
                if (task.key.periodId == 0) {
                    logger.debug("Found product end event " + task.key.productId + ":" + task.key.periodId);
                    break;
                }
                logger.debug("Found product period end event " + task.key.productId + ":" + task.key.periodId);
                break;
            }
        }
        int contractId = task.contractId;
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.connectionSet, Integer.valueOf(contractId));
        if (task.accountId != 0) {
            tvAccountRuntime = (TvAccountRuntimeRoot)this.tvAccounting.tvAccountRuntimeMap.get(task.accountId);
            if (tvAccountRuntime == null) {
                logger.error("TvAccount not found with id=" + task.accountId);
                return null;
            }
        } else {
            tvAccountRuntime = null;
        }
        if (this.processedTasksMap.putIfAbsent((Object)new Task(contractId, task.time), (Object)Boolean.TRUE, System.currentTimeMillis() + 30000L) != null) {
            logger.debug("Already processed contract with this prolongation time");
            return null;
        }
        int count = 0;
        while ((deadlockFound = this.productsProlongate(contractId, contractRuntime, tvAccountRuntime)) && ++count < 5) {
        }
        if (deadlockFound) {
            logger.error("Continuous deadlock when trying to prolongate products for contractId: " + contractId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean productsProlongate(int contractId, ContractRuntime contractRuntime, TvAccountRuntimeRoot tvAccountRuntime) throws BGException {
        ConvergenceBalance convergenceBalance = ConvergenceBalanceManager.getInstance().getBalance(this.connectionSet, Integer.valueOf(contractRuntime.contractId), System.currentTimeMillis());
        BigDecimal balance = convergenceBalance.getBalance();
        BigDecimal limit = convergenceBalance.getLimit();
        contractRuntime.lock();
        try {
            TariffModuleTreeSet tariffTreeSet;
            Date time = new Date();
            if (tvAccountRuntime != null) {
                tariffTreeSet = tvAccountRuntime.getTariffTreeSet();
            } else {
                TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(this.connectionSet.getConnection());
                tariffTreeSet = tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractRuntime.contractId, time, "tv", this.tvAccounting.moduleId, 0, 0);
                tariffModuleTreeSetDao.freeResources();
            }
            balance = this.productPeriodManager.productsProlongate(this.tvAccounting.tvTariffContext, (TvTariffWorkerContext)this.context, this.tvTarifficationManager, contractRuntime, contractId, balance, limit, tariffTreeSet, this.tvAccounting.tvAccountRuntimeMap, time, ProlongationType.normal);
            ((TvTariffWorkerContext)this.context).commit();
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            this.connectionSet.rollback();
            logger.error(ex.getMessage(), (Throwable)ex);
            if (ex instanceof BGException && ex.getCause() instanceof SQLTransactionRollbackException) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            contractRuntime.unlock();
        }
    }

    public void shutdown() throws BGException {
        super.shutdown();
        this.balanceEP.close();
    }

    private void publish(int periodId, int type) throws SQLException {
        this.productPeriodDao.addFlag(periodId, type);
    }

    private static final class Task {
        final int contractId;
        final long time;

        public Task(int contractId, long time) {
            this.contractId = contractId;
            this.time = time;
        }

        public int hashCode() {
            return this.contractId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Task other = (Task)obj;
            return this.contractId == other.contractId && this.time == other.time;
        }
    }
}

