/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.accounting.worker;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.jmx.AnnotatedMBean;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.jmx.MBeanUtils;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThread;
import ru.bitel.common.worker.WorkerThreadFactory;

public class AccountingWorker
implements Lifecycle {
    private static final Logger logger = LogManager.getLogger();
    final String name;
    final ScheduledThreadPoolExecutor service;
    ObjectName objectName;
    private List<AccountingWorkerTask> taskList = new ArrayList<AccountingWorkerTask>();

    public AccountingWorker(String name, ParameterMap workerParams, ThreadContextFactory<ServerContext> threadContextFactory) {
        this.name = name;
        int threadCount = workerParams.getInt("thread.count", 1);
        final int threadPriority = Math.max(1, Math.min(10, workerParams.getInt("thread.priority", 5)));
        WorkerThreadFactory<ServerContext> threadFactory = new WorkerThreadFactory<ServerContext>("accwrkr-" + name, null, threadContextFactory){

            protected WorkerThread<ServerContext> init(WorkerThread<ServerContext> t) {
                WorkerThread result = super.init(t);
                result.setPriority(threadPriority);
                return result;
            }
        };
        this.service = new ScheduledThreadPoolExecutor(threadCount, (ThreadFactory)threadFactory);
    }

    @MBeanAttribute
    public int getCorePoolSize() {
        return this.service.getCorePoolSize();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.service.setCorePoolSize(corePoolSize);
    }

    @MBeanAttribute
    public int getPoolSize() {
        return this.service.getPoolSize();
    }

    @MBeanAttribute
    public int getActiveCount() {
        return this.service.getActiveCount();
    }

    @MBeanAttribute
    public long getTaskCount() {
        return this.service.getTaskCount();
    }

    public void shutdown() {
        this.service.shutdown();
    }

    public void addTask(String name, AccountingWorkerTask accountingWorkerTask) {
        this.taskList.add(accountingWorkerTask);
        String taskName = accountingWorkerTask.name;
        accountingWorkerTask.name = "worker=" + this.name + ",workerTask=" + name + ",name=" + accountingWorkerTask.name;
        accountingWorkerTask.init();
        accountingWorkerTask.name = taskName;
        accountingWorkerTask.start();
    }

    public void init() {
        this.objectName = AnnotatedMBean.register((Object)this, (String)this.name);
    }

    public void start() {
    }

    public void stop() {
        this.service.shutdown();
    }

    public void destroy() throws InterruptedException {
        this.service.shutdown();
        this.service.awaitTermination(20L, TimeUnit.SECONDS);
        for (AccountingWorkerTask task : this.taskList) {
            task.stop();
            task.destroy();
        }
        MBeanUtils.unregisterMBean((ObjectName)this.objectName, (Logger)logger);
    }
}

