/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server;

import bitel.billing.server.ApplicationModule;
import bitel.billing.server.ModuleBase;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.util.Config;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.tv.common.bean.ProlongationType;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvAccountStateModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvProductsModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.bgbilling.modules.tv.server.ProductManager;
import ru.bitel.bgbilling.modules.tv.server.ProductOfferingListEventHandler;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDao;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntimeMap;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.XMLDatabaseSerializer;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.bootstrap.Shutdown;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductPeriod;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.event.ProductEntry;
import ru.bitel.oss.systems.inventory.product.common.event.ProductModifyEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifyEvent;
import ru.bitel.oss.systems.inventory.product.server.ProductSpecMap;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductDao;
import ru.bitel.oss.systems.order.product.common.event.ProductOfferingListEvent;
import ru.bitel.oss.systems.order.product.common.event.ProductOrderEvent;

public class Module
extends ModuleBase
implements ApplicationModule,
EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private static final String[] PACKAGES = new String[]{Module.class.getPackage().getName()};
    private final Set<Integer> moduleIds = new HashSet<Integer>(8);

    public String[] getServerPackages() {
        return PACKAGES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Connection con, final BGModule module) throws BGException {
        boolean firstCall;
        boolean bl = firstCall = this.moduleIds.size() == 0;
        if (!this.moduleIds.add(module.getId())) {
            return;
        }
        super.start(con, module);
        try {
            final Setup setup = Setup.getSetup();
            ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(module.getId()));
            String moduleLifecycle = moduleSetup.get("tv.lifecycle.class", null);
            if (Utils.notBlankString((String)moduleLifecycle)) {
                DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
                final Lifecycle lifecycle = (Lifecycle)dynamicClassManager.newInstance(Lifecycle.class, moduleLifecycle);
                lifecycle.start();
                Shutdown.addShutdownHook((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            lifecycle.stop();
                        }
                        catch (Exception ex) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                });
            }
            for (Map.Entry entry : moduleSetup.subKeyed("tv.lifecycle.handler.").entrySet()) {
                String clazz = ((ParameterMap)entry.getValue()).get("class", null);
                if (!Utils.notBlankString((String)clazz)) continue;
                try {
                    Lifecycle lifecycle;
                    DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
                    ServerContext context = new ServerContext(setup, module.getId(), 0);
                    ThreadContext parentContext = ServerContext.push((ThreadContext)context);
                    try {
                        lifecycle = (Lifecycle)dynamicClassManager.newInstance(Lifecycle.class, clazz);
                        lifecycle.start();
                    }
                    finally {
                        ServerContext.pop((ThreadContext)context, (ThreadContext)parentContext);
                    }
                    Shutdown.addShutdownHook((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ServerContext context = new ServerContext(setup, module.getId(), 0);
                            ThreadContext parentContext = ServerContext.push((ThreadContext)context);
                            try {
                                lifecycle.stop();
                            }
                            catch (Exception ex) {
                                logger.error(ex.getMessage(), (Throwable)ex);
                            }
                            finally {
                                ServerContext.pop((ThreadContext)context, (ThreadContext)parentContext);
                            }
                        }
                    });
                }
                catch (Throwable ex) {
                    logger.error(ex.getMessage(), ex);
                }
            }
            try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)setup, (Connection)con, (boolean)true);){
                ProductSpecRuntimeMap.getInstance(connectionSet);
                ProductSpecMap.getInstance();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (firstCall) {
            EventProcessor ep = EventProcessor.getInstance();
            ep.addListener((EventListener)this, ProductOrderEvent.class);
            ep.addListener((EventListener)this, ProductModifyEvent.class);
            ep.addListener((EventListener)this, ProductPeriodModifyEvent.class);
            ep.addListener((EventListener)new ProductOfferingListEventHandler(this.moduleIds), ProductOfferingListEvent.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notify(Event _e, EventListenerContext ctx) throws BGException {
        if (_e instanceof ProductOrderEvent) {
            BGNestedContext.push((String)"tv");
            try {
                ProductOrderEvent productOrderEvent = (ProductOrderEvent)_e;
                int moduleId = productOrderEvent.getProductSpec().getModuleId();
                if (productOrderEvent.getMode() != 1 || !this.moduleIds.contains(moduleId)) return;
                ProductManager productManager = new ProductManager((ServerContext)ctx, moduleId);
                ArrayList<ProductEntry> productEntryList = new ArrayList<ProductEntry>();
                productManager.productActivate(productOrderEvent.getProductSpec(), productOrderEvent.getActivationMode(), productOrderEvent.getNewProduct(), productOrderEvent.isSync(), productEntryList, productOrderEvent.isCustomer());
                productOrderEvent.setProductEntryList(productEntryList);
                productManager.recycle();
                return;
            }
            finally {
                BGNestedContext.pop();
            }
        } else if (_e instanceof ProductModifyEvent) {
            ProductModifyEvent e = (ProductModifyEvent)_e;
            int moduleId = e.getProductSpec().getModuleId();
            if (!this.moduleIds.contains(moduleId) || e.getNewProduct() != null) return;
            ProductManager productManager = new ProductManager((ServerContext)ctx, moduleId);
            ArrayList<ProductEntry> productEntryList = new ArrayList<ProductEntry>();
            productManager.productDelete(e.getOldProduct(), e.isSync(), productEntryList);
            productManager.recycle();
            return;
        } else if (_e instanceof ProductPeriodModifyEvent) {
            this.processProductPeriodModify(ctx, (ProductPeriodModifyEvent)_e);
            return;
        } else {
            ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(ctx.getConnectionSet(), Integer.valueOf(_e.getContractId()));
            ContractManager contractManager = new ContractManager(ctx.getConnection());
            Contract contract = contractManager.getContractById(contractRuntime.contractId);
            contractManager.recycle();
            GregorianCalendar calendar = new GregorianCalendar();
            BalanceDao balanceDao = new BalanceDao(ctx.getConnection());
            ContractBalance balance = contract.isDependSub() ? balanceDao.getContractBalance(contract.getSuperId(), calendar.get(1), calendar.get(2) + 1) : balanceDao.getContractBalance(contractRuntime.contractId, calendar.get(1), calendar.get(2) + 1);
            for (Integer moduleId : this.moduleIds) {
                this.tryProlongate((ServerContext)ctx, moduleId, contractRuntime, balance.toBalance(), contract.getBalanceLimit());
            }
        }
    }

    private void processProductPeriodModify(EventListenerContext ctx, ProductPeriodModifyEvent e) throws BGException {
        int moduleId = e.getProductSpec().getModuleId();
        if (!this.moduleIds.contains(moduleId)) {
            return;
        }
        Product product = e.getProduct();
        ProductPeriod period = e.getNewPeriod();
        if (period == null || product.getDeviceState() == 1 || !TimeUtils.timeInRange((Date)new Date(), (Date)period.getTimeFrom(), (Date)period.getTimeTo())) {
            return;
        }
        if (product.getAccountId() <= 0) {
            return;
        }
        try (TvAccountDao tvAccountDao = new TvAccountDao(ctx.getConnection(), moduleId);){
            TvAccount tvAccount = (TvAccount)tvAccountDao.get(product.getAccountId());
            ArrayList<ProductEntry> productEntryList = new ArrayList<ProductEntry>();
            productEntryList.add(new ProductEntry(product, product, product.getDeviceState(), 1));
            logger.info("Sending event to enable product");
            OmTvProductsModifyEvent omTvProductsModifyEvent = new OmTvProductsModifyEvent(moduleId, period.getContractId(), 0, tvAccount.getDeviceId(), tvAccount.getId(), productEntryList, null);
            omTvProductsModifyEvent.setSource(Module.class.getSimpleName() + ".processProductPeriodModify");
            ctx.publishAfterCommit((Event)omTvProductsModifyEvent);
        }
    }

    public String getStatus(Connection con, int moduleId, int contractId) throws BGException {
        try {
            ServerContext context = (ServerContext)ServerContext.get();
            return ((TvAccountService)context.getService(TvAccountService.class, moduleId)).tvProductStatus(contractId, 0);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return "";
        }
    }

    public void lockServiceNow(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        ServerContext context = (ServerContext)ServerContext.get();
        Conf conf = (Conf)context.getSetup().getConfig(moduleId, Conf.class);
        if (conf.lockByBalance) {
            this.lockService(con, moduleId, contractRuntime, balance, limit, lightweight, true, null);
        } else if (conf.lockByBalanceTvAccountSpecIds != null) {
            this.lockService(con, moduleId, contractRuntime, balance, limit, lightweight, true, conf.lockByBalanceTvAccountSpecIds);
        }
        this.tvProductWithNpay(con, moduleId, contractRuntime, (short)0);
    }

    public void lockService(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.lockService(con, moduleId, contractRuntime, balance, limit, lightweight, false, null);
    }

    private void lockService(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight, boolean balanceInsufficient, Set<Integer> lockByBalanceTvAccountSpecIds) throws BGException {
        try (TvAccountDao tvAccountDao = new TvAccountDao(con, moduleId);){
            EventProcessor eventProcessor = EventProcessor.getInstance();
            List<TvAccount> tvAccountList = tvAccountDao.list(contractRuntime.contractId);
            for (TvAccount tvAccount : tvAccountList) {
                if (tvAccount.getDeviceState() != 1 || tvAccount.getParentId() > 0 || lockByBalanceTvAccountSpecIds != null && !lockByBalanceTvAccountSpecIds.contains(tvAccount.getSpecId())) continue;
                logger.info("Sending state disable to tvAccount[id: " + tvAccount.getId() + "]");
                eventProcessor.publish((Event)new OmTvAccountStateModifyEvent(moduleId, 0, tvAccount, 0, balanceInsufficient ? 12 : 11, balanceInsufficient));
            }
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void unlockServiceNow(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        ServerContext context = (ServerContext)ServerContext.get();
        boolean needProlongate = this.unlockService(context, con, moduleId, contractRuntime, balance, limit, lightweight, null);
        if (needProlongate && !lightweight) {
            this.tryProlongate(context, moduleId, contractRuntime, balance, limit);
        }
        this.tvProductWithNpay(con, moduleId, contractRuntime, (short)1);
    }

    public void unlockService(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        ServerContext context = (ServerContext)ServerContext.get();
        this.unlockService(context, con, moduleId, contractRuntime, balance, limit, lightweight, null);
    }

    private boolean unlockService(ServerContext context, Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight, Set<Integer> lockByBalanceTvAccountSpecIds) throws BGException {
        boolean bl;
        TvAccountDao tvAccountDao = new TvAccountDao(con, moduleId);
        try {
            Date time = new Date();
            EventProcessor eventProcessor = EventProcessor.getInstance();
            ProductManager productManager = new ProductManager(context, moduleId);
            List<TvAccount> tvAccountList = tvAccountDao.list(contractRuntime.contractId);
            boolean needProlongate = false;
            for (TvAccount tvAccount : tvAccountList) {
                if (tvAccount.getDeviceState() == 0) {
                    if (tvAccount.getParentId() > 0 || lockByBalanceTvAccountSpecIds != null && !lockByBalanceTvAccountSpecIds.contains(tvAccount.getSpecId())) continue;
                    logger.info("Sending state enable to tvAccount[id: " + tvAccount.getId() + "]");
                    eventProcessor.publish((Event)new OmTvAccountStateModifyEvent(moduleId, 0, tvAccount, 1, 0, true));
                    continue;
                }
                if (tvAccount.getParentId() > 0 || tvAccount.getDeviceState() != 1) continue;
                needProlongate = !lightweight;
            }
            if (needProlongate) {
                balance = productManager.productsProlongate(context.getConnectionSet(), contractRuntime, contractRuntime.contractId, balance, limit, time, ProlongationType.payment);
                context.commit();
            }
            productManager.recycle();
            bl = !needProlongate;
        }
        catch (Throwable throwable) {
            try {
                try {
                    tvAccountDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return true;
            }
        }
        tvAccountDao.close();
        return bl;
    }

    private void tryProlongate(ServerContext context, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit) throws BGException {
        ProductManager productPeriodManager = new ProductManager(context, moduleId);
        Date time = new Date();
        balance = productPeriodManager.productsProlongate(context.getConnectionSet(), contractRuntime, contractRuntime.contractId, balance, limit, time, ProlongationType.payment);
        context.commit();
        productPeriodManager.recycle();
    }

    public void moduleAction(ServerContext ctx, int moduleId, Event e) throws Exception {
        if (e instanceof ContractCreateEvent) {
            this.contractCreate(ctx, moduleId, (ContractCreateEvent)e);
        } else if (e instanceof ContractDeleteEvent) {
            this.contractDelete(ctx, moduleId, (ContractDeleteEvent)e);
        } else if (e instanceof ContractCloseEvent) {
            this.contractClose(ctx, moduleId, (ContractCloseEvent)e);
        } else if (e instanceof ContractWrapEvent) {
            // empty if block
        }
    }

    private void contractCreate(ServerContext ctx, int moduleId, ContractCreateEvent e) throws BGException {
        Integer activateModuleId;
        Document dataDoc = e.getPattern().getData();
        Element addInetServEl = XMLUtils.selectElement((Node)dataDoc, (String)("data/modules/tv[@mid=" + moduleId + "]/addTvAccount[@enable=1]"));
        Map params = e.getParams();
        if (params != null && (activateModuleId = (Integer)params.get("moduleId")) != null && activateModuleId == moduleId && addInetServEl == null) {
            e.setError("\u0412 \u0448\u0430\u0431\u043b\u043e\u043d\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u043c\u043e\u0434\u0443\u043b\u044f TV!");
            return;
        }
        if (addInetServEl != null) {
            Integer deviceIdInteger;
            int inetServTypeId = Utils.parseInt((String)addInetServEl.getAttribute("tvAccountSpecId"), (int)0);
            TvAccountSpec servType = (TvAccountSpec)ctx.getDirectory(TvAccountSpec.class, moduleId).get(inetServTypeId);
            Preferences servTypeConfig = new Preferences(servType.getConfig(), "\n\r");
            int deviceId = servTypeConfig.getInt("const.device.id", -1);
            Card card = null;
            if (params != null && (card = (Card)params.get(Card.class.getName())) != null && deviceId <= 0 && (deviceIdInteger = (Integer)params.get("deviceId")) != null) {
                deviceId = deviceIdInteger;
            }
            TvAccountService servService = (TvAccountService)ctx.getService(TvAccountService.class, moduleId);
            TvAccount serv = new TvAccount();
            serv.setSpecId(inetServTypeId);
            serv.setContractId(e.getContractId());
            serv.setDateFrom(e.getDateFrom());
            serv.setDateTo(e.getDateTo());
            serv.setStatus(Utils.parseInt((String)addInetServEl.getAttribute("status"), (int)0));
            if (deviceId <= 0) {
                e.setError("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d const.device.id \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0442\u0438\u043f\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430.");
                return;
            }
            serv.setDeviceId(deviceId);
            if (!e.isCheck()) {
                long saWaitTimout = 0L;
                if (card != null) {
                    serv.setLogin(String.valueOf(card.getCardCode()));
                    serv.setPassword(card.getCardPinCode());
                    saWaitTimout = 10000L;
                }
                servService.tvAccountUpdate(serv.getContractId(), serv, card == null, card == null, saWaitTimout);
            }
        }
    }

    private void contractDelete(ServerContext ctx, int moduleId, ContractDeleteEvent e) throws BGException {
        TvAccountService tvAccountService = (TvAccountService)ctx.getService(TvAccountService.class, moduleId);
        TvAccount root = tvAccountService.tvAccountTree(e.getContractId());
        if (root.getChildren() == null || root.getChildren().size() == 0) {
            return;
        }
        if (e.isCheck()) {
            try {
                for (TvAccount tvAccount : root.getChildren()) {
                    tvAccountService.tvAccountIsActive(tvAccount);
                }
            }
            catch (BGException ex) {
                e.setError(ModuleCache.getInstance().getModule(moduleId).getTitle() + ": " + ex.getMessage());
            }
        } else {
            for (TvAccount tvAccount : root.getChildren()) {
                tvAccountService.tvAccountDelete(tvAccount.getContractId(), tvAccount.getId(), false);
            }
        }
    }

    private void contractClose(ServerContext ctx, int moduleId, ContractCloseEvent e) throws BGException {
        logger.info("contractClose mid:" + moduleId + ", cid:" + e.getContractId() + ", check:" + e.isCheck());
        TvAccountService tvAccountService = (TvAccountService)ctx.getService(TvAccountService.class, moduleId);
        TvAccount root = tvAccountService.tvAccountTree(e.getContractId());
        if (root.getChildren() == null || root.getChildren().size() == 0) {
            return;
        }
        if (e.isCheck()) {
            for (TvAccount tvAccount : root.getChildren()) {
                if (tvAccount.getDateTo() == null || TimeUtils.dateBeforeOrEq((Date)tvAccount.getDateTo(), (Date)e.getDate())) continue;
                e.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0430\u043a\u043a\u0430\u0443\u043d\u0442 TV \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u0443 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.");
            }
        } else {
            for (TvAccount tvAccount : root.getChildren()) {
                if (tvAccount.getDateTo() != null) continue;
                logger.info("closing tvAccount:" + tvAccount.getId());
                tvAccount.setDateTo(e.getDate());
                tvAccountService.tvAccountUpdate(tvAccount.getContractId(), tvAccount, false, false, 0L);
            }
        }
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String cidStr = String.valueOf(cid);
        String tableName = "tv_account_" + mid;
        String typesTableName = "tv_account_spec_" + mid;
        String devicesTableName = "tv_device_" + mid;
        String query = "SELECT tv_account.*, account_spec.title as _specTitle, device.title as _deviceTitle, device.comment as _deviceComment  FROM " + tableName + " as tv_account LEFT JOIN " + typesTableName + " as account_spec ON account_spec.id=tv_account.specId  LEFT JOIN " + devicesTableName + " as device ON device.id=tv_account.deviceId  WHERE contractId=" + cidStr + " ORDER BY IF(tv_account.parentId>0, tv_account.parentId, tv_account.id), tv_account.parentId";
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            new XMLDatabaseSerializer(tables).addItemsFromRS(tableName, null, null, rs);
        }
    }

    private void tvProductWithNpay(Connection con, int moduleId, ContractRuntime contractRuntime, short newState) throws BGException {
        try (ProductDao productDao = new ProductDao(con, 0);){
            ProductSpecMap productSpecMap = ProductSpecMap.getInstance();
            List<Product> products = productDao.list(moduleId, contractRuntime.contractId, 0, false, null, null, null, null, false, false).stream().filter(a -> {
                boolean result = false;
                try {
                    ProductSpec productSpec = productSpecMap.get((int)a.getProductSpecId()).productSpec;
                    String data = productSpec.getData();
                    if (Utils.notEmptyString((String)data)) {
                        result = new JSONObject(data).optInt("modeId", 0) == 1;
                    }
                }
                catch (BGException ex) {
                    logger.error((Object)ex);
                }
                return result;
            }).toList();
            if (logger.isDebugEnabled()) {
                logger.debug("NPay linked products: " + Utils.toString(products));
            }
            EventProcessor eventProcessor = EventProcessor.getInstance();
            HashMap tvAccountMap = new HashMap();
            try (TvAccountDao tvAccountDao = new TvAccountDao(con, moduleId);){
                products.forEach(p -> {
                    int tvAccountId = p.getAccountId();
                    if (tvAccountMap.containsKey(tvAccountId)) {
                        return;
                    }
                    logger.debug("Product: {}, tvAccountId: {}", p, (Object)tvAccountId);
                    try {
                        TvAccount tvAccount = tvAccountMap.getOrDefault(tvAccountId, (TvAccount)tvAccountDao.get(tvAccountId));
                        if (tvAccount.getStatus() != 0) {
                            return;
                        }
                        tvAccountMap.putIfAbsent(tvAccountId, tvAccount);
                        logger.debug("Product -> TvAccount: {}", (Object)tvAccount);
                        List<ProductEntry> productEntries = products.stream().filter(a -> a.getAccountId() == tvAccountId).map(product -> new ProductEntry(product, product, newState, newState == 1 ? (short)0 : (short)1)).toList();
                        logger.debug("TvAccount -> ProductEntry: {}" + productEntries);
                        eventProcessor.publish((Event)new OmTvProductsModifyEvent(moduleId, contractRuntime.contractId, 0, tvAccount.getDeviceId(), tvAccountId, productEntries, null));
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                });
            }
        }
    }

    public static class Conf
    extends Config {
        public final boolean lockByBalance;
        public final Set<Integer> lockByBalanceTvAccountSpecIds;

        public Conf(int moduleId, ParameterMap moduleSetup, Setup serverSetup) {
            super(moduleId, moduleSetup, serverSetup);
            this.lockByBalance = moduleSetup.getInt("account.lockByBalance", 0) > 0;
            Set lockByBalanceTvAccountSpecIds = Utils.toIntegerSet((String)moduleSetup.get("account.lockByBalance.specIds", null));
            this.lockByBalanceTvAccountSpecIds = lockByBalanceTvAccountSpecIds.size() > 0 ? lockByBalanceTvAccountSpecIds : null;
        }
    }
}

