/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class StatusAcceptTariffTreeNode
extends DefaultTariffTreeNode<TvTariffRequest, TariffContext> {
    private final int status;
    private final int mode;

    public StatusAcceptTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.status = parameterMap.getInt("status", -1);
        this.mode = parameterMap.getInt("mode", -1);
    }

    public int executeImpl(Long treeNodeId, TvTariffRequest req, TariffContext ctx) {
        int result;
        this.logger.info("StatusAcceptTariffTreeNode:mode=>" + this.mode + ";status=>" + this.status);
        if (this.status < 0 || this.mode < 0) {
            this.logger.error("StatusAcceptTariffTreeNode invalidate data:mode=>" + this.mode + ";status=>" + this.status);
        }
        if (req.serviceCost != null) {
            this.setStatus((TvServiceCost)req.serviceCost);
            this.log((TvServiceCost)req.serviceCost);
            result = 1;
        } else {
            result = 0;
            for (Map.Entry e : req.getServiceCost().entrySet()) {
                List serviceCostList = (List)e.getValue();
                if (serviceCostList == null) continue;
                int jsize = serviceCostList.size();
                for (int j = 0; j < jsize; ++j) {
                    result = 1;
                    this.setStatus((TvServiceCost)req.serviceCost);
                }
            }
        }
        return result;
    }

    private void setStatus(TvServiceCost serviceCost) {
        switch (this.mode) {
            case 0: {
                this.logger.info("StatusAcceptTariffTreeNode:set status!!mode=>" + this.mode + ";status=>" + this.status);
                serviceCost.contractStatusSet.add(this.status);
                break;
            }
            case 1: {
                this.logger.info("StatusAcceptTariffTreeNode:set status!!mode=>" + this.mode + ";status=>" + this.status);
                serviceCost.deviceStateSet.add(this.status);
            }
        }
    }

    private void log(TvServiceCost serviceCost) {
        this.logger.info("StatusAcceptTariffTreeNode:productId=>" + serviceCost.getProductId() + "; contractStatusSet[" + serviceCost.contractStatusSet + "]=>" + Utils.toString(serviceCost.contractStatusSet) + "; deviceStateSet[" + serviceCost.deviceStateSet + "]=>" + Utils.toString(serviceCost.deviceStateSet));
    }
}

