package ru.bitel.bgbilling.modules.tv.dyn.tv24h;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;

import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.common.SerialUtils;

@EventType(autoAcknowledge = false)
@XmlRootElement
@XmlSeeAlso(value = { PaymentEvent.class, ContractModifiedEvent.class })
public class Tv24hQueueEvent
	extends QueueEvent
{
	private static final long serialVersionUID = SerialUtils.generateSerialVersionUID( Tv24hQueueEvent.class );

	protected final Event event;

	protected Tv24hQueueEvent()
	{
		super();

		this.event = null;
	}

	public Tv24hQueueEvent( final int moduleId, final Event event )
	{
		super( moduleId, event.getContractId(), 0 );

		this.event = event;
	}

	public Event getEvent()
	{
		return event;
	}
}
