<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<fmt:setLocale value="RU"/>

<div id="tvResult"></div>

<div class="tile tileTabs">
<c:forEach var="tvAccountItem" varStatus="tvAccountStatus" items="${tvAccountList}">
	<div class="titleBottomLine mTop10"><span class="titleFont2">${tvAccountItem.title}</span></div>
	<c:forEach var="tvProduct" varStatus="tvProductStatus" items="${tvAccountProducts[tvAccountItem.id]}">
		<div class="flexRow" style="font-size: 0.8rem; margin-left: 1rem;">
			<div style="margin-top: 10px; margin-left: 0px;">
				<div class="titleFont3" style="margin: 0px 0px 10px 0px;">${tvProduct.productSpecTitle}</div>
				<div style="margin-left: 10px; line-height: 1.3rem;">
					<div class="paramColor">Период продукта: <span><fmt:formatDate type="BOTH" dateStyle="SHORT" timeStyle="MEDIUM" value="${tvProduct.timeFrom}"/> - <fmt:formatDate type="BOTH" dateStyle="SHORT" timeStyle="MEDIUM" value="${tvProduct.timeTo}"/></span></div>
					<c:if test="${not empty tvProduct.subscriptionTimeTo}">
					<div class="paramColor">Оплачено до: <span><fmt:formatDate type="BOTH" dateStyle="SHORT" timeStyle="MEDIUM" value="${tvProduct.subscriptionTimeTo}"/></span></div>
					</c:if>
					<div class="paramColor">Состояние: <span><c:choose><c:when test="${tvProduct.deviceState == 1}">включен</c:when><c:otherwise>отключен</c:otherwise></c:choose></span></div>
				</div>
			</div>
			<div style="margin-top: 10px; margin-top: 10px; text-align: right;">
				<c:if test="${not empty productPriceMap[tvProduct.id]}">
				<div class="paramColor" style="font-size: 0.7rem;">Стоимость за период:</div>
				<div class="titleFont3" style="margin: 5px 0px;"><fmt:formatNumber value="${productPriceMap[tvProduct.id]}" maxFractionDigits="2" minFractionDigits="2" groupingUsed="true"/><span class="CUR"></span></div>
				</c:if>
				<div style="text-align: right;">
				<c:choose>
					<c:when test="${not empty tvProduct.timeTo}">
						<c:if test="${activationByCustomerMap[tvProduct.id] and productSpecActivationModeMap[tvProduct.id].reactivationMode == 1 and productSpecActivationModeMap[tvProduct.id].periodAmount == 0}">
							<button class="btn btn-primary" onclick="if ( confirm( 'Вы уверены, что хотите реактивировать подписку?' ) ) { showBlock( 'tvResult', 'reactivate', { ...tvProductQuery, tvAccountId: ${tvAccountItem.id}, tvPproductId: ${tvProduct.id} } ); }; return false;">Реактивировать</button>
						</c:if>
					</c:when>
					<c:otherwise>
						<c:if test="${deactivationByCustomerMap[tvProduct.id] and not empty productSpecActivationModeMap[tvProduct.id]}">
							<button class="btn btn-primary" onclick="if ( confirm( 'Вы уверены, что хотите деактивировать подписку?' ) ) { showBlock( 'tvResult', 'deactivate', { ...tvProductQuery, tvAccountId: ${tvAccountItem.id}, tvPproductId: ${tvProduct.id} } ); }; return false;">Деактивировать</button>
						</c:if>
					</c:otherwise>
				</c:choose>
				</div>
			</div>
		</div>
		<c:if test="${not tvProductStatus.last}"><div class="line" style="margin-top: 5px;"></div></c:if>
	</c:forEach>
	<c:if test="${empty tvAccountProducts[tvAccountItem.id]}">
		<div style="text-align: center; font-style: italic; color: #888;">Нет данных</div>
	</c:if>
</c:forEach>
</div>
