/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.wm.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.wm.common.bean.Transaction;
import ru.bitel.bgbilling.modules.wm.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.wm.server.bean.WMRequest;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public static final int ERR_WRONG_REQUEST = 1;
    public static final int ERR_WRONG_REMOTE_HOST = 2;
    public static final int ERR_WRONG_HASH = 4;
    public static final int ERR_WRONG_RECIEVER_PURSE = 8;
    public static final int ERR_TEST_MODE = 16;
    public static final int ERR_WRONG_PAYMENT_ID = 32;
    public static final int ERR_WRONG_CONTRACT_ID = 64;
    public static final int ERR_WRONG_SUMM = 128;
    public static final int ERR_ALREADY_PAYED = 256;
    public static final int ERR_UNIQUE_INVS = 512;
    public static final int ERR_UNIQUE_TRANS = 1024;
    public static final int ERR_OFF = 2048;
    public static final int ERR_WRONG_PAYMENT_TYPE = 4096;
    private static final int WMOK = 1;
    private static final int WMFAIL = 2;
    private static Pattern psum = Pattern.compile("\\$\\{summ\\}");
    private static Pattern ppayerPurse = Pattern.compile("\\$\\{payer_purse\\}");
    private static Pattern ppayerWM = Pattern.compile("\\$\\{payer_wm\\}");
    private static Pattern ptransTime = Pattern.compile("\\$\\{trans_time\\}");
    private static Pattern precieverPurse = Pattern.compile("\\$\\{reciever_purse\\}");
    private static Pattern psysInvsNo = Pattern.compile("\\$\\{sys_invs_no\\}");
    private static Pattern psysTransNo = Pattern.compile("\\$\\{sys_trans_no\\}");

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "wm_payment");
        this.fields = new HashMap();
        this.fields.put("id", "id");
    }

    public List<Transaction> getWMPaymentList(Calendar from, Calendar until, int status, String contractTitle, String wmId, String wmPayId) throws BGException {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        StringBuffer query = new StringBuffer("SELECT wm.*, contract.title AS contractTitle FROM " + this.tableName + " as wm LEFT JOIN contract ON contract.id=wm.cid WHERE ");
        if (status == 1) {
            query.append("wm.status=1");
        } else if (status == 2) {
            query.append("wm.status=-1");
        } else {
            query.append("wm.status=1 AND wm.status=-1");
        }
        if (from != null) {
            query.append(" AND trans_time>=?");
        }
        if (until != null) {
            query.append(" AND trans_time<=?");
        }
        if (!Utils.isEmptyString((String)contractTitle)) {
            query.append(" AND contract.title LIKE ?");
        }
        if (!Utils.isEmptyString((String)wmId)) {
            query.append(" AND payer_wm LIKE ?");
        }
        if (!Utils.isEmptyString((String)wmPayId)) {
            query.append(" AND wm.id LIKE ?");
        }
        query.append(")");
        try {
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int i = 1;
            if (from != null) {
                ps.setDate(i++, TimeUtils.convertCalendarToSqlDate((Calendar)from));
            }
            if (until != null) {
                ps.setDate(i++, TimeUtils.convertCalendarToSqlDate((Calendar)until));
            }
            if (!Utils.isEmptyString((String)contractTitle)) {
                ps.setString(i++, "%" + contractTitle + "%");
            }
            if (!Utils.isEmptyString((String)wmId)) {
                ps.setString(i++, "%" + wmId + "%");
            }
            if (!Utils.isEmptyString((String)wmPayId)) {
                ps.setString(i++, "%" + wmPayId + "%");
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return;
        }
        if (searchResult != null) {
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuffer queryWhere = new StringBuffer(" WHERE true");
            if (contractId > 0) {
                queryWhere.append(" AND cid=").append(contractId);
            }
            if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                queryWhere.append(" AND wm.status=?");
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    queryWhere.append(" AND trans_time>=?");
                }
                if (period.getDateTo() != null) {
                    queryWhere.append(" AND trans_time<=?");
                }
            }
            StringBuffer query = new StringBuffer("SELECT wm.*, contract.title AS contractTitle FROM ").append(this.tableName).append(" AS wm LEFT JOIN contract ON contract.id=wm.cid");
            query.append(queryWhere).append(this.getSQLOrder(sort, this.fields)).append(page != null ? page.sqlLimit() : "");
            try {
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                    ps.setString(index++, status);
                }
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                    }
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                rs.close();
                ps.close();
                index = 1;
                query.setLength(0);
                query.append("SELECT SUM(sum), COUNT(*) FROM ").append(this.tableName).append(" AS wm").append(queryWhere);
                ps = this.con.prepareStatement(query.toString());
                if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                    ps.setString(index++, status);
                }
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                    }
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    BigDecimal sum;
                    if (page != null) {
                        page.setRecordCount(rs.getInt(2));
                    }
                    if ((sum = rs.getBigDecimal(1)) == null) continue;
                    searchResult.setSum(sum);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw new BGException((Throwable)ex);
            }
        }
    }

    public Transaction getWMPayment(int cid, int id) {
        Transaction result = null;
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE id=" + id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getFromRS(rs, false);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int checkAndUpdateWMPayment(int contractId, WMRequest request, int sysMode) throws BGException {
        int result = 0;
        if (request == null) {
            return 1;
        }
        if (request.getMode() != 0 && sysMode != 2) {
            result |= 0x10;
        }
        if (!request.checkRecieverPurse()) {
            result |= 8;
        }
        Transaction transaction = this.getWMPayment(contractId, request.getPaymentNo());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("transaction = " + transaction);
        }
        if (transaction == null) {
            result |= 0x20;
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("transaction.getSum() = " + transaction.getSum());
                this.getLogger().debug("request.getPaymentAmount() = " + request.getPaymentAmount());
            }
            if (transaction.getSum().compareTo(request.getPaymentAmount()) != 0) {
                result |= 0x80;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("transaction.getStatus() = " + transaction.getStatus());
            }
            if (transaction.getStatus().equals(TransactionStatus.OK.getCode()) || transaction.getStatus().equals(TransactionStatus.ERROR.getCode())) {
                result |= 0x100;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("transaction.getContractId() = " + transaction.getContractId());
                this.getLogger().debug("contractId from request = " + contractId);
            }
            if (transaction.getContractId() != contractId) {
                result |= 0x40;
            }
        }
        int paymentType = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).getInt("wm.payment.type.id", 0);
        if (!request.isPrerequest()) {
            if (!request.checkHash()) {
                result |= 4;
            }
            if (transaction != null) {
                if (result == 0) {
                    transaction.setPayerPurse(request.getLmi_PAYER_PURSE());
                    transaction.setPayerWM(request.getLmi_PAYER_WM());
                    transaction.setReceiverPurse(request.getLmi_PAYEE_PURSE());
                    transaction.setStatus(TransactionStatus.OK.getCode());
                    transaction.setSysInvsNumber((long)Utils.parseInt((String)request.getLmi_SYS_INVS_NO(), (int)0));
                    transaction.setSysTransNumber((long)Utils.parseInt((String)request.getLmi_SYS_TRANS_NO(), (int)0));
                    transaction.setTransactionDate(new Date());
                    this.update(transaction);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("request.getMode() = " + request.getMode());
                    }
                    if (request.getMode() == 0) {
                        this.carryOutWMPayment(transaction, paymentType);
                    } else {
                        this.testCarryOutWMPayment(transaction, paymentType);
                    }
                } else if (result == 4 && this.checkTransNo(transaction.getSysTransNumber()) == 0) {
                    transaction.setPayerPurse(request.getLmi_PAYER_PURSE());
                    transaction.setPayerWM(request.getLmi_PAYER_WM());
                    transaction.setReceiverPurse(request.getLmi_PAYEE_PURSE());
                    transaction.setStatus(TransactionStatus.ERROR.getCode());
                    transaction.setSysInvsNumber((long)Utils.parseInt((String)request.getLmi_SYS_INVS_NO(), (int)0));
                    transaction.setSysTransNumber((long)Utils.parseInt((String)request.getLmi_SYS_TRANS_NO(), (int)0));
                    transaction.setTransactionDate(new Date());
                    this.update(transaction);
                }
            }
        } else {
            if (sysMode == 0) {
                result |= 0x800;
            }
            try (PaymentTypeDao paymentTypeDa = new PaymentTypeDao(this.con);){
                if (paymentTypeDa.get(paymentType) == null) {
                    result |= 0x1000;
                }
            }
        }
        return result;
    }

    private int checkTransNo(long trans) {
        int result = 0;
        String query = "SELECT id FROM " + this.tableName + " WHERE wm_trans_id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(1, trans);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ++result;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void carryOutWMPayment(Transaction transaction, int paymentType) throws BGException {
        if (transaction != null) {
            String comment = TransactionManager.getPaymentComment(this.con, Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).get("wm.payment_comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 Webmoney-Merchant (WM# ${payer_wm}, \u043a\u043e\u0448\u0435\u043b\u0435\u043a ${payer_purse}) \u043e\u0442 ${trans_time}"), transaction);
            Payment contractPayment = new Payment();
            contractPayment.setContractId(transaction.getContractId());
            contractPayment.setComment(comment);
            contractPayment.setSum(transaction.getSum());
            contractPayment.setDate(transaction.getTransactionDate());
            contractPayment.setUserId(0);
            contractPayment.setTypeId(paymentType);
            PaymentDao paymentDao = new PaymentDao(this.con);
            paymentDao.update((Object)contractPayment);
            paymentDao.close();
            ContractDao contractDao = new ContractDao(this.con, 0);
            Contract contract = (Contract)contractDao.get(transaction.getContractId());
            contractDao.close();
            ServerUtils.commitConnection((Connection)this.con);
            BalanceUtils balanceUtils = new BalanceUtils(this.con);
            balanceUtils.updateBalance(transaction.getTransactionDate(), contract);
            balanceUtils.close();
            ServerUtils.commitConnection((Connection)this.con);
            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, contractPayment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, contractPayment.getSum()));
        }
    }

    private void testCarryOutWMPayment(Transaction transaction, int paymentType) throws BGException {
        if (transaction != null) {
            String comment = TransactionManager.getPaymentComment(this.con, "TEST (\u0441\u0443\u043c\u043c\u0430 " + transaction.getSum().toPlainString() + ",WM-Merchant, \u0434\u043e\u0433. ${contract}, WM# ${payer_wm}, \u043a\u043e\u0448. ${payer_purse}) \u043e\u0442 ${trans_time}", transaction);
            Payment contractPayment = new Payment();
            contractPayment.setContractId(transaction.getContractId());
            contractPayment.setComment(comment);
            contractPayment.setSum(BigDecimal.ZERO);
            contractPayment.setDate(transaction.getTransactionDate());
            contractPayment.setUserId(0);
            contractPayment.setTypeId(paymentType);
            PaymentDao paymentDao = new PaymentDao(this.con);
            paymentDao.update((Object)contractPayment);
            paymentDao.close();
        }
    }

    public int getFirstYear(int cid) {
        int result = 0;
        String query = "SELECT MIN(trans_time) FROM wm_payment_" + this.moduleId + " WHERE cid=" + cid;
        try {
            Calendar date;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            if (rs.next() && (date = TimeUtils.convertDateToCalendar((Date)rs.getDate(1))) != null) {
                result = date.get(1);
            }
            rs.close();
            ps.close();
            if (result == 0) {
                result = new GregorianCalendar().get(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String logResult(int result) {
        StringBuffer res = new StringBuffer();
        if ((result & 1) > 0) {
            res.append("ERR_WRONG_REQUEST");
        }
        if ((result & 2) > 0) {
            res.append("ERR_WRONG_REMOTE_HOST");
        }
        if ((result & 4) > 0) {
            res.append("ERR_WRONG_HASH");
        }
        if ((result & 8) > 0) {
            res.append("ERR_WRONG_RECIEVER_PURSE");
        }
        if ((result & 0x10) > 0) {
            res.append("\u0422\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c");
        }
        if ((result & 0x20) > 0) {
            res.append("ERR_WRONG_PAYMENT_ID");
        }
        if ((result & 0x40) > 0) {
            res.append("ERR_WRONG_CONTRACT_ID");
        }
        if ((result & 0x80) > 0) {
            res.append("ERR_WRONG_SUMM");
        }
        if ((result & 0x100) > 0) {
            res.append("ERR_ALREADY_PAYED");
        }
        return res.toString();
    }

    public static String getPaymentComment(Connection con, String pattern, Transaction transaction) {
        String desc = psum.matcher(pattern).replaceAll(Utils.formatCost((BigDecimal)transaction.getSum()));
        desc = ppayerPurse.matcher(desc).replaceAll(transaction.getPayerPurse());
        desc = ppayerWM.matcher(desc).replaceAll(transaction.getPayerWM());
        desc = ptransTime.matcher(desc).replaceAll(TimeUtils.format((Date)transaction.getTransactionDate(), (String)"dd.MM.yyyy HH:mm:ss"));
        desc = precieverPurse.matcher(desc).replaceAll(transaction.getReceiverPurse());
        desc = psysInvsNo.matcher(desc).replaceAll(String.valueOf(transaction.getSysInvsNumber()));
        desc = psysTransNo.matcher(desc).replaceAll(String.valueOf(transaction.getSysTransNumber()));
        return desc;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs, true);
    }

    protected Transaction getFromRS(ResultSet rs, boolean contractTitle) throws SQLException, BGException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(rs.getInt("cid"))).setId(rs.getInt("id"))).setPayerPurse(rs.getString("payer_purse")).setPayerWM(rs.getString("payer_wm")).setReceiverPurse(rs.getString("receiver_purse")).setStatus(rs.getString("status"))).setSum(rs.getBigDecimal("sum"))).setSysInvsNumber(rs.getLong("wm_invs_id")).setSysTransNumber(rs.getLong("wm_trans_id")).setContractTitle(contractTitle ? rs.getString("contractTitle") : null)).setTransactionDate((Date)rs.getTimestamp("trans_time"))).build();
    }

    protected void updateImpl(Transaction transaction) throws BGException, SQLException {
        int transactionId = transaction.getId();
        String querySet = " SET cid=?, trans_time=?, sum=?, wm_invs_id=?, wm_trans_id=?, payer_purse=?, payer_wm=?, receiver_purse=?, status=?";
        StringBuffer query = new StringBuffer(transactionId > 0 ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(querySet).append(transactionId > 0 ? " WHERE id=" : "").append(transactionId > 0 ? String.valueOf(transactionId) : "");
        try {
            PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
            ps.setInt(1, transaction.getContractId());
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setBigDecimal(3, transaction.getSum());
            ps.setLong(4, transaction.getSysInvsNumber());
            ps.setLong(5, transaction.getSysTransNumber());
            ps.setString(6, transaction.getPayerPurse());
            ps.setString(7, transaction.getPayerWM());
            ps.setString(8, transaction.getReceiverPurse());
            ps.setString(9, transaction.getStatus());
            ps.executeUpdate();
            if (transaction.getId() < 1) {
                transaction.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

