/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscription;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;

public class MegogoContractSubscriptionDao
extends AbstractIdDao<MegogoContractSubscription> {
    public MegogoContractSubscriptionDao(Connection con, int moduleId) {
        super(con, moduleId, "megogo_contract_subscription");
    }

    public List<MegogoContractSubscription> getContractSubscriptionList(int contractId, int serviceId, Date date) throws BGException {
        String servStr = serviceId < 1 ? null : "" + serviceId;
        return this.getContractsSubscriptionList("" + contractId, servStr, -1, date, date, -1);
    }

    public List<MegogoContractSubscription> getContractSubscriptionList(int contractId, int serviceId, int type, Period period, int exceptContractSubId) throws BGException {
        String servStr = serviceId < 1 ? null : "" + serviceId;
        return this.getContractsSubscriptionList("" + contractId, servStr, type, period == null ? null : period.getDateFrom(), period == null ? null : period.getDateTo(), exceptContractSubId);
    }

    public List<MegogoContractSubscription> getContractsSubscriptionList(String contracts, String serviceIds, int type, Date dateFrom, Date dateTo, int exceptContractSubId) throws BGException {
        List list;
        block17: {
            StringBuilder query = new StringBuilder("SELECT mcs.* FROM " + this.tableName + " AS mcs");
            if (type > 0) {
                query.append(" LEFT JOIN megogo_subscription_" + this.moduleId + " AS ms ON ms.sid=mcs.sid");
            }
            query.append(" WHERE 1=1 ");
            if (Utils.notBlankString((String)serviceIds)) {
                query.append(" AND mcs.sid IN(" + serviceIds + ")");
            }
            if (Utils.notBlankString((String)contracts)) {
                query.append(" AND mcs.contractId IN(" + contracts + ")");
            }
            if (dateTo != null) {
                query.append(" AND mcs.dateFrom<=? ");
            }
            if (dateFrom != null) {
                query.append(" AND ( mcs.dateTo IS NULL OR mcs.dateTo>=? )");
            }
            if (type > 0) {
                query.append(" AND ms.type=" + type);
            }
            if (exceptContractSubId > 0) {
                query.append(" AND mcs.id!=" + exceptContractSubId);
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            try {
                int index = 1;
                if (dateTo != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateTo));
                }
                if (dateFrom != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
                }
                ResultSet rs = ps.executeQuery();
                list = this.getListFromRS(rs);
                if (ps == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BGException(e.getMessage(), (Throwable)e);
                }
            }
            ps.close();
        }
        return list;
    }

    protected MegogoContractSubscription getFromRS(ResultSet rs) throws SQLException, BGException {
        MegogoContractSubscription service = new MegogoContractSubscription();
        service.setId(rs.getInt("id"));
        service.setContractId(rs.getInt("contractId"));
        service.setServiceId(rs.getInt("sid"));
        service.setStatus(rs.getInt("status"));
        service.setSubscriptionFrom(rs.getInt("subscriptionIdFrom"));
        service.setCount(rs.getInt("count"));
        service.setComment(rs.getString("comment"));
        service.setPeriod(new Period((Date)rs.getDate("dateFrom"), (Date)rs.getDate("dateTo")));
        service.setDateActivated(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("activated_time")));
        service.setDateDeactivated(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("deactivated_time")));
        service.setLm((Date)rs.getTimestamp("lm"));
        service.setUserId(rs.getInt("userId"));
        return service;
    }

    protected void updateImpl(MegogoContractSubscription contractSubscription) throws BGException, SQLException {
        if (contractSubscription != null) {
            String query = null;
            PreparedStatement ps = null;
            if (contractSubscription.getId() < 1) {
                query = "INSERT INTO " + this.tableName + " SET contractId=?, sid=?, subscriptionIdFrom=?, status=?, count=?, dateFrom=?, dateTo=?, comment=?, userId=?";
                if (contractSubscription.getDateActivated() != null) {
                    query = query + ", activated_time=?";
                }
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET contractId=?, sid=?, subscriptionIdFrom=?, status=?, count=?, dateFrom=?, dateTo=?, comment=?, userId=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(10, contractSubscription.getId());
            }
            ps.setInt(1, contractSubscription.getContractId());
            ps.setInt(2, contractSubscription.getServiceId());
            ps.setInt(3, contractSubscription.getSubscriptionFrom());
            ps.setInt(4, contractSubscription.getStatus());
            ps.setInt(5, contractSubscription.getCount());
            ps.setDate(6, TimeUtils.convertDateToSqlDate((Date)contractSubscription.getPeriod().getDateFrom()));
            ps.setDate(7, TimeUtils.convertDateToSqlDate((Date)contractSubscription.getPeriod().getDateTo()));
            ps.setString(8, contractSubscription.getComment());
            ps.setInt(9, contractSubscription.getUserId());
            if (contractSubscription.getId() < 1 && contractSubscription.getDateActivated() != null && contractSubscription.getStatus() == 0) {
                ps.setTimestamp(10, TimeUtils.convertDateToTimestamp((Date)contractSubscription.getDateActivated()));
            }
            ps.executeUpdate();
            if (contractSubscription.getId() < 1) {
                contractSubscription.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
    }

    public MegogoContractSubscription getByFromId(int idFrom) throws BGException {
        MegogoContractSubscription megogoContractSubscription;
        block8: {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE subscriptionIdFrom=" + idFrom);
            try {
                ResultSet rs = ps.executeQuery();
                MegogoContractSubscription megogoContractSubscription2 = megogoContractSubscription = rs.next() ? this.getFromRS(rs) : null;
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BGException(e.getMessage(), (Throwable)e);
                }
            }
            ps.close();
        }
        return megogoContractSubscription;
    }

    public int updateDateActivated(int id, Date date) throws BGException {
        return this.updateDate(id, date, "activated_time");
    }

    public int updateDateDeactivated(int id, Date date) throws BGException {
        return this.updateDate(id, date, "deactivated_time");
    }

    private int updateDate(int id, Date date, String field) throws BGException {
        int n;
        block8: {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET " + field + "=? WHERE id=" + id);
            try {
                ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)date));
                n = ps.executeUpdate();
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BGException(e.getMessage(), (Throwable)e);
                }
            }
            ps.close();
        }
        return n;
    }

    public List<MegogoContractSubscription> getSubscriptionsForClose(Date date, boolean inclusive) throws BGException {
        List list;
        block9: {
            if (date == null) {
                return null;
            }
            String query = "SELECT * FROM " + this.tableName + " WHERE status!= 2 AND dateTo IS NOT NULL AND dateTo" + (inclusive ? "<=" : "<") + "?";
            PreparedStatement ps = this.con.prepareStatement(query);
            try {
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
                list = this.getListFromRS(ps.executeQuery());
                if (ps == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BGException(e.getMessage(), (Throwable)e);
                }
            }
            ps.close();
        }
        return list;
    }

    public List<MegogoContractSubscription> getSubscriptionsForOpen(Date date, boolean inclusive) throws BGException {
        List list;
        block9: {
            if (date == null) {
                return null;
            }
            String query = "SELECT * FROM " + this.tableName + " WHERE status= 3 AND ( dateTo IS NULL OR dateTo>? ) AND dateFrom" + (inclusive ? "<=" : "<") + "?";
            PreparedStatement ps = this.con.prepareStatement(query);
            try {
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
                list = this.getListFromRS(ps.executeQuery());
                if (ps == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BGException(e.getMessage(), (Throwable)e);
                }
            }
            ps.close();
        }
        return list;
    }
}

