/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.twpg.server.servlet;

import bitel.billing.server.contract.bean.PaymentManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.twpg.common.bean.Transaction;
import ru.bitel.bgbilling.modules.twpg.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebServlet(name="TWPGExecuter", urlPatterns={"/twpg/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final Logger logger = LogManager.getLogger();
    private static final String[] SET_1 = new String[]{"AMOUNT", "CURRENCY", "ORDER", "MERCH_NAME", "MERCHANT", "TERMINAL", "EMAIL", "TRTYPE", "TIMESTAMP", "NONCE", "BACKREF", "RESULT", "RC", "RCTEXT", "AUTHCODE", "RRN", "INT_REF"};
    private static final String[] SET_22 = new String[]{"ORDER", "AMOUNT", "CURRENCY", "ORG_AMOUNT", "RRN", "INT_REF", "TRTYPE", "TERMINAL", "BACKREF", "EMAIL", "TIMESTAMP", "NONCE", "RESULT", "RC", "RCTEXT"};
    private static final String[] SET_0 = new String[]{"AMOUNT", "CURRENCY", "ORDER", "MERCH_NAME", "MERCHANT", "TERMINAL", "EMAIL", "TRTYPE", "TIMESTAMP", "NONCE", "BACKREF", "RESULT", "RC", "RCTEXT", "AUTHCODE", "RRN", "INT_REF"};
    private static final String[] SET_21 = new String[]{"ORDER", "AMOUNT", "CURRENCY", "ORG_AMOUNT", "RRN", "INT_REF", "TRTYPE", "TERMINAL", "BACKREF", "EMAIL", "TIMESTAMP", "NONCE", "RESULT", "RC", "RCTEXT"};

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection con = null;
        int moduleId = 0;
        try {
            moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            response.setStatus(500);
            return;
        }
        try {
            try (TransactionManager transactionManager = new TransactionManager(con, moduleId);){
                String CARD;
                String CHANNEL;
                String AUTHCODE;
                String RCTEXT;
                Date TIMESTAMP;
                Transaction transaction;
                StringBuilder buf;
                block51: {
                    int TRTYPE;
                    block52: {
                        int RESULT;
                        block50: {
                            buf = new StringBuilder();
                            for (Map.Entry entry : request.getParameterMap().entrySet()) {
                                buf.append((String)entry.getKey()).append(" = ");
                                String[] values = (String[])entry.getValue();
                                if (values != null) {
                                    for (String value : values) {
                                        buf.append(value).append("; ");
                                    }
                                }
                                buf.append("\n");
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug(buf.toString());
                            }
                            con = Setup.getSetup().getDBConnectionFromPool();
                            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                            int paymentId = moduleSetup.getInt("twpg.payment.type.id", 0);
                            if (paymentId < 1) {
                                logger.error("No set param \"twpg.payment.type.id\" in config");
                                response.setStatus(500);
                                ServerUtils.closeConnection((Connection)con);
                                return;
                            }
                            String secret = moduleSetup.get("twpg.secret");
                            if (Utils.isBlankString((String)secret)) {
                                logger.error("No set param \"twpg.secret\" in config");
                                response.setStatus(500);
                                ServerUtils.closeConnection((Connection)con);
                                return;
                            }
                            TRTYPE = Utils.parseInt((String)request.getParameter("TRTYPE"), (int)-1);
                            if (!(TRTYPE == 0 && this.check(request, secret, SET_0) || TRTYPE == 1 && this.check(request, secret, SET_1) || TRTYPE == 21 && this.check(request, secret, SET_21) || TRTYPE == 22 && this.check(request, secret, SET_22))) {
                                logger.error("Error check sign");
                                response.setStatus(500);
                                ServerUtils.closeConnection((Connection)con);
                                return;
                            }
                            String TERMINAL = moduleSetup.get("twpg.terminal");
                            if (Utils.isBlankString((String)TERMINAL)) {
                                logger.error("No set param \"twpg.terminal\" in config");
                                response.setStatus(500);
                                ServerUtils.closeConnection((Connection)con);
                                return;
                            }
                            if (!TERMINAL.equals(request.getParameter("TERMINAL"))) {
                                logger.error("Value param \"twpg.terminal\" in config not equals param TERMINAL in query");
                                response.setStatus(500);
                                ServerUtils.closeConnection((Connection)con);
                                return;
                            }
                            String ORDER = request.getParameter("ORDER");
                            transaction = (Transaction)transactionManager.get(Utils.parseInt((String)ORDER));
                            if (transaction == null) {
                                logger.error("Not found transaction for ID = " + ORDER);
                                response.setStatus(500);
                                ServerUtils.closeConnection((Connection)con);
                                return;
                            }
                            RESULT = Utils.parseInt((String)request.getParameter("RESULT"), (int)-1);
                            TIMESTAMP = TimeUtils.parseDate((String)request.getParameter("TIMESTAMP"), (String)"yyyyMMddHHmmss");
                            RCTEXT = request.getParameter("RCTEXT");
                            AUTHCODE = request.getParameter("AUTHCODE");
                            CHANNEL = request.getParameter("CHANNEL");
                            CARD = request.getParameter("CARD");
                            BigDecimal AMOUNT = new BigDecimal(request.getParameter("AMOUNT"));
                            if (TRTYPE != 1) break block50;
                            if ((RESULT == 0 || RESULT == 1) && transaction.getPaymentId() < 0) {
                                Payment payment = new Payment();
                                payment.setContractId(transaction.getContractId());
                                payment.setSum(AMOUNT);
                                payment.setDate(TIMESTAMP);
                                payment.setTypeId(paymentId);
                                payment.setComment("[" + AUTHCODE + "] \u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 TWPG");
                                try (PaymentDao paymentDao = new PaymentDao(con);){
                                    paymentDao.update((Object)payment);
                                }
                                BalanceUtils balanceUtils = new BalanceUtils(con);
                                balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
                                balanceUtils.close();
                                transaction.setPaymentId(payment.getId());
                                EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                            }
                            break block51;
                        }
                        if (TRTYPE != 22) break block52;
                        if ((RESULT == 0 || RESULT == 1) && transaction.getPaymentId() > 0) {
                            new PaymentManager(con).deletePayment(transaction.getPaymentId());
                            try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                                balanceUtils.updateBalance(TIMESTAMP, transaction.getContractId());
                            }
                            transaction.setPaymentId(-1);
                            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, transaction.getSum().negate()));
                        }
                        break block51;
                    }
                    if (TRTYPE == 0 || TRTYPE == 21) {
                        // empty if block
                    }
                }
                transaction.setStatus(RCTEXT);
                transaction.setTransactionDate(TIMESTAMP);
                transaction.setCard(CHANNEL + " " + CARD);
                transaction.setAuthorizationCode(AUTHCODE);
                transaction.setParameters(buf.toString());
                transactionManager.update(transaction);
            }
            ServerUtils.closeConnection((Connection)con);
        }
        catch (BGException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            response.setStatus(500);
            return;
        }
        response.setStatus(200);
        return;
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private boolean check(HttpServletRequest request, String secret, String[] checkParams) {
        boolean result = false;
        StringBuilder str = new StringBuilder();
        for (String paramName : checkParams) {
            String paramValue = request.getParameter(paramName);
            if (paramValue == null || paramValue.length() == 0) {
                str.append("-");
                continue;
            }
            str.append(paramValue.length() + paramValue);
        }
        byte[] keyBytes = new byte[secret.length() / 2];
        for (int j = 0; j < secret.length(); j += 2) {
            keyBytes[j / 2] = (byte)Integer.parseInt(secret.substring(j, j + 2), 16);
        }
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(keyBytes, "HmacSHA1"));
            String cSign = Utils.bytesToString((byte[])mac.doFinal(str.toString().getBytes()), (boolean)true, null);
            String pSign = request.getParameter("P_SIGN");
            result = cSign.equals(pSign);
            if (logger.isDebugEnabled()) {
                logger.debug("cSign = " + cSign);
                logger.debug("pSign = " + pSign);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return result;
    }
}

