/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.admin;

import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelPeriodNoDay;
import bitel.billing.module.common.BGFileFilter;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import jakarta.activation.DataSource;
import jakarta.xml.ws.Holder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGContractTitleDialog;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.modules.bill.client.BillDoc;
import ru.bitel.bgbilling.modules.bill.client.ServiceConfigAccountViewer;
import ru.bitel.bgbilling.modules.bill.client.ServiceConfigBillViewer;
import ru.bitel.bgbilling.modules.bill.common.bean.AccountContractReport;
import ru.bitel.bgbilling.modules.bill.common.bean.AccountReport;
import ru.bitel.bgbilling.modules.bill.common.service.BillAccountReportService;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGEmailDialog;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrType;

public class ServiceConfigAccountReport
extends ServiceConfigTabbedPanel {
    private static final String CARD_LAYOUT_VIEW = "view";
    private static final String CARD_LAYOUT_TABLE = "table";
    private static final String CARD_LAYOUT_VIEWER = "viewer";
    byte[] docBytes = null;
    private String contractTitle = null;
    private BGTextField selSum = null;
    private BGTextField allSum = null;
    private BGUTable accountReportTable = null;
    private CardLayout cardLayout = new CardLayout();
    private JPanel topPanel = new JPanel(new GridBagLayout());
    private JPanel cardPanel = new JPanel(this.cardLayout);
    private List<AccountReport> accountReportList = null;
    private AccountReportTableModel accountReportTableModel = null;
    private JToggleButton viewButton = new JToggleButton("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440");
    private BGUTable contractSummaryAccountReportTable = null;
    private ContractSummaryAccountReportTableModel contractSummaryAccountReportTableModel = null;
    private BGControlPanelPeriodNoDay periodPanel = new BGControlPanelPeriodNoDay();
    private BGControlPanelContractSelect contract = new BGControlPanelContractSelect(false);
    private BGUComboBox<IdTitle> organizations = new BGUComboBox();
    private BillAccountReportService accountReportService = null;
    private JPanel scalePanel = null;
    private JComboBox<String> scale = new JComboBox();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.SAVE_M, BGButtonPanel.EMAIL_M, BGButtonPanel.PRINT_M});
    private ServiceConfigAccountViewer awtViewer = new ServiceConfigAccountViewer(this.scale, this.pagePanel);
    private ServiceConfigBillViewer viewer = new ServiceConfigBillViewer(true);

    public ServiceConfigAccountReport() {
        this.pagePanel.setVisible(false);
        this.buttonPanel.setVisible(false);
        Dimension dimension = new Dimension(400, 20);
        this.contract.setMinimumSize(dimension);
        this.contract.setPreferredSize(dimension);
        this.accountReportService = (BillAccountReportService)this.getContext().getPort(BillAccountReportService.class);
        this.accountReportTableModel = new AccountReportTableModel(AccountReportTableModel.class.getName());
        this.accountReportTable = new BGUTable((TableModel)((Object)this.accountReportTableModel));
        this.accountReportTable.getSelectionModel().addListSelectionListener(e -> this.selSum.setText(this.getSums(this.accountReportTableModel.getSelectedRows())));
        this.accountReportTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AccountReport accountReport = (AccountReport)ServiceConfigAccountReport.this.accountReportTableModel.getSelectedRow();
                if (accountReport != null && accountReport.getType() == 1 && mouseEvent.getClickCount() == 2) {
                    BillDoc billDoc = new BillDoc();
                    billDoc.type = 1;
                    billDoc.cid = accountReport.getContractId();
                    billDoc.docId = accountReport.getDocumentId();
                    billDoc.number = accountReport.getDocumentNumber();
                    ArrayList<BillDoc> docs = new ArrayList<BillDoc>(Arrays.asList(billDoc));
                    if (docs.isEmpty()) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b");
                    } else {
                        ServiceConfigAccountReport.this.viewer.openDocuments(docs, false);
                        ServiceConfigAccountReport.this.topPanel.setVisible(false);
                        ServiceConfigAccountReport.this.cardLayout.show(ServiceConfigAccountReport.this.cardPanel, ServiceConfigAccountReport.CARD_LAYOUT_VIEWER);
                    }
                }
            }
        });
        this.contractSummaryAccountReportTableModel = new ContractSummaryAccountReportTableModel(ContractSummaryAccountReportTableModel.class.getName());
        this.contractSummaryAccountReportTable = new BGUTable((TableModel)((Object)this.contractSummaryAccountReportTableModel));
        this.contractSummaryAccountReportTable.getSelectionModel().addListSelectionListener(e -> this.setAccountReportTableModelData());
        this.jbInit();
    }

    private String getSums(List<AccountReport> list) {
        BigDecimal cSum = BigDecimal.ZERO;
        BigDecimal dSum = BigDecimal.ZERO;
        for (AccountReport accountReport : list) {
            cSum = cSum.add(accountReport.getCreditSum());
            dSum = dSum.add(accountReport.getDebetSum());
        }
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###,##0.00");
        return decimalFormat.format(cSum) + " / " + decimalFormat.format(dSum);
    }

    protected void jbInit() {
        this.viewer.addPropertyChangeListener(propertyChangeEvent -> {
            if ("toList".equals(propertyChangeEvent.getPropertyName())) {
                this.topPanel.setVisible(true);
                this.cardLayout.show(this.cardPanel, CARD_LAYOUT_TABLE);
            }
        });
        this.cardPanel.add((Component)new BGSplitPaneNoBorder(0, (Component)this.getContractSummaryPanel(), (Component)this.getAccountReportPanel(), 200L), CARD_LAYOUT_TABLE);
        this.cardPanel.add((Component)this.getViewPanel(), CARD_LAYOUT_VIEW);
        this.cardPanel.add((Component)((Object)this.viewer), CARD_LAYOUT_VIEWER);
        int gridY = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.cardPanel, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    private JPanel getTopPanel() {
        JButton generateButton = new JButton("\u0421\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        generateButton.addActionListener(e -> {
            try {
                BigDecimal[] sums;
                List contractIds = Utils.toIntegerList((String)this.contract.getContracts());
                this.accountReportList = this.accountReportService.searchAccountReport(this.periodPanel.getPeriod(), contractIds).getList();
                this.setAccountReportTableModelData();
                HashMap<Integer, BigDecimal[]> sumMap = new HashMap<Integer, BigDecimal[]>();
                for (AccountReport accountReport : this.accountReportList) {
                    int contractId = accountReport.getContractId();
                    sums = (BigDecimal[])sumMap.get(contractId);
                    if (sums == null) {
                        sums = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
                        sumMap.put(contractId, sums);
                    }
                    sums[0] = sums[0].add(accountReport.getCreditSum());
                    sums[1] = sums[1].add(accountReport.getDebetSum());
                }
                SearchResult searchResult2 = this.accountReportService.searchAccountContractReport(this.periodPanel.getPeriod(), contractIds);
                for (AccountContractReport accountContractReport : searchResult2.getList()) {
                    sums = (BigDecimal[])sumMap.get(accountContractReport.getContractId());
                    if (sums == null) continue;
                    accountContractReport.setTurnoverCredit(sums[0]);
                    accountContractReport.setTurnoverDebet(sums[1]);
                    BigDecimal outSum = accountContractReport.getSaldoCreditIn().add(sums[0]).subtract(accountContractReport.getSaldoDebetIn().add(sums[1]));
                    if (outSum.compareTo(BigDecimal.ZERO) > 0) {
                        accountContractReport.setSaldoCreditOut(outSum);
                        continue;
                    }
                    accountContractReport.setSaldoDebetOut(outSum);
                }
                this.contractSummaryAccountReportTableModel.setData(searchResult2.getList());
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        this.viewButton.addActionListener(actionEvent -> {
            boolean view = ((JToggleButton)actionEvent.getSource()).isSelected();
            if (view) {
                this.contractTitle = null;
                view = this.setViewData();
            }
            this.scalePanel.setVisible(view);
            this.pagePanel.setVisible(view);
            this.buttonPanel.setVisible(view);
            this.cardLayout.show(this.cardPanel, view ? CARD_LAYOUT_VIEW : CARD_LAYOUT_TABLE);
        });
        this.buttonPanel.addActionListener(actionEvent -> {
            String actionCommand = actionEvent.getActionCommand();
            if (BGButtonPanel.EMAIL_M.getActionCommand().equals(actionCommand)) {
                if (this.contractTitle == null) {
                    return;
                }
                BGEmailDialog dialog = new BGEmailDialog();
                dialog.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("selectEmail")) {
                            try {
                                IdTitle idTitle = (IdTitle)ServiceConfigAccountReport.this.organizations.getSelectedItem();
                                int organizationId = idTitle != null ? idTitle.getId() : -1;
                                ServiceConfigAccountReport.this.accountReportService.sendDocumentToEmail(ServiceConfigAccountReport.this.periodPanel.getPeriod(), Utils.toIntegerList((String)ServiceConfigAccountReport.this.contract.getContracts()), organizationId, ServiceConfigAccountReport.this.contractTitle, String.valueOf(propertyChangeEvent.getNewValue()));
                                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u0447\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                            }
                            catch (BGException ex) {
                                ClientUtils.showErrorMessageDialog((Throwable)ex);
                            }
                        }
                    }
                });
                int parameterId = 0;
                HashSet emails = new HashSet();
                ArrayList contacts = new ArrayList();
                Iterator iterator = Utils.maskNull((Set)this.contract.getContractSet()).iterator();
                while (iterator.hasNext()) {
                    int contractId = (Integer)iterator.next();
                    try {
                        Map map = ((ContractService)this.getKernelContext().getPort(ContractService.class)).contractParameterMapByType(contractId, EntitySpecAttrType.EMAIL.getCode()).getMap();
                        map.forEach((a, b) -> {
                            if (parameterId < 1 || a == parameterId) {
                                contacts.addAll(((EntityAttrEmail)b).getContactList().stream().filter(f -> {
                                    if (emails.contains(f.getAddress())) {
                                        return false;
                                    }
                                    emails.add(f.getAddress());
                                    return true;
                                }).map(m -> m.toString()).collect(Collectors.toList()));
                            }
                        });
                    }
                    catch (Exception e) {
                        ClientUtils.showErrorMessageDialog((Throwable)e);
                    }
                }
                dialog.setEmailList(contacts);
                dialog.setVisible(true);
            } else if (BGButtonPanel.SAVE_M.getActionCommand().equals(actionCommand)) {
                if (this.contractTitle == null) {
                    return;
                }
                BGFileChooser fileChooser = new BGFileChooser((Component)JOptionPane.getRootFrame());
                FileFilter[] ff = fileChooser.getChoosableFileFilters();
                if (ff != null) {
                    for (int i = 0; i < ff.length; ++i) {
                        fileChooser.removeChoosableFileFilter(ff[i]);
                    }
                }
                fileChooser.addChoosableFileFilter((FileFilter)new BGFileFilter("pdf", "PDF \u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442"));
                if (fileChooser.showSaveDialog((Component)JOptionPane.getRootFrame()) == 0) {
                    File file;
                    Object path = fileChooser.getSelectedFile().getAbsolutePath();
                    if (!((String)path).regionMatches(true, ((String)path).length() - 4, ".pdf", 0, 4)) {
                        path = (String)path + ".pdf";
                    }
                    if ((file = new File((String)path)).exists()) {
                        String text = "\u0424\u0430\u0439\u043b " + file.getName() + " \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c?";
                        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), text, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) != 0) {
                            return;
                        }
                    }
                    try {
                        IdTitle idTitle = (IdTitle)this.organizations.getSelectedItem();
                        int organizationId = idTitle != null ? idTitle.getId() : -1;
                        this.awtViewer.savePdf(file, this.accountReportService.getPdfDocument(this.periodPanel.getPeriod(), Utils.toIntegerList((String)this.contract.getContracts()), organizationId, this.contractTitle));
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            } else if (BGButtonPanel.PRINT_M.getActionCommand().equals(actionCommand)) {
                this.awtViewer.printBlock();
            }
        });
        try {
            Holder selectedId = new Holder();
            this.organizations.setData(((BillService)this.getContext().getPort(BillService.class)).getOrganizationTitleList(0, Boolean.valueOf(true), selectedId));
            for (int index = 0; index < this.organizations.getItemCount(); ++index) {
                IdTitle idTitle = (IdTitle)this.organizations.getItemAt(index);
                if (idTitle.getId() != ((Integer)selectedId.value).intValue()) continue;
                this.organizations.setSelectedIndex(index);
                break;
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        int gridx = 0;
        this.scalePanel = this.getScalePanel();
        this.topPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.topPanel.add((Component)this.periodPanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 2, 0, 2), 0, 0));
        this.topPanel.add((Component)this.contract, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(5, 25, 0, 2), 0, 0));
        this.topPanel.add((Component)this.organizations, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(5, 25, 0, 2), 0, 0));
        this.topPanel.add((Component)generateButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
        this.topPanel.add((Component)this.viewButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
        this.topPanel.add(Box.createHorizontalStrut(1), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.topPanel.add((Component)this.buttonPanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
        this.topPanel.add((Component)this.scalePanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 25, 0, 5), 0, 0));
        this.topPanel.add((Component)this.pagePanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 25, 0, 5), 0, 0));
        return this.topPanel;
    }

    private JPanel getViewPanel() {
        AbstractAction xmlAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextArea xmlText = new JTextArea(30, 100);
                xmlText.setMargin(new Insets(3, 3, 3, 3));
                IdTitle idTitle = (IdTitle)ServiceConfigAccountReport.this.organizations.getSelectedItem();
                int organizationId = idTitle != null ? idTitle.getId() : -1;
                try {
                    xmlText.setText(ServiceConfigAccountReport.this.accountReportService.getXmlDocument(ServiceConfigAccountReport.this.periodPanel.getPeriod(), Utils.toIntegerList((String)ServiceConfigAccountReport.this.contract.getContracts()), organizationId, ServiceConfigAccountReport.this.contractTitle));
                }
                catch (BGException e1) {
                    ClientUtils.showErrorMessageDialog((Throwable)e1);
                }
                JScrollPane scrollPane = new JScrollPane(xmlText);
                scrollPane.scrollRectToVisible(new Rectangle(10, 10));
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, "XML", -1);
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)this.awtViewer), "Center");
        this.awtViewer.getActionMap().put("showXml", xmlAction);
        panel.addComponentListener(new ComponentAdapter(){
            boolean fl = false;
            Object actionMapKey = null;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(83, 640);
            InputMap inputMap;
            {
                this.inputMap = ServiceConfigAccountReport.this.awtViewer.getInputMap(2);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.actionMapKey = this.inputMap.get(this.keyStroke);
                this.inputMap.put(this.keyStroke, "showXml");
                this.fl = true;
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (this.fl) {
                    this.inputMap.put(this.keyStroke, this.actionMapKey);
                }
            }
        });
        return panel;
    }

    private String getContractTitle() {
        String title = null;
        try {
            List aa = this.accountReportService.getContractTitles(this.contract.getContractSet());
            if (aa != null) {
                if (aa.size() == 1) {
                    title = (String)aa.get(0);
                } else {
                    BGContractTitleDialog contractTitleDialog = new BGContractTitleDialog(aa);
                    contractTitleDialog.setVisible(true);
                    title = contractTitleDialog.getSelectedTitle();
                }
            }
        }
        catch (BGException e) {
            e.printStackTrace();
        }
        return title;
    }

    private boolean setViewData() {
        try {
            this.contractTitle = this.getContractTitle();
            if (this.contractTitle == null) {
                this.viewButton.setSelected(false);
                return false;
            }
            IdTitle idTitle = (IdTitle)this.organizations.getSelectedItem();
            int organizationId = idTitle != null ? idTitle.getId() : -1;
            final byte[] docBytes = this.accountReportService.getDocument(this.periodPanel.getPeriod(), Utils.toIntegerList((String)this.contract.getContracts()), organizationId, this.contractTitle);
            DataSource dataSource = new DataSource(){

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }

                public String getName() {
                    return null;
                }

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(docBytes);
                }

                public String getContentType() {
                    return "text/xml";
                }
            };
            this.awtViewer.showDocument(dataSource);
            this.pagePanel.setPageCount(this.awtViewer.getNumberOfPages());
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        return true;
    }

    private void setAccountReportTableModelData() {
        ArrayList<AccountReport> accountReportData = new ArrayList<AccountReport>();
        if (this.accountReportList != null) {
            List list = this.contractSummaryAccountReportTableModel.getSelectedRows();
            if (list != null && !list.isEmpty()) {
                HashSet<Integer> contractIds = new HashSet<Integer>();
                for (AccountContractReport accountContractReport : list) {
                    contractIds.add(accountContractReport.getContractId());
                }
                for (AccountReport accountReport : this.accountReportList) {
                    if (!contractIds.contains(accountReport.getContractId())) continue;
                    accountReportData.add(accountReport);
                }
            } else {
                accountReportData.addAll(this.accountReportList);
            }
        }
        this.accountReportTableModel.setData(accountReportData);
        this.allSum.setText(this.getSums(accountReportData));
    }

    private JPanel getContractSummaryPanel() {
        JScrollPane scrollPane = new JScrollPane((Component)this.contractSummaryAccountReportTable);
        scrollPane.setPreferredSize(new Dimension(100, 150));
        scrollPane.setMaximumSize(new Dimension(100, 150));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getAccountReportPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.accountReportTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getAccountReportBottomPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getAccountReportBottomPanel() {
        this.selSum = new BGTextField(25);
        Color bgColor = this.selSum.getBackground();
        this.selSum.setEditable(false);
        this.selSum.setBackground(bgColor);
        this.selSum.setHorizontalAlignment(0);
        this.selSum.setText("0.00 / 0.00");
        this.allSum = new BGTextField(25);
        this.allSum.setEditable(false);
        this.allSum.setBackground(bgColor);
        this.allSum.setHorizontalAlignment(0);
        this.allSum.setText("0.00 / 0.00");
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043a\u0440\u0435\u0434\u0438\u0442/\u0434\u0435\u0431\u0435\u0442:"), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.selSum, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430 \u043a\u0440\u0435\u0434\u0438\u0442/\u0434\u0435\u0431\u0435\u0442:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.allSum, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getScalePanel() {
        this.scale.removeAllItems();
        this.scale.addItem("25");
        this.scale.addItem("50");
        this.scale.addItem("75");
        this.scale.addItem("100");
        this.scale.addItem("125");
        this.scale.addItem("150");
        this.scale.addItem("175");
        this.scale.addItem("200");
        this.scale.setSelectedItem("200");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(this.scale, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.setVisible(false);
        return panel;
    }

    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.viewer.init(module, moduleId);
        this.contract.init(module, moduleId);
    }

    class AccountReportTableModel
    extends BGTableModel<AccountReport> {
        private Map<Integer, String> contractTitleMap;
        private Map<Integer, String> contractCommentMap;

        public AccountReportTableModel(String name) {
            super(name);
            this.contractTitleMap = new HashMap<Integer, String>();
            this.contractCommentMap = new HashMap<Integer, String>();
        }

        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430", 100, 100, 100, "createDate", false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 100, 150, 200, "contractTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 100, 300, 400, "contractComment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f (\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442)", 100, 300, -1, "document", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u0440\u0435\u0434\u0438\u0442", 100, 150, 200, "creditSum", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0414\u0435\u0431\u0435\u0442", 100, 150, 200, "debetSum", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public Object getValueAt(AccountReport val, int column) throws BGException {
            String i = this.getIdentifier(column);
            if ("contractTitle".equals(i)) {
                int contractId = val.getContractId();
                String title = this.contractTitleMap.get(contractId);
                if (title == null) {
                    for (AccountContractReport accountContractReport : ServiceConfigAccountReport.this.contractSummaryAccountReportTableModel.getRows()) {
                        if (accountContractReport.getContractId() != contractId) continue;
                        title = accountContractReport.getContractTitle();
                        this.contractTitleMap.put(contractId, title);
                        break;
                    }
                }
                return title;
            }
            if ("contractComment".equals(i)) {
                int contractId = val.getContractId();
                String comment = this.contractCommentMap.get(contractId);
                if (comment == null) {
                    for (AccountContractReport accountContractReport : ServiceConfigAccountReport.this.contractSummaryAccountReportTableModel.getRows()) {
                        if (accountContractReport.getContractId() != contractId) continue;
                        comment = accountContractReport.getContractComment();
                        this.contractCommentMap.put(contractId, comment);
                        break;
                    }
                }
                return comment;
            }
            return super.getValueAt((Object)val, column);
        }
    }

    class ContractSummaryAccountReportTableModel
    extends BGTableModel<AccountContractReport> {
        public ContractSummaryAccountReportTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 100, 150, 200, "contractTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 100, 300, -1, "contractComment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0430\u043b\u044c\u0434\u043e \u0432\u0445\u043e\u0434. (\u041a\u0440\u0435\u0434\u0438\u0442)", 200, 200, 200, "saldoCreditIn", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0421\u0430\u043b\u044c\u0434\u043e \u0432\u0445\u043e\u0434. (\u0414\u0435\u0431\u0435\u0442)", 200, 200, 200, "saldoDebetIn", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041e\u0431\u043e\u0440\u043e\u0442\u044b \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 (\u041a\u0440\u0435\u0434\u0438\u0442)", 200, 200, 200, "turnoverCredit", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041e\u0431\u043e\u0440\u043e\u0442\u044b \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 (\u0414\u0435\u0431\u0435\u0442)", 200, 200, 200, "turnoverDebet", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0421\u0430\u043b\u044c\u0434\u043e \u0438\u0441\u0445\u043e\u0434. (\u041a\u0440\u0435\u0434\u0438\u0442)", 200, 200, 200, "saldoCreditOut", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0421\u0430\u043b\u044c\u0434\u043e \u0438\u0441\u0445\u043e\u0434. (\u0414\u0435\u0431\u0435\u0442)", 200, 200, 200, "saldoDebetOut", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }
    }
}

