/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.bean.ContractUtils;
import java.io.File;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.fop.apps.FOPException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.PersonalTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.PersonalTariffManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.bill.common.bean.Attribute;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.bgbilling.modules.bill.server.bean.AttributeDao;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.DocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.account.Account;
import ru.bitel.bgbilling.modules.bill.server.bean.account.BillAccount;
import ru.bitel.bgbilling.modules.bill.server.bean.account.NpayAccount;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.Counter;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.DialUpCounter;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.IPNCounter;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.InetCounter;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.KernelCounter;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.NPayCounter;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.PhoneCounter;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.RSCMCounter;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.VoiceCounter;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.VoiceIpCounter;
import ru.bitel.bgbilling.modules.bill.server.bean.extractor.Extractor;
import ru.bitel.bgbilling.modules.bill.server.bean.extractor.KernelExtractor;
import ru.bitel.bgbilling.modules.bill.server.bean.extractor.NpayExtractor;
import ru.bitel.bgbilling.modules.bill.server.bean.extractor.RSCMExtractor;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.FOUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.util.MacrosFormat;

public class BillUtil {
    private static final Map<String, Counter> counterMap = new HashMap<String, Counter>();
    private static final Map<String, Account> accountMap = new HashMap<String, Account>();
    private static final Map<String, Extractor> extractorMap = new HashMap<String, Extractor>();
    private static final String billXSLT = "bill_pdf.xsl";
    private static final String invoiceXSLT = "invoice_pdf.xsl";
    private static final String nextmonth = "$nextmonth";
    private static final String prevmonth = "$prevmonth";
    private static final String prev2month = "$prev2month";
    private static final String prev3month = "$prev3month";
    private static final Pattern pMacros;

    private static void parsePosition(Connection con, PositionValue position, String cids, Calendar month) throws BGException {
        position.setUnit(BillUtil.parsePositionUnit(position));
        position.setUnitCode(BillUtil.parsePositionUnitCode(position));
        List<PositionValue> extractPositions = BillUtil.parsePositionExtractor(con, cids, position, month);
        if (extractPositions == null) {
            extractPositions = BillUtil.parseDyncodePosition(con, cids, position, month);
        }
        if (extractPositions != null) {
            for (PositionValue pos : extractPositions) {
                pos.setContractId(position.getContractId());
                pos.setPositionId(position.getPositionId());
                if (Utils.isEmptyString((String)pos.getUnit())) {
                    pos.setUnit(position.getUnit());
                }
                if (!Utils.isEmptyString((String)pos.getUnitCode())) continue;
                pos.setUnitCode(position.getUnitCode());
            }
            position.setExtractPositions(extractPositions);
        } else {
            position.setName(BillUtil.parsePositionName(position.getPosition().getName(), month));
            BillUtil.parsePositionSumm(con, cids, position, month);
            position.setQuantity(BillUtil.parsePositionQuantity(con, cids, position, month));
            position.setQtyNumsAfterComma(BillUtil.parsePositionQuantityNumsAfterComma(position));
            position.setQtyNumsRoundingMode(BillUtil.parsePositionQuantityNumsRoundingMode(position));
        }
    }

    public static String parsePositionName(String name, final Calendar _month) {
        return new MacrosFormat(){

            protected Object invoke(String macros, Object[] args) {
                Calendar month = _month;
                if ("month".equals(macros)) {
                    return month;
                }
                month = (Calendar)month.clone();
                if ("nextmonth".equals(macros)) {
                    month.add(2, 1);
                } else if ("prevmonth".equals(macros)) {
                    month.add(2, -1);
                } else if ("prev2month".equals(macros)) {
                    month.add(2, -2);
                } else if ("prev3month".equals(macros)) {
                    month.add(2, -3);
                }
                return month;
            }

            protected String format(MessageFormat messageFormat, String pattern, Object o) {
                if (pattern == null) {
                    return TimeUtils.monthNames[((Calendar)o).get(2)];
                }
                return super.format(messageFormat, pattern, o).toLowerCase();
            }
        }.format(name, new Object[0]);
    }

    private static void parsePositionSumm(Connection con, String cids, PositionValue position, Calendar month) throws BGException {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal resultScaled = BigDecimal.ZERO;
        BigDecimal resultUnscaled = BigDecimal.ZERO;
        String macros = position.getPosition().getSumm();
        int cid = BillUtil.getMainContractId(cids);
        if (macros != null) {
            Matcher match = pMacros.matcher(macros);
            while (match.find()) {
                String oper = match.group(1);
                if (Utils.isBlankString((String)oper)) {
                    oper = "+";
                }
                String func = match.group(2);
                BigDecimal summ = BigDecimal.ZERO;
                BigDecimal sumScaled = BigDecimal.ZERO;
                BigDecimal sumUnscaled = BigDecimal.ZERO;
                if (func.equals("SERVICE_ACCOUNT") || func.equals("SERVICE_AMOUNT")) {
                    BigDecimal[] sumRef = new BigDecimal[2];
                    BillUtil.getServiceAccount(month, cids, con, match.group(3), match.group(4), sumRef);
                    summ = sumScaled = sumRef[1];
                    sumUnscaled = sumRef[0];
                } else if (func.equals("FULL_ACCOUNT") || func.equals("FULL_AMOUNT")) {
                    BigDecimal[] sumRef = new BigDecimal[2];
                    BillUtil.getServiceAccount(month, cids, con, match.group(3), null, sumRef);
                    summ = sumScaled = sumRef[1];
                    sumUnscaled = sumRef[0];
                } else if (func.equals("DEBT")) {
                    sumScaled = sumUnscaled = BillUtil.getDebt(month, cid, con, match.group(3));
                    summ = sumUnscaled;
                } else if (func.equals("IN_REST")) {
                    sumScaled = sumUnscaled = BillUtil.getInrest(month, cid, con, match.group(3));
                    summ = sumUnscaled;
                } else if (func.equals("CONST")) {
                    sumScaled = sumUnscaled = Utils.parseBigDecimal((String)match.group(3), (BigDecimal)BigDecimal.ZERO);
                    summ = sumUnscaled;
                } else if (func.equals("CHARGE")) {
                    sumScaled = sumUnscaled = BillUtil.getCharge(month, cids, con, match.group(3), match.group(4));
                    summ = sumUnscaled;
                } else if (func.equals("PAYMENT")) {
                    sumScaled = sumUnscaled = BillUtil.getPayment(month, cids, con, match.group(3), match.group(4));
                    summ = sumUnscaled;
                } else if (func.equals("TARIFF_DETAIL_COST")) {
                    int mid = Utils.parseInt((String)match.group(3), (int)0);
                    String[] _params = Utils.patternComma.split(match.group(4));
                    ArrayList params = new ArrayList(_params.length);
                    Collections.addAll(params, Utils.patternComma.split(match.group(4)));
                    BigDecimal[] sumRef = new BigDecimal[2];
                    String monthMacro = (String)params.remove(0);
                    BillUtil.getTariffDetailCost(mid, month, monthMacro, cids, Utils.toString(params), con, sumRef);
                    sumUnscaled = sumRef[0];
                    summ = sumScaled = sumRef[1];
                } else {
                    int pos = func.indexOf(95);
                    String modulePrefix = func.substring(0, pos);
                    Account account = accountMap.get(modulePrefix);
                    if (account != null) {
                        ArrayList<String> paramList = new ArrayList<String>();
                        paramList.add(0, match.group(3));
                        String additionalParams = match.group(4);
                        if (Utils.notBlankString((String)additionalParams)) {
                            Collections.addAll(paramList, Utils.patternComma.split(additionalParams));
                        }
                        sumScaled = sumUnscaled = account.account(func.substring(pos + 1), con, cids, month, paramList);
                        summ = sumUnscaled;
                    }
                }
                if (oper.equals("+")) {
                    result = result.add(summ);
                    resultScaled = resultScaled.add(sumScaled);
                    resultUnscaled = resultUnscaled.add(sumUnscaled);
                    continue;
                }
                result = result.subtract(summ);
                resultScaled = resultScaled.subtract(sumScaled);
                resultUnscaled = resultUnscaled.subtract(sumUnscaled);
            }
        }
        position.setSum(result);
        position.setSumScaled(resultScaled);
        position.setSumUnscaled(resultUnscaled);
    }

    private static int getMainContractId(String cids) {
        int cid = 0;
        int pos = cids.indexOf(44);
        cid = pos > 0 ? Utils.parseInt((String)cids.substring(0, pos)) : Utils.parseInt((String)cids);
        return cid;
    }

    private static String parsePositionUnit(PositionValue position) {
        return Utils.maskBlank((String)position.getPosition().getUnit(), (String)"\u0448\u0442.");
    }

    private static String parsePositionUnitCode(PositionValue position) {
        return Utils.maskBlank((String)position.getPosition().getUnitCode(), (String)"796");
    }

    private static List<PositionValue> parseDyncodePosition(Connection con, String cids, PositionValue position, Calendar month) {
        List<PositionValue> result = null;
        String macros = position.getPosition().getDynclass();
        if (macros != null) {
            String[] str = macros.split("\\(");
            if (str.length < 2 || !str[1].endsWith(")")) {
                return result;
            }
            String className = str[0];
            try {
                Extractor extractor;
                Class clazz = DynamicClassManager.getInstance().loadClass(className);
                if (Extractor.class.isAssignableFrom(clazz) && (extractor = (Extractor)clazz.getConstructor(new Class[0]).newInstance(new Object[0])) != null) {
                    List paramList = Utils.toList((String)str[1].substring(0, str[1].length() - 1));
                    result = extractor.extract("", con, cids, month, paramList, position.getPosition().getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static List<PositionValue> parsePositionExtractor(Connection con, String cids, PositionValue position, Calendar month) {
        int pos;
        String func;
        String modulePrefix;
        Extractor extractor;
        Matcher match;
        List<PositionValue> result = null;
        String macros = position.getPosition().getExtractor();
        if (macros != null && (match = pMacros.matcher(macros)).find() && (extractor = extractorMap.get(modulePrefix = (func = match.group(2)).substring(0, pos = func.indexOf(95)))) != null) {
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add(0, match.group(3));
            String additionalParams = match.group(4);
            if (Utils.notBlankString((String)additionalParams)) {
                Collections.addAll(paramList, Utils.patternComma.split(additionalParams));
            }
            result = extractor.extract(func.substring(pos + 1), con, cids, month, paramList, position.getPosition().getName());
        }
        return result;
    }

    private static BigDecimal parsePositionQuantity(Connection con, String cids, PositionValue position, Calendar month) {
        BigDecimal result = BigDecimal.ZERO;
        String macros = position.getPosition().getQuantity();
        if (macros != null) {
            Matcher match = pMacros.matcher(macros);
            while (match.find()) {
                String oper = match.group(1);
                if (Utils.isBlankString((String)oper)) {
                    oper = "+";
                }
                String func = match.group(2);
                BigDecimal qantity = BigDecimal.ZERO;
                int pos = func.indexOf(95);
                String modulePrefix = func.substring(0, pos);
                Counter counter = counterMap.get(modulePrefix);
                if (counter != null) {
                    ArrayList<String> paramList = new ArrayList<String>();
                    paramList.add(0, match.group(3));
                    Collections.addAll(paramList, Utils.patternComma.split(match.group(4)));
                    qantity = counter.count(func.substring(pos + 1), con, cids, month, paramList);
                }
                if (oper.equals("+")) {
                    result = result.add(qantity);
                    continue;
                }
                result = result.subtract(qantity);
            }
        } else {
            result = BigDecimal.ONE;
        }
        return result;
    }

    private static int parsePositionQuantityNumsAfterComma(PositionValue position) {
        int result = 0;
        String nums = position.getPosition().getQtyNumsAfterComma();
        if (Utils.notBlankString((String)nums)) {
            result = Utils.parseInt((String)nums);
        }
        return result;
    }

    private static int parsePositionQuantityNumsRoundingMode(PositionValue position) {
        int result = 4;
        String nums = position.getPosition().getQtyNumsRoundingMode();
        if (Utils.notBlankString((String)nums)) {
            result = Utils.parseInt((String)nums);
        }
        return result;
    }

    public static boolean isPast(int yy, int mm) {
        GregorianCalendar now = new GregorianCalendar();
        return yy == now.get(1) && mm <= now.get(2) || yy < now.get(1);
    }

    protected static BigDecimal getInrest(Calendar month, int cid, Connection con) {
        try (BalanceUtils bu = new BalanceUtils(con);){
            BigDecimal bigDecimal = bu.getBalanceSumma1(month.getTime(), cid);
            return bigDecimal;
        }
    }

    protected static BigDecimal getDebt(Calendar month, int cid, Connection con) {
        try (BalanceUtils bu = new BalanceUtils(con);){
            BigDecimal bigDecimal = bu.getBalance(month.getTime(), cid).negate();
            return bigDecimal;
        }
    }

    private static BigDecimal getPayment(Calendar month, String cids, Connection con, String monthMacro, String _params) {
        return BillUtil.getPayment(BillUtil.moveDate(month, monthMacro), cids, _params, con);
    }

    protected static BigDecimal getPayment(Calendar month, String cids, String pt, Connection con) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            String query = null;
            query = "SELECT SUM(summa) FROM contract_payment WHERE cid IN (" + cids + ") AND YEAR(dt)=? AND MONTH(dt)=?";
            if (Utils.notBlankString((String)pt)) {
                query = query + " AND pt IN ( " + pt + ")";
            }
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, month.get(1));
            ps.setInt(2, month.get(2) + 1);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static BigDecimal getCharge(Calendar month, String cids, Connection con, String monthMacro, String _params) {
        return BillUtil.getCharge(BillUtil.moveDate(month, monthMacro), cids, _params, con);
    }

    protected static BigDecimal getCharge(Calendar month, String cids, String pt, Connection con) {
        BigDecimal amount = BigDecimal.ZERO;
        try {
            String query = null;
            query = "SELECT SUM(summa) FROM contract_charge  WHERE cid IN (" + cids + ") AND dt>=? AND dt<=?";
            if (Utils.notBlankString((String)pt)) {
                query = query + " AND pt IN ( " + pt + ")";
            }
            PreparedStatement ps = con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)TimeUtils.getStartMonth((Calendar)month)));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)TimeUtils.getEndMonth((Calendar)month)));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                amount = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return amount;
    }

    private static void getServiceAccount(Calendar monthCal, String cids, Connection con, String monthMacro, String _params, BigDecimal[] sum) {
        BillUtil.getServiceAccount(BillUtil.moveDate(monthCal, monthMacro), cids, _params, con, sum);
    }

    protected static void getServiceAccount(Calendar month, String cids, String sid, Connection con, BigDecimal[] sum) {
        sum[0] = sum[1] = BigDecimal.ZERO;
        try {
            String query = null;
            query = "SELECT SUM( summa ), SUM( ROUND(summa, 2) ) FROM contract_account WHERE cid IN (" + cids + ") AND yy=? AND mm=?";
            if (Utils.notBlankString((String)sid)) {
                query = query + " AND sid IN ( " + sid + ")";
            }
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, month.get(1));
            ps.setInt(2, month.get(2) + 1);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                sum[0] = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
                sum[1] = Utils.maskNull((BigDecimal)rs.getBigDecimal(2));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static void getTariffDetailCost(int mid, Calendar month, String monthMacro, String cids, String costTypes, Connection con, BigDecimal[] sum) {
        month = BillUtil.moveDate(month, monthMacro);
        sum[0] = sum[1] = BigDecimal.ZERO;
        try {
            String tableName = ServerUtils.getModuleMonthTableName((String)"tariff_detail", (Date)month.getTime(), (int)mid);
            if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
                String query = null;
                query = "SELECT SUM(cost) FROM " + tableName + " WHERE cid IN (" + cids + ")";
                if (Utils.notBlankString((String)costTypes)) {
                    query = query + " AND cost_type_id IN ( " + costTypes + ")";
                }
                query = query + " GROUP BY sid";
                PreparedStatement ps = con.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    BigDecimal value = rs.getBigDecimal(1);
                    sum[0] = sum[0].add(value);
                    sum[1] = sum[1].add(value.setScale(2, RoundingMode.HALF_EVEN));
                }
                rs.close();
                ps.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static BigDecimal getDebt(Calendar month, int cid, Connection con, String monthMacro) {
        return BillUtil.getDebt(BillUtil.moveDate(month, monthMacro), cid, con);
    }

    private static BigDecimal getInrest(Calendar month, int cid, Connection con, String monthMacro) throws BGException {
        return BillUtil.getInrest(BillUtil.moveDate(month, monthMacro), cid, con);
    }

    public static void buildParamsAndAttributesList(Connection con, int moduleId, Preferences moduleSetup, int contractId, XMLStreamWriter node, DocType docType, String userName) throws XMLStreamException {
        ContractUtils contractUtils = new ContractUtils(con);
        try {
            Set xmlContractConsist = docType.getXmlContractConsist();
            if (moduleSetup.getInt("add.contract", 0) > 0 && xmlContractConsist == null || xmlContractConsist != null) {
                node.writeStartElement("contract_data");
                node.writeAttribute("id", String.valueOf(contractId));
                contractUtils.addContractXML(contractId, node, true, true, true, xmlContractConsist, docType.getXmlModulesConsist(), docType.getXmlPluginsConsist());
                node.writeEndElement();
            }
            if (xmlContractConsist == null || xmlContractConsist.contains(1)) {
                contractUtils.addContractParameters(contractId, node, "contract_params");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        node.writeStartElement("params");
        node.writeAttribute("nds", moduleSetup.get("bill.nds", "0.00"));
        for (Map.Entry entry : docType.getSetup().sub("param.").entrySet()) {
            node.writeStartElement("param");
            node.writeAttribute("key", (String)entry.getKey());
            node.writeCharacters(((String)entry.getValue()).replace("${userName}", userName));
            node.writeEndElement();
        }
        node.writeEndElement();
        try (AttributeDao attributeDao = new AttributeDao(con, moduleId);
             ContractDao contractDao = new ContractDao(con, 0);){
            node.writeStartElement("attributes");
            HashMap paramMap = null;
            HashMap paramSuperMap = null;
            Contract contract = (Contract)contractDao.get(contractId);
            for (Attribute attribute : attributeDao.getActiveAttributeList(contractId)) {
                String value;
                if (attribute.getContractParamPrefId() < 1) {
                    node.writeAttribute(attribute.getName(), attribute.getValue());
                    continue;
                }
                if (paramMap == null) {
                    paramMap = new ContractParameterManager(con).getValuesForPids((Set)null, contractId);
                }
                if ((value = (String)paramMap.get(attribute.getContractParamPrefId())) == null && attribute.isUseSuperContract() && contract.isSub()) {
                    if (paramSuperMap == null) {
                        paramSuperMap = new ContractParameterManager(con).getValuesForPids((Set)null, contract.getSuperCid());
                    }
                    value = (String)paramSuperMap.get(attribute.getContractParamPrefId());
                }
                node.writeAttribute(attribute.getName(), Utils.maskNull((String)value));
            }
            node.writeEndElement();
        }
        catch (BGException e) {
            e.printStackTrace();
        }
    }

    public static void addTariffInfo(Connection con, XMLStreamWriter node, DocType docType, int contractId, Date date1, Date date2) throws XMLStreamException, SQLException {
        Set xmlContractConsist = docType.getXmlContractConsist();
        if (xmlContractConsist.contains(4) || xmlContractConsist.contains(5)) {
            node.writeStartElement("tariff_bill");
            if (xmlContractConsist.contains(4)) {
                String query = "SELECT plan.id, plan.title, ct.date1, ct.date2 FROM contract_tariff AS ct, tariff_plan AS plan WHERE ct.tpid=plan.id AND ct.cid=? AND ( ct.date1 IS NULL OR ct.date1<=? ) AND ( ct.date2 IS NULL OR ct.date2>=? )";
                try (PreparedStatement ps = con.prepareStatement(query);){
                    ps.setInt(1, contractId);
                    ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date2));
                    ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date1));
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        node.writeStartElement("tariff");
                        node.writeAttribute("tpid", String.valueOf(rs.getInt(1)));
                        node.writeAttribute("title", rs.getString(2));
                        node.writeAttribute("date1", TimeUtils.formatDate((Date)rs.getDate(3)));
                        node.writeAttribute("date2", TimeUtils.formatDate((Date)rs.getDate(4)));
                        node.writeEndElement();
                    }
                    rs.close();
                }
            }
            if (xmlContractConsist.contains(5)) {
                for (PersonalTariff tariff : new PersonalTariffManager(con).getPersonalTariffList(contractId, date1, date2)) {
                    node.writeStartElement("personal_tariff");
                    node.writeAttribute("id", String.valueOf(tariff.getId()));
                    node.writeAttribute("tree_id", String.valueOf(tariff.getTreeId()));
                    node.writeAttribute("title", tariff.getTitle());
                    node.writeAttribute("date1", TimeUtils.formatDate((Calendar)tariff.getDate1()));
                    node.writeAttribute("date2", TimeUtils.formatDate((Calendar)tariff.getDate2()));
                    node.writeEndElement();
                }
            }
            node.writeEndElement();
        }
    }

    public static List<PositionValue> getPositionList(Connection con, Calendar month, bitel.billing.server.contract.bean.Contract contract, String cids, DocType docType, Map<Integer, Position> positionMap) {
        ArrayList<PositionValue> result = new ArrayList<PositionValue>();
        try {
            Iterator iterator = docType.getPositionList().iterator();
            while (iterator.hasNext()) {
                int posId = (Integer)iterator.next();
                Position position = positionMap.get(posId);
                if (position == null) continue;
                String data = position.getData();
                if (data != null) {
                    JSONObject json = new JSONObject(data);
                    int notApply = json.optInt("notApply", 0);
                    if (contract.getSuperId() == -1 && (notApply & 1) > 0 || contract.isDependSub() && (notApply & 2) > 0 || contract.isIndependSub() && (notApply & 4) > 0) continue;
                }
                PositionValue positionValue = new PositionValue();
                positionValue.setContractId(contract.getId());
                positionValue.setPositionId(posId);
                positionValue.setPosition(position);
                BillUtil.parsePosition(con, positionValue, cids, month);
                List<PositionValue> extractPositions = positionValue.getExtractPositions();
                if (extractPositions != null) {
                    for (PositionValue extractPos : extractPositions) {
                        extractPos.setPosition(position);
                        result.add(extractPos);
                    }
                    continue;
                }
                result.add(positionValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static final String getPatternName(Setup setup, String type, Connection con, int moduleId, int docId) {
        String result = null;
        try {
            int typeId = 0;
            if (type.equals("bill")) {
                try (BillManager billManager = new BillManager(con, moduleId);){
                    typeId = billManager.getBill(docId).getTypeId();
                }
            }
            try (InvoiceManager invoiceManager = new InvoiceManager(con, moduleId);){
                typeId = invoiceManager.getInvoice(docId).getTypeId();
            }
            DocTypeManager typeManager = new DocTypeManager(con, moduleId);
            DocType docType = typeManager.getType(typeId);
            if (docType != null && Utils.notBlankString((String)docType.getPattern())) {
                result = docType.getPattern();
            }
            if (Utils.isBlankString(result)) {
                result = type.equals("bill") ? billXSLT : invoiceXSLT;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Calendar moveDate(Calendar month, String monthMacro) {
        Calendar result = (Calendar)month.clone();
        if (monthMacro.equals(prevmonth)) {
            result.add(2, -1);
        } else if (monthMacro.equals(nextmonth)) {
            result.add(2, 1);
        } else if (monthMacro.equals(prev2month)) {
            result.add(2, -2);
        } else if (monthMacro.equals(prev3month)) {
            result.add(2, -3);
        }
        return result;
    }

    public static void addInline(Element rootNode, Preferences moduleSetup, int userID) {
        Element inlineParamsEl = rootNode.getOwnerDocument().createElement("inline_params");
        rootNode.appendChild(inlineParamsEl);
        StringTokenizer st = new StringTokenizer(moduleSetup.get("inline.params", "").replaceAll("^(\\d+;?)*\\|", ""), ";");
        while (st.hasMoreTokens()) {
            String param = st.nextToken().trim();
            String value = moduleSetup.get("inline.param." + userID + "." + param, null);
            if (!Utils.notBlankString((String)value)) continue;
            inlineParamsEl.setAttribute(param, value);
        }
    }

    public static void convertDocument(Setup setup, Connection con, int mid, Document doc, String patternName, OutputStream baos) throws FOPException, TransformerException, BGException {
        if (patternName.endsWith(".jrxml")) {
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("mid", String.valueOf(mid));
            JasperReport report = BGReportTemplate.getJasperReport((URI)new File(XSLManager.getInstance().getXslRootPath() + patternName).toURI());
            BGReportTemplate.fillReportToPdfStream((JasperReport)report, (BGReportFilter)new BGReportFilter(filter, (Preferences)setup, 0), (Connection)con, (Document)doc, (OutputStream)baos);
        } else {
            Element bill = (Element)doc.getDocumentElement().getElementsByTagName("bill").item(0);
            bill.setAttribute("with_stamp", "1");
            XSLManager.getInstance().transform((Source)new DOMSource(doc), patternName, (Result)FOUtils.renderSAXResult((OutputStream)baos, (String)"application/pdf"));
        }
    }

    static {
        counterMap.put("KERNEL", new KernelCounter());
        counterMap.put("DIALUP", new DialUpCounter());
        counterMap.put("VOICEIP", new VoiceIpCounter());
        counterMap.put("IPN", new IPNCounter());
        counterMap.put("RSCM", new RSCMCounter());
        counterMap.put("PHONE", new PhoneCounter());
        counterMap.put("NPAY", new NPayCounter());
        counterMap.put("INET", new InetCounter());
        counterMap.put("VOICE", new VoiceCounter());
        extractorMap.put("KERNEL", new KernelExtractor());
        extractorMap.put("NPAY", new NpayExtractor());
        extractorMap.put("RSCM", new RSCMExtractor());
        accountMap.put("NPAY", new NpayAccount());
        accountMap.put("BILL", new BillAccount());
        pMacros = Pattern.compile("\\s*([+-]*)\\s*(\\w+)\\(\\s*([\\$\\w\\d]+)?\\s*(?:,\\s*([\\d,\\s\\w\\$]+))?\\)");
    }
}

