/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import bitel.billing.server.contract.bean.Contract;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.StartElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.Invoice;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceDocumentDao;
import ru.bitel.bgbilling.modules.bill.server.bean.NumerationPoolManager;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.event.InvoiceCreatedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Page;

public class InvoiceManager
extends AbstractManager {
    private static final Logger log = LogManager.getLogger();
    private static Object addInvoiceMutex = new Object();

    public InvoiceManager(Connection con, int moduleId) {
        super(con, moduleId, "bill_invoice_data_" + moduleId);
    }

    public BillDoc getInvoice(int id) {
        Invoice result = null;
        try {
            String query = "SELECT * FROM " + this.table + " WHERE id=" + id;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                result = this.getInvoiceFromRS(rs, false, false);
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Invoice> getInvoiceList(Page page, int yy, int mm, Calendar from, Calendar until, int unloadType, String contractLabels, String labelMode, String contractTitle, String billNumber, boolean getXml, String type, int packageParamId, int packageId, int addressSortParam, String nameSortParam, int sortMode, int secondarySortMode, boolean forRegister) {
        PreparedStatement ps;
        ArrayList<Invoice> adminInvoiceList = new ArrayList<Invoice>();
        List listIds = Utils.toList((String)contractLabels);
        StringBuffer query = new StringBuffer();
        if (listIds.size() > 0) {
            if (labelMode.equals("or")) {
                query.append("CREATE TEMPORARY TABLE IF NOT EXISTS `cids` AS (SELECT DISTINCT `contract_id` FROM `contract_label_link` WHERE `label_id` IN ( " + Utils.toString((Iterable)listIds) + " ) )");
                try {
                    ps = this.con.prepareStatement(query.toString());
                    try {
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else if (labelMode.equals("and")) {
                query.append("CREATE TEMPORARY TABLE IF NOT EXISTS `cids` AS (SELECT `contract_id`, count(*) as c FROM `contract_label_link` WHERE `label_id` IN ( " + Utils.toString((Iterable)listIds) + " ) GROUP BY `contract_id` HAVING c=? )");
                try {
                    ps = this.con.prepareStatement(query.toString());
                    try {
                        ps.setInt(1, listIds.size());
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        query.setLength(0);
        query.append("SELECT SQL_CALC_FOUND_ROWS bill_data.* , contract.title, contract.comment, type.title");
        if (sortMode == 9 || secondarySortMode == 9) {
            query.append(", if( super_contract.title is null,CONCAT(contract.title,\"-\"),CONCAT(CONCAT(super_contract.title,\"-\"),contract.title)) AS sub_sort");
        }
        this.addStreetCol(addressSortParam, sortMode, secondarySortMode, query, forRegister);
        this.addNameCol(nameSortParam, sortMode, secondarySortMode, query);
        query.append(" FROM ").append(this.table).append(" AS bill_data ");
        if (listIds.size() > 0) {
            query.append(" INNER JOIN cids ON bill_data.cid=cids.contract_id ");
        }
        query.append(" LEFT JOIN bill_doc_type_" + this.moduleId + " AS type ON type.id=bill_data.type");
        query.append(" LEFT JOIN contract on bill_data.cid=contract.id");
        query.append(" LEFT JOIN contract AS super_contract on super_contract.id=contract.scid ");
        this.addPackageFilterJoin(packageParamId, packageId, sortMode, query);
        this.addStreetJoin(addressSortParam, sortMode, secondarySortMode, query, forRegister);
        this.addNameJoin(nameSortParam, sortMode, secondarySortMode, query);
        query.append(" WHERE (");
        String date = "(";
        if (from != null && until != null) {
            date = "(create_dt>=? AND create_dt<=?)AND(";
        } else if (from != null && until == null) {
            date = "(create_dt>=?)AND(";
        } else if (from == null && until != null) {
            date = "(create_dt<=?)AND(";
        }
        query.append(date);
        if (yy > 0 && mm >= 0) {
            query.append("yy=? AND mm=?)");
        }
        if (unloadType == 1) {
            query.append(" AND(unload_status=0)");
        } else if (unloadType == 2) {
            query.append(" AND(unload_status=1)");
        }
        if (contractTitle != null && contractTitle.length() > 0) {
            query.append(" AND(contract.title LIKE ?)");
        }
        if (billNumber != null && billNumber.length() > 0) {
            query.append(" AND(format_number LIKE ?)");
        }
        if (Utils.notEmptyString((String)type)) {
            query.append(" AND bill_data.type IN (");
            query.append(type);
            query.append(" ) ");
        }
        query.append(") ");
        if (packageId > 0 && packageParamId > 0) {
            query.append("AND(cp7.val=");
            query.append(packageId);
            query.append(" OR (cp7.val IS NULL AND cp7_super.val=");
            query.append(packageId);
            query.append("))");
        }
        this.addSortMode(addressSortParam, nameSortParam, sortMode, secondarySortMode, query);
        query.append(page.sqlLimit());
        try {
            ps = this.con.prepareStatement(query.toString(), 1);
            try {
                int iter = 1;
                if (from != null) {
                    ps.setDate(iter++, TimeUtils.convertCalendarToSqlDate((Calendar)from));
                }
                if (until != null) {
                    ps.setDate(iter++, TimeUtils.convertCalendarToSqlDate((Calendar)until));
                }
                if (yy > 0 && mm >= 0) {
                    ps.setInt(iter++, yy);
                    ps.setInt(iter++, mm);
                }
                if (contractTitle != null && contractTitle.length() > 0) {
                    ps.setString(iter++, "%" + contractTitle + "%");
                }
                if (billNumber != null && billNumber.length() > 0) {
                    ps.setString(iter++, "%" + billNumber + "%");
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    Invoice invoice = this.getInvoiceFromRS(rs, true, true);
                    if (forRegister) {
                        invoice.setAddress(rs.getString("address"));
                        invoice.setRecipient(rs.getString("contract.comment"));
                    }
                    if (getXml) {
                        invoice.setXmlData(rs.getBytes("xml"));
                    }
                    adminInvoiceList.add(invoice);
                }
                rs.close();
                ps.close();
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            ps = this.con.prepareStatement("DROP TEMPORARY TABLE IF EXISTS `cids`");
            try {
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return adminInvoiceList;
    }

    public List<Invoice> getInvoiceList(String idcids) {
        ArrayList<Invoice> result = new ArrayList<Invoice>();
        try {
            String query = "SELECT bill_data.*, contract.gr, contract.title, contract.comment, type.title FROM " + this.table + " AS bill_data LEFT JOIN contract on bill_data.cid=contract.id LEFT JOIN bill_doc_type_" + this.moduleId + " AS type ON bill_data.type=type.id WHERE bill_data.id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            String[] idm = idcids.split(";");
            for (int i = 0; i < idm.length; ++i) {
                String[] par = idm[i].split(":");
                ps.setInt(1, Utils.parseInt((String)par[0], (int)0));
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    result.add(this.getInvoiceFromRS(rs, true, true));
                }
                rs.close();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Invoice getInvoiceFromRS(ResultSet rs, boolean loadContract, boolean loadType) throws SQLException {
        Invoice result = new Invoice();
        result.setFormatNumber(rs.getString("format_number"));
        result.setUserId(rs.getInt("uid"));
        result.setNumber(rs.getInt("number"));
        result.setNumberInMonth(rs.getInt("number_in_month"));
        result.setNumberInYear(rs.getInt("number_in_year"));
        result.setTypeId(rs.getInt("type"));
        int id = rs.getInt("id");
        result.setId(id);
        result.setContractId(rs.getInt("cid"));
        if (loadContract) {
            result.setContractTitle(rs.getString("contract.title"));
            result.setContractComment(rs.getString("contract.comment"));
        }
        if (loadType) {
            result.setTypeTitle(rs.getString("type.title"));
        }
        result.setUnloadStatus(rs.getInt("unload_status"));
        result.setYy(rs.getInt("yy"));
        result.setMm(rs.getInt("mm"));
        result.setCreateDate(rs.getDate("create_dt"));
        result.setSumm(rs.getBigDecimal("summ"));
        result.setShowReady(rs.getBoolean("show_ready"));
        return result;
    }

    public List<Invoice> getInvoiceList(Page page, int cid, boolean onlyReady) {
        try {
            return InvoiceDocumentDao.getInvoiceDocumentList(this.con, this.moduleId, this.table, cid, onlyReady, page, rs -> {
                try {
                    return this.getInvoiceFromRS((ResultSet)rs, false, true);
                }
                catch (SQLException ex) {
                    throw new BGRuntimeException((Throwable)ex);
                }
            });
        }
        catch (BGRuntimeException ex) {
            Throwable t = ex;
            if (t.getCause() instanceof SQLException) {
                t = ex.getCause();
            }
            log.error(t.getMessage(), t);
        }
        catch (BGException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return new ArrayList<Invoice>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addBillDoc(int userId, BillDoc billDoc, List<PositionValue> posList, List<BillDoc> subList, boolean checkPast) {
        int yy = billDoc.getYy();
        int mm = billDoc.getMm();
        int cid = billDoc.getContractId();
        BigDecimal summ = billDoc.getSumm();
        int type = billDoc.getTypeId();
        Date date = billDoc.getCreateDate();
        int npid = billDoc.getNpid();
        if (checkPast && !BillUtil.isPast(yy, mm)) {
            return -1;
        }
        boolean showReady = this.moduleSetup.getBoolean("invoice.generate.web.visible", false);
        if (cid > 0) {
            Connection con = this.setup.getDBConnectionFromPool();
            try {
                String query = null;
                PreparedStatement addInvoicePS = null;
                Object object = addInvoiceMutex;
                synchronized (object) {
                    int[] numbers = this.getNextNumbers(con, npid, yy, mm);
                    query = "INSERT INTO " + this.table + " (cid, type,  number, number_in_month, number_in_year, format_number, uid, yy, mm, create_dt, unload_status, summ, xml, show_ready, npid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    addInvoicePS = con.prepareStatement(query, 1);
                    String formatNumber = NumerationPoolManager.formatNumber(npid, yy, mm, numbers[0], numbers[1], numbers[2], con, this.moduleId, cid);
                    billDoc.setFormatNumber(formatNumber);
                    int pos = 1;
                    addInvoicePS.setInt(pos++, cid);
                    addInvoicePS.setInt(pos++, type);
                    addInvoicePS.setInt(pos++, numbers[0]);
                    addInvoicePS.setInt(pos++, numbers[1]);
                    addInvoicePS.setInt(pos++, numbers[2]);
                    addInvoicePS.setString(pos++, formatNumber);
                    addInvoicePS.setInt(pos++, userId);
                    addInvoicePS.setInt(pos++, yy);
                    addInvoicePS.setInt(pos++, mm);
                    addInvoicePS.setDate(pos++, TimeUtils.convertDateToSqlDate((Date)date));
                    addInvoicePS.setInt(pos++, 0);
                    addInvoicePS.setBigDecimal(pos++, summ);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    this.serializeInvoiceToXML(con, byteArrayOutputStream, (Invoice)billDoc, posList, subList);
                    addInvoicePS.setBytes(pos++, byteArrayOutputStream.toByteArray());
                    addInvoicePS.setInt(pos++, showReady ? 1 : 0);
                    addInvoicePS.setInt(pos++, npid);
                    addInvoicePS.executeUpdate();
                    addInvoicePS.close();
                }
                int id = ServerUtils.lastInsertId((Connection)con);
                billDoc.setId(id);
                int n = id;
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
            }
        }
        return -1;
    }

    private void serializeInvoiceToXML(Connection con, ByteArrayOutputStream bos, Invoice invoiceDoc, List<PositionValue> posList, List<BillDoc> subList) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter doc = factory.createXMLStreamWriter(bos, "UTF-8");
        doc.writeStartDocument("UTF-8", "1.0");
        doc.writeStartElement("data");
        doc.writeStartElement("bill");
        try {
            Contract contract = this.contractManager.getContractById(invoiceDoc.getContractId());
            if (contract != null) {
                int mm2 = invoiceDoc.getMm();
                int yy2 = invoiceDoc.getYy();
                if (--mm2 < 0) {
                    mm2 = 11;
                    --yy2;
                }
                Object cids = String.valueOf(invoiceDoc.getContractId());
                if (contract.getSuperId() == -1 && Utils.notBlankString((String)contract.getDependSubList())) {
                    cids = (String)cids + "," + contract.getDependSubList();
                }
                GregorianCalendar month = new GregorianCalendar(invoiceDoc.getYy(), invoiceDoc.getMm(), 1);
                GregorianCalendar monthPrev = new GregorianCalendar(yy2, mm2, 1);
                doc.writeAttribute("saldo", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getDebt(month, invoiceDoc.getContractId(), con).negate()));
                doc.writeAttribute("saldo_prev", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getDebt(monthPrev, invoiceDoc.getContractId(), con).negate()));
                BigDecimal[] sumRef = new BigDecimal[2];
                BillUtil.getServiceAccount(month, (String)cids, null, con, sumRef);
                doc.writeAttribute("amounts", Utils.formatBigDecimalSumm((BigDecimal)sumRef[1]));
                doc.writeAttribute("payments", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getPayment(month, (String)cids, null, con)));
                doc.writeAttribute("charges", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getCharge(month, (String)cids, null, con)));
                this.addBillDocData(con, invoiceDoc, posList, subList, doc, contract);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        doc.writeEndElement();
        doc.writeEndElement();
        doc.writeEndDocument();
        doc.flush();
    }

    public void setShowReady(String ids, boolean ready) {
        try {
            Statement st = this.con.createStatement();
            st.executeUpdate("UPDATE " + this.table + " SET show_ready=" + (ready ? 1 : 0) + " WHERE id IN ( " + ids + " )");
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDocTypeId(List<Integer> documentIds, int documentTypeId) throws BGException {
        if (documentIds != null && !documentIds.isEmpty()) {
            try {
                PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.table + " SET type=? WHERE id=?");
                ps.setInt(1, documentTypeId);
                for (int documentId : documentIds) {
                    ps.setInt(2, documentId);
                    ps.executeUpdate();
                }
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    @Override
    protected BillDoc getBillDoc(Attributes attributes) {
        Invoice invoice = new Invoice();
        this.setOrganization(invoice, Utils.parseInt((String)attributes.getValue("organization_id"), (int)0));
        return invoice;
    }

    @Override
    protected BillDoc getBillDoc(XMLUtils.BGXMLEventReader reader, StartElement element) {
        Invoice invoice = new Invoice();
        this.setOrganization(invoice, Utils.parseInt((String)reader.getAttributeValue(element, "organization_id"), (int)0));
        return invoice;
    }

    @Override
    protected void publishEvent(int userID, BillDoc billDoc, int billId) throws BGException {
        EventProcessor.getInstance().publish((Event)new InvoiceCreatedEvent(userID, this.moduleId, billDoc.getContractId(), billId));
    }
}

