/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.task;

import bitel.billing.server.util.MailMsg;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.EmailMaster;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.modules.bill.server.mail.MailDocsSenderForAll;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;

public class BillDocsSenderForAll
extends RunTask {
    private int moduleId = -1;
    private List<Integer> billCodes;
    private List<Integer> invoiceCodes;
    private Map<Integer, List<Integer>> billMap;
    private Map<Integer, List<Integer>> invoiceMap;
    private int userId = -1;

    public BillDocsSenderForAll(int moduleId, List<Integer> billIds, List<Integer> invoiceIds, int userId) {
        this.moduleId = moduleId;
        this.billCodes = billIds;
        this.invoiceCodes = invoiceIds;
        this.userId = userId;
    }

    public String getDescription() {
        return "\u041c\u043e\u0434\u0443\u043b\u044c Bill. \u0417\u0430\u0434\u0430\u0447\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0441 \u043a\u043e\u043c\u043f\u043e\u043d\u043e\u0432\u043a\u043e\u0439. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try (BillManager billManager = new BillManager(con, this.moduleId);
             InvoiceManager invoiceManager = new InvoiceManager(con, this.moduleId);){
            this.billMap = this.sortDocByContract(billManager, this.billCodes);
            this.invoiceMap = this.sortDocByContract(invoiceManager, this.invoiceCodes);
            ArrayList<Integer> sendCids = new ArrayList<Integer>();
            for (int contractId : this.billMap.keySet()) {
                this.sendMessage(con, contractId, this.billMap.get(contractId), this.invoiceMap.get(contractId));
                sendCids.add(contractId);
            }
            for (int contractId : this.invoiceMap.keySet()) {
                if (sendCids.contains(contractId)) continue;
                this.sendMessage(con, contractId, this.billMap.get(contractId), this.invoiceMap.get(contractId));
            }
        }
        catch (Exception ex) {
            this.log.error("error bill docs sender for all task", (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private void sendMessage(Connection con, int contactId, List<Integer> bills, List<Integer> invoices) {
        try (EmailMaster emailMaster = new EmailMaster(this.setup, con, this.moduleId, this.userId);){
            this.log.debug("send message for contract #{}", (Object)contactId);
            emailMaster.setContractId(contactId);
            MailData mailData = new MailDocsSenderForAll().setModuleId(this.moduleId).setContractId(contactId).setRecipients(emailMaster.getEmail()).setSubject(emailMaster.getSubject());
            emailMaster.addMessage(mailData, "text");
            int index = 1;
            if (bills != null) {
                for (Integer id : bills) {
                    emailMaster.setDocumentId("bill", id);
                    emailMaster.addAttach(mailData, "file" + index++);
                }
            }
            if (invoices != null) {
                for (Integer id : invoices) {
                    emailMaster.setDocumentId("invoice", id);
                    emailMaster.addAttach(mailData, "file" + index++);
                }
            }
            new MailMsg((Preferences)this.setup).sendMessage(mailData);
        }
        catch (Exception e) {
            this.log.error("send for contract #" + contactId + " error: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Map<Integer, List<Integer>> sortDocByContract(AbstractManager manager, List<Integer> docIds) {
        HashMap<Integer, List<Integer>> res = new HashMap<Integer, List<Integer>>();
        if (docIds == null || docIds.isEmpty()) {
            return res;
        }
        for (int docId : docIds) {
            try {
                BillDoc docInfo = manager.getBillDocInfo(docId);
                if (docInfo != null) {
                    int contractId = docInfo.getContractId();
                    if (contractId > 0) {
                        ArrayList<Integer> list = (ArrayList<Integer>)res.get(contractId);
                        if (list == null) {
                            list = new ArrayList<Integer>();
                            res.put(contractId, list);
                        }
                        list.add(docId);
                        continue;
                    }
                    this.log.error("!!! contractId<1 !!! docId={}, docInfo={}", (Object)docId, (Object)docInfo);
                    continue;
                }
                this.log.error("sortDocByContract: docInfo=null for docId=" + docId);
            }
            catch (Exception ex) {
                this.log.error("docId={} [{}]", (Object)docId, (Object)ex.getMessage());
            }
        }
        return res;
    }
}

