<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<ul class="nav nav-tabs px-4">
	<li class="nav-item"><a class="nav-link active" href="#">Счета</a></li>
	<li class="nav-item"><a class="nav-link" href="#" onClick="showBlock( 'billRoot', 'list', invoiceQuery );">Акты, УПД</a></li>
</ul>
<div id="billListRoot">
<c:if test="${not empty billList}">
<div class="tile tileTabs">
<div class="buttons">
	<div><img title="Новый счет" src="${contextPath}/img/plus.png" height="32" class="cursorPointer" onclick="showBlock( 'billListRoot', 'addBill', billQuery ); return false;"/></div>
	<div><label for="billFilterCheckbox"><img title="Добавить фильтр" src="${contextPath}/img/default/filter.png" height="32"/></label></div>
</div>
<c:choose>
	<c:when test="${not empty billList}">
		<c:forEach var="item" varStatus="status" items="${billList}">
			<fmt:parseDate var="period" pattern="dd/MM/yyyy" value="01/${item.mm+1}/${item.yy}" />
			<div class="flexRow bill">
				<div class="mt-2" style="display: flex; flex-direction: column;">
					<div class="titleFont2 sf-2 px-2" style="margin-bottom: 10px;">Счет № ${item.formatNumber} <span>от <fmt:formatDate type="DATE" dateStyle="SHORT" value="${item.createDate}"/></span></div>
					<div style="margin: 0px 20px; overflow: auto;">
						<div class="paramFont paramColor billParam" style="width: 12em; float: left;">Период: <span><fmt:formatDate  type="DATE" pattern="LLLL yyyy" value="${period}"/></span></div>
						<div class="paramFont paramColor billParam" style="width: 14em; float: left;">Дата оплаты: <span><c:choose><c:when test="${not empty item.payDate}"><fmt:formatDate type="DATE" dateStyle="SHORT" value="${item.payDate}"/></c:when><c:otherwise>не оплачен</c:otherwise></c:choose></span></div>
						<div class="paramFont paramColor billParam" style="width: auto; float: left;">Счет выписал: <span><c:choose><c:when test="${item.uid == -1}">клиент</c:when><c:otherwise>администратор</c:otherwise></c:choose></span></div>
						<div class="paramFont paramColor billParam" style="width: 100%; clear: left; padding-top: 5px; box-sizing: border-box;">Тип счета: <span>${item.typeTitle}</span></div>
					</div>
				</div>
				<div class="mt-2" style="display: flex; flex-direction: column; width: 10rem;">
					<div class="titleFont3 text-nowrap text-end"><fmt:formatNumber pattern="###,###,###,##0.00" value="${item.summ}"/><span class="CUR"/></div>
					<div class="text-end"><button class="btn btn-primary" onClick="window.location='pdfexecuter?mid=${mid}&id=${item.id}'">скачать</button></div>
				</div>
			</div>
			<c:if test="${not status.last}"><div class="line"></div></c:if>
		</c:forEach>
	</c:when>
	<c:otherwise><div class="alert alert-primary mt-3" role="alert">Счета не найдены</div></c:otherwise>
</c:choose>
</div>
</c:if>
</div>
	
	<c:if test="${not empty billList}">		
	<tbody>
		<tr>
			<c:choose>
				<c:when test="${item.uid == -1 and item.status == 0 }">
				<td>
					<form method='get' action='' style="display: inline;" onsubmit="return confirm('Удалить счёт?');">
						<input type="hidden" name="module" value="${module}" />
						<input type="hidden" name="mid" value="${mid}" />
						<input type="hidden" name="action" value="DelBill" />
						<input type="hidden" name="id" value="${item.id}"/>
						<input type="submit" name="" value="Удалить" />
					</form>								
				</td>
				</c:when>
				<c:otherwise><td>&#x0A;</td></c:otherwise>
			</c:choose>
		</tr>		
	</tbody>
	</c:if>
