/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.client.sync;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.City;
import ru.bitel.bgbilling.plugins.fias.common.service.FiasSyncService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Result;

public class CitySyncPanel
extends BGUPanel {
    private BGTableModel<City> model = new BGTableModel<City>("city"){

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", 70, 70, 70, "id", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0435", "bgTitle", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0424\u0418\u0410\u0421", "fiasTitle", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("AOGUID", "aoguid", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("CODE", "code", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("SHORTNAME", "shortname", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("OFFNAME", "offname", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("LEVEL", "level", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("POSTALCODE", "postalcode", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("REGION", "region", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("REGION_TITLE", "parentTitle", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }
    };

    public CitySyncPanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void jbInit() throws Exception {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        BGButton syncButton = new BGButton("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441 \u0424\u0418\u0410\u0421");
        syncButton.addActionListener(e -> this.syncCity());
        buttonPanel.add((Component)syncButton);
        BGButton titleButton = new BGButton("\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0435");
        titleButton.addActionListener(e -> this.changeTitleInBilling());
        buttonPanel.add((Component)titleButton);
        BGUTable table = new BGUTable(this.model);
        this.setLayout(new GridBagLayout());
        this.add(buttonPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                Result result = ((FiasSyncService)((ClientContext)CitySyncPanel.this.getContext()).getPort(FiasSyncService.class)).getCityList();
                CitySyncPanel.this.model.setData(result.getList());
            }
        };
    }

    private void syncCity() {
        try {
            ((FiasSyncService)((ClientContext)this.getContext()).getPort(FiasSyncService.class)).syncCity(this.model.getSelectedRows());
            this.performAction("refresh");
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void changeTitleInBilling() {
        try {
            String name = JOptionPane.showInputDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u0432\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", (Object)((City)this.model.getSelectedRow()).getFiasTitle());
            if (!Utils.isEmptyString((String)name)) {
                ((FiasSyncService)((ClientContext)this.getContext()).getPort(FiasSyncService.class)).changeBillingCityName(((City)this.model.getSelectedRow()).getId(), name);
            }
            this.performAction("refresh");
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443\n" + ex.getLocalizedMessage()));
            ex.printStackTrace();
        }
    }
}

