/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterExecutor;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterTask;
import ru.bitel.bgbilling.plugins.crm.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterExecutorManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterTaskManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.directories.address.server.bean.QuarterDao;
import ru.bitel.oss.kernel.directories.address.server.bean.StreetDao;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;

public class ActionPrintRegisterTaskOrder
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        if (id < 0) {
            throw new BGIllegalArgumentException();
        }
        Object name = "";
        String addressQuarter = "-";
        String street = "-";
        Object addressHouse = "-";
        String addressFlat = "-";
        String addressRoom = "-";
        StringBuffer phone = new StringBuffer();
        RegisterTask task = new RegisterTaskManager(this.con).getTaskById(id);
        if (task != null) {
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                EntityAttrAddress entityAttrAddress;
                for (Integer pid : Utils.toIntegerList((String)this.plugin.getSetup().get("contract.fio.param.id", ""))) {
                    String paramValue = contractDao.getContractParameterTextAsString(task.getContractId(), pid.intValue()).orElse("");
                    name = (String)name + (String)(((String)name).isEmpty() ? paramValue : (paramValue.isEmpty() ? "" : " " + paramValue));
                }
                for (String paramId : this.plugin.getSetup().get("contract.phone.param.id", "").split(",")) {
                    String value;
                    if (paramId.startsWith("phone:")) {
                        Optional attrPhone = contractDao.getContractParameterPhone(task.getContractId(), Utils.parseInt((String)paramId.substring(6)));
                        if (!attrPhone.isPresent() || ((EntityAttrPhone)attrPhone.get()).toString().isEmpty()) continue;
                        if (phone.length() > 0) {
                            phone.append("; ");
                        }
                        phone.append(((EntityAttrPhone)attrPhone.get()).toString());
                        continue;
                    }
                    int textParamId = Utils.parseInt((String)paramId);
                    if (paramId.startsWith("text:")) {
                        textParamId = Utils.parseInt((String)paramId.substring(5));
                    }
                    if ((value = (String)contractDao.getContractParameterTextAsString(task.getContractId(), textParamId).orElse(null)) == null || value.isEmpty()) continue;
                    if (phone.length() > 0) {
                        phone.append("; ");
                    }
                    phone.append(value);
                }
                int addressParamId = Utils.parseInt((String)this.plugin.getSetup().get("contract.address.param.id", "0"));
                if (addressParamId > 0 && (entityAttrAddress = (EntityAttrAddress)contractDao.getContractParameterAddress(task.getContractId(), addressParamId).orElse(null)) != null) {
                    try (QuarterDao quarterDao = new QuarterDao(this.con);
                         StreetDao streetDao = new StreetDao(this.con);
                         HouseDao houseDao = new HouseDao(this.con);){
                        House house = houseDao.get(entityAttrAddress.getHouseId());
                        addressHouse = house.getHouse() + house.getFrac();
                        street = ((Street)streetDao.get(house.getStreetId())).getTitle();
                        Quarter quarter = (Quarter)quarterDao.get(house.getQuarterId());
                        if (quarter != null) {
                            addressQuarter = quarter.getTitle();
                        }
                        addressFlat = entityAttrAddress.getFlat();
                        addressRoom = entityAttrAddress.getRoom();
                    }
                }
                if (this.plugin.getSetup().getBoolean("order.print.add.contract.params", false)) {
                    new ContractUtils(this.con).addContractParameters(task.getContractId(), true, this.createElement(this.rootNode, "parameters"), this.rootNode);
                }
            }
        }
        this.rootNode.setAttribute("xslt", this.plugin.getSetup().get("register.print.task.order." + task.getTypeId() + ".xslt", "crm_register_print_task_order.xsl"));
        this.rootNode.setAttribute("orderDate", TimeUtils.formatDate((Date)new Date()));
        Element taskElement = this.createElement(this.rootNode, "task");
        taskElement.setAttribute("id", String.valueOf(id));
        taskElement.setAttribute("typeId", String.valueOf(task.getTypeId()));
        taskElement.setAttribute("name", (String)name);
        taskElement.setAttribute("phone", phone.toString());
        taskElement.setAttribute("addressFlat", addressFlat);
        taskElement.setAttribute("addressRoom", addressRoom);
        taskElement.setAttribute("addressHouse", (String)addressHouse);
        taskElement.setAttribute("addressStreet", street);
        taskElement.setAttribute("addressQuarter", addressQuarter);
        taskElement.setAttribute("comment", task.getComment());
        taskElement.setAttribute("resolution", task.getResolution());
        taskElement.setAttribute("targetDate", TimeUtils.format((Date)task.getTargetDate(), (String)"dd.MM.yyyy HH:mm"));
        taskElement.setAttribute("executors", this.getExecutors(task.getExecutors()));
        taskElement.setAttribute("createDate", TimeUtils.format((Date)task.getCreateTime(), (String)"dd.MM.yyyy"));
        taskElement.setAttribute("openDate", TimeUtils.format((Date)task.getOpenTime(), (String)"dd.MM.yyyy"));
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            Contract contract = (Contract)contractDao.get(task.getContractId());
            if (contract != null) {
                taskElement.setAttribute("contractTitle", contract.getTitle());
                taskElement.setAttribute("contractDateFrom", TimeUtils.formatDate((Date)contract.getDateFrom()));
            }
        }
    }

    private String getExecutors(List<Integer> l) {
        RegisterExecutorManager rem = new RegisterExecutorManager(this.con);
        Object result = "";
        try {
            List<RegisterExecutor> list = rem.getRegisterExecutorList((List<Integer>)null, l);
            for (int i = 0; i < list.size(); ++i) {
                RegisterExecutor re = list.get(i);
                result = i + 1 == list.size() ? (String)result + re.getTitle() : (String)result + re.getTitle() + "; ";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

