/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class RegisterCallManager {
    private static final Logger log = LogManager.getLogger();
    private Connection con;

    public RegisterCallManager(Connection con) {
        this.con = con;
    }

    public List<RegisterCall> getProblemCallList(int problemID) {
        ArrayList<RegisterCall> result = new ArrayList<RegisterCall>();
        try {
            String query = "SELECT * FROM register_call WHERE rpid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, problemID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RegisterCall call = new RegisterCall();
                this.setRegisterCallData(call, rs, "", "", "", "");
                result.add(call);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public RegisterCall getCallById(int id) {
        RegisterCall result = null;
        try {
            String query = "SELECT rcall.*, contract.title, object.title FROM register_call AS rcall LEFT JOIN contract ON rcall.cid=contract.id LEFT JOIN object ON rcall.oid=object.id WHERE rcall.id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new RegisterCall();
                this.setRegisterCallData(result, rs, "rcall.", "", "contract.", "object.");
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public RegisterCall getCallByID(int id) {
        return this.getCallById(id);
    }

    public void searchList(SearchResult<RegisterCall> searchResult) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List result = searchResult.getList();
            try {
                StringBuffer query = new StringBuffer(500);
                query.append("SELECT SQL_CALC_FOUND_ROWS rcall.*, subject.title, contract.title, object.title");
                query.append(" FROM register_call AS rcall ");
                query.append(" LEFT JOIN register_subject AS subject ON rcall.sid=subject.id ");
                query.append(" LEFT JOIN contract ON rcall.cid=contract.id ");
                query.append(" LEFT JOIN object ON rcall.oid=object.id ");
                this.addWhereString(Utils.parseInt((String)searchResult.getAttribute("cid")), period.getDateFrom(), period.getDateTo(), Utils.parseInt((String)searchResult.getAttribute("subject")), query);
                query.append(" ORDER BY rcall.time");
                if (page != null) {
                    query.append(page.sqlLimit());
                }
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    RegisterCall call = new RegisterCall();
                    this.setRegisterCallData(call, rs, "rcall.", "subject.", "contract.", "object.");
                    result.add(call);
                }
                rs.close();
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Map<Integer, List<RegisterCall>> getProblemCallList(List<Integer> problemIds) {
        HashMap<Integer, List<RegisterCall>> result = new HashMap<Integer, List<RegisterCall>>();
        if (problemIds != null) {
            StringBuilder ids = new StringBuilder();
            for (Integer problemId : problemIds) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(problemId);
            }
            if (ids.length() > 0) {
                try {
                    String query = "SELECT *, contract.title FROM register_call LEFT JOIN contract ON cid=contract.id WHERE rpid IN ( " + ids.toString() + " )";
                    PreparedStatement ps = this.con.prepareStatement(query);
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        RegisterCall call = new RegisterCall();
                        this.setRegisterCallData(call, rs, "", "", "contract.", "");
                        Integer problemId = rs.getInt("rpid");
                        ArrayList<RegisterCall> list = (ArrayList<RegisterCall>)result.get(problemId);
                        if (list == null) {
                            list = new ArrayList<RegisterCall>();
                            result.put(problemId, list);
                        }
                        list.add(call);
                    }
                    rs.close();
                    ps.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return result;
    }

    private void addWhereString(int contractId, Date date1, Date date2, int subject, StringBuffer query) {
        query.append(" WHERE ( ");
        query.append(contractId);
        query.append("<=0 OR rcall.cid=");
        query.append(contractId);
        query.append(" )");
        if (date1 != null) {
            query.append(" AND ");
            query.append("time>='");
            query.append(TimeUtils.format((Date)date1, (String)"yyyy-MM-dd"));
            query.append("'");
        }
        if (date2 != null) {
            query.append(" AND ");
            query.append("time<=DATE_ADD('");
            query.append(TimeUtils.format((Date)date2, (String)"yyyy-MM-dd"));
            query.append("', INTERVAL 1 DAY )");
        }
        if (subject > 0) {
            query.append(" AND sid=");
            query.append(subject);
        }
    }

    @Deprecated
    public void updateCall(String id, RegisterCall call) {
        call.setId(Utils.parseInt((String)id));
        this.updateCall(call);
    }

    public void updateCall(RegisterCall call) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (call.getId() == 0) {
                query = "INSERT INTO register_call (cid, oid, sid, gid, rpid, time, uid, comment ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ? ) ";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE register_call SET cid=?, oid=?, sid=?, gid=?, rpid=?, time=?, uid=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(9, call.getId());
            }
            ps.setInt(1, call.getContractId());
            ps.setInt(2, call.getObjectId());
            ps.setInt(3, call.getTypeId());
            ps.setInt(4, call.getGroupId());
            ps.setInt(5, call.getProblemId());
            ps.setTimestamp(6, TimeUtils.convertDateToTimestamp((Date)call.getTime()));
            ps.setInt(7, call.getUserId());
            ps.setString(8, call.getComment());
            ps.executeUpdate();
            if (call.getId() == 0) {
                call.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteCallsByContractId(int contractId) {
        if (log.isDebugEnabled()) {
            log.debug("DELETE FROM register_call WHERE cid=" + contractId);
        }
        String query = "DELETE FROM register_call WHERE cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setRegisterCallData(RegisterCall call, ResultSet rs, String tableCall, String tableSubject, String tableContract, String tableObject) throws SQLException {
        RegisterCall.builder((RegisterCall)call).setId(rs.getInt(tableCall + "id")).setContractId(rs.getInt(tableCall + "cid")).setObjectId(rs.getInt(tableCall + "oid")).setTypeId(rs.getInt(tableCall + "sid")).setGroupId(rs.getInt(tableCall + "gid")).setTime((Date)rs.getTimestamp(tableCall + "time")).setProblemId(rs.getInt(tableCall + "rpid")).setComment(rs.getString(tableCall + "comment")).setUserId(rs.getInt(tableCall + "uid"));
        if (Utils.notEmptyString((String)tableSubject)) {
            call.setTypeTitle(rs.getString(tableSubject + "title"));
        }
        if (Utils.notEmptyString((String)tableContract)) {
            call.setContractTitle(rs.getString(tableContract + "title"));
        }
        if (Utils.notEmptyString((String)tableObject)) {
            call.setObjectTitle(rs.getString(tableObject + "title"));
        }
    }
}

