/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.Utils;

public final class DocumentPatternUtils {
    private static final Logger logger = LogManager.getLogger();
    private static final String VARIABLE_KEY_PATTERN = "\\{[^}]*\\}|\\{[^(]*\\([^)]*\\)\\}";

    public static String insertPatternPart(String srcString, String key, String value) {
        if (Utils.isBlankString((String)key)) {
            return srcString;
        }
        StringBuilder result = new StringBuilder();
        Pattern p = Pattern.compile("(.*)\\$\\{" + key + "\\}(.*)");
        Matcher m = p.matcher(srcString);
        if (m.find()) {
            String prefix = m.group(1);
            result.append(prefix);
            result.append(Utils.maskNull((String)value));
            result.append(m.group(2));
        } else {
            result.append(srcString);
        }
        return result.toString();
    }

    public static List<String> getKeysFromString(String text) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern varPattern = Pattern.compile(VARIABLE_KEY_PATTERN);
        Matcher m = varPattern.matcher(text);
        while (m.find()) {
            String key = m.group();
            key = key.replaceAll("\\{", "");
            if ((key = key.replaceAll("\\}", "")).contains("(") && key.contains(")")) {
                int index = key.indexOf("(");
                key = key.substring(0, index);
            }
            result.add(key);
        }
        return result;
    }

    public static String replaceText(String source, String varName, String val) {
        Pattern pattern = Pattern.compile("(.*)(\\{" + varName + "\\}|\\{" + varName + "\\([^)]*\\)\\})(.*)");
        Matcher matcher = pattern.matcher(source);
        if (matcher.matches()) {
            String foundString = matcher.group(2);
            String defaultValue = "";
            if (foundString.contains("(") && foundString.contains(")")) {
                int beginIndex = foundString.indexOf("(");
                int endIndex = foundString.indexOf(")");
                defaultValue = foundString.substring(beginIndex + 1, endIndex);
            }
            String value = Utils.maskBlank((String)(Utils.notBlankString((String)val) ? val : defaultValue), (String)"");
            logger.debug("\t\t\u0417\u0430\u043c\u0435\u043d\u0430 \u0432 \u043f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0435 '{}' \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 {} \u043d\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 {}", (Object)source, (Object)varName, (Object)value);
            source = source.replaceAll("\\{" + varName + "\\}|\\{" + varName + "\\([^)]*\\)\\}", value);
        }
        return source;
    }
}

