/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.client;

import bitel.billing.module.common.BGComboBoxFixed;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.cashcheck.client.PaymentAdvanceDialog;
import ru.bitel.bgbilling.plugins.cashcheck.common.CashcheckService;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.common.PrintCheckData;
import ru.bitel.common.DateTimeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Result;

public class ManagerQueue
extends BGUPanel {
    private BGUComboBox<IdTitle> registratorCB = new BGUComboBox();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGComboBoxFixed checkType = new BGComboBoxFixed();
    private BGUTable table;
    private BGTableModel<Payment> model;
    private JLabel countLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: 0");
    private JLabel fiscalStartLabel = new JLabel("(\u0412 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u0437\u0430 \u0432\u0441\u0451 \u0432\u0440\u0435\u043c\u044f)");
    private JButton doPrint = new JButton("\u041f\u0435\u0447\u0430\u0442\u044c \u0447\u0435\u043a\u0430 (manual)");
    private JButton doPrintAuto = new JButton("\u041f\u0435\u0447\u0430\u0442\u044c \u0447\u0435\u043a\u0430 (auto)");
    private JButton doPrintCharge = new JButton("\u041f\u0435\u0447\u0430\u0442\u044c \u0447\u0435\u043a\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 (manual)");
    private JButton doPrintAdvance = new JButton("\u041f\u0435\u0447\u0430\u0442\u044c \u0437\u0430\u0447\u0451\u0442\u043e\u0432 \u0430\u0432\u0430\u043d\u0441\u043e\u0432");

    public ManagerQueue(ClientContext ctx) {
        super(ctx);
    }

    protected void jbInit() throws Exception {
        this.model = new BGTableModel<Payment>("Payment"){

            protected void initColumns() {
                this.addColumn("\u041a\u043e\u0434", 100, 100, 100, "paymentId", false, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
                this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 200, 400, -1, "contractTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430/\u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430", 100, 150, -1, "paymentTypesTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0414\u0430\u0442\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430/\u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430", 100, 110, 120, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u043f\u043b\u0430\u0442\u0435\u0436\u0430/\u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430", 100, 150, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0421\u0443\u043c\u043c\u0430", 100, 100, 100, "summa", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
                this.addColumn("cid", Integer.class, 0, 0, 0, "contractId", false);
                this.addColumn("\u041c\u0430\u043f\u043f\u0438\u043d\u0433", 100, 150, 200, "printMode", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            }

            public Object getValue(Payment val, int column) throws BGException {
                if (column == 1) {
                    return val.getContractTitle() != null ? val.getContractTitle() + " [ " + val.getContractComment() + " ]" : "-";
                }
                if (column == 3) {
                    return TimeUtils.format((Date)val.getDate(), (String)"dd.MM.yyyy");
                }
                if (column == 5) {
                    return String.valueOf(val.getSumma());
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table = new BGUTable(this.model);
        this.checkType.addItem((Object)0, "\u041f\u043b\u0430\u0442\u0435\u0436\u0438");
        this.checkType.addItem((Object)1, "\u0412\u043e\u0437\u0432\u0440\u0430\u0442\u044b");
        this.doPrintCharge.setVisible(false);
        JButton doFilter = new JButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)this.registratorCB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)this.periodPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)this.checkType, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)doFilter, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)this.countLabel, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 15, 0, 0), 0, 0));
        JPanel filterPanel2 = new JPanel(new GridBagLayout());
        filterPanel2.add((Component)this.pagePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 5, 5), 0, 0));
        filterPanel2.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 15, 0, 0), 0, 0));
        filterPanel2.add((Component)this.fiscalStartLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 15), 0, 0));
        filterPanel2.add((Component)this.doPrint, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel2.add((Component)this.doPrintCharge, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel2.add((Component)this.doPrintAuto, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel2.add((Component)this.doPrintAdvance, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(filterPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        doFilter.addActionListener(e -> {
            this.pagePanel.init();
            this.performAction("refresh");
        });
        this.doPrint.addActionListener(e -> this.performAction("printCheck"));
        this.doPrintAuto.addActionListener(e -> this.performAction("printCheckAuto"));
        this.doPrintCharge.addActionListener(e -> this.performAction("printCheckCharge"));
        this.doPrintAdvance.addActionListener(e -> this.performAction("printAdvance"));
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName != null && propertyName.startsWith("to")) {
                    ManagerQueue.this.performAction("refresh");
                }
            }
        });
        ClientUtils.addOpenAction((Component)this.table, event -> this.gotoContract());
        this.periodPanel.setDateCalendar1(TimeUtils.getPrevDay((Calendar)new GregorianCalendar()));
        this.pagePanel.setKey(((Object)((Object)this)).getClass().getName());
        this.initList();
        ActionListener doPrintDisable = e -> {
            this.doPrint.setEnabled(false);
            this.doPrintAuto.setEnabled(false);
            this.doPrintCharge.setEnabled(false);
        };
        this.registratorCB.addActionListener(doPrintDisable);
        this.checkType.addActionListener(doPrintDisable);
        this.periodPanel.addPropertyChangeListener(e -> {
            if (e.getPropertyName().startsWith("date")) {
                doPrintDisable.actionPerformed(null);
            }
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            Result result = ((CashcheckService)((ClientContext)this.getContext()).getPort(CashcheckService.class)).queueTable(this.periodPanel.getPeriod(), this.pagePanel.getPage(), ((IdTitle)this.registratorCB.getSelectedItem()).getId(), ((Integer)this.checkType.getSelectedIdObj()).intValue());
            this.model.setData(result.getList());
            this.pagePanel.setPage(result.getPage());
            this.countLabel.setText("\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: " + result.getPage().getRecordCount());
            String registratorBindedName = (String)result.getAttribute("registratorBindedName");
            this.setRegistratorBindedName(registratorBindedName);
            LocalDate fiscalStart = (LocalDate)result.getAttribute("fiscalStart");
            if (fiscalStart != null) {
                this.fiscalStartLabel.setText(String.format("(\u0424\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0441 %s)", DateTimeUtils.format((LocalDate)fiscalStart, (String)"dd.MM.yyyy")));
            }
            boolean isCheckPayment = (Integer)this.checkType.getSelectedIdObj() == 0;
            this.doPrint.setEnabled(isCheckPayment);
            this.doPrint.setVisible(isCheckPayment);
            this.doPrintAuto.setEnabled(isCheckPayment);
            this.doPrintCharge.setEnabled(!isCheckPayment);
            this.doPrintCharge.setVisible(!isCheckPayment);
        });
        new AbstractBGUPanel.DefaultAction("printCheck", "\u041f\u0435\u0447\u0430\u0442\u044c \u0447\u0435\u043a\u0430"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                List payments = ManagerQueue.this.model.getSelectedRows();
                if (payments == null || payments.isEmpty()) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043d\u0438 \u043e\u0434\u0438\u043d \u043f\u043b\u0430\u0442\u0451\u0436! \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u043d\u0443 \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u0440\u043e\u043a (\u0441 \u043c\u0430\u043f\u043f\u0438\u043d\u0433\u043e\u043c manual)!");
                    return;
                }
                int currSelectPrinterId = ((IdTitle)ManagerQueue.this.registratorCB.getSelectedItem()).getId();
                if (currSelectPrinterId > 0) {
                    ClientUtils.showErrorMessageDialog((String)"\u0420\u0443\u0447\u043d\u044b\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \"\u0422\u0435\u043a\u0443\u0449\u0435\u0433\u043e\" \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                    return;
                }
                StringBuffer sb = new StringBuffer(1024);
                int colnum = 1;
                BigDecimal summaTotal = BigDecimal.ZERO;
                for (Payment row : payments) {
                    sb.append(colnum++).append(") ");
                    sb.append(row.getPaymentTypesTitle()).append(" | ");
                    sb.append(row.getSumma()).append(" | ");
                    sb.append(row.getContractTitle()).append(" | ");
                    sb.append(row.getComment()).append("\n");
                    summaTotal = summaTotal.add(row.getSumma());
                }
                BigDecimal fsumma = ManagerQueue.getClientSumma(sb.toString(), summaTotal);
                if (fsumma != null) {
                    PrintCheckData pc = ((CashcheckService)((ClientContext)ManagerQueue.this.getContext()).getPort(CashcheckService.class)).printCheck(ManagerQueue.newPaymentIdList(payments), fsumma);
                    String submitRet = pc.submit;
                    String summaRet = pc.summa;
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d \u0447\u0435\u043a \u043d\u0430 \u0441\u0443\u043c\u043c\u0443: " + summaRet + "\n\n\u0421\u0434\u0430\u0447\u0430: " + submitRet);
                    ManagerQueue.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("printCheckAuto", "\u041f\u0435\u0447\u0430\u0442\u044c \u0447\u0435\u043a\u0430"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                List payments = ManagerQueue.this.model.getSelectedRows();
                if (payments == null || payments.isEmpty()) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043d\u0438 \u043e\u0434\u0438\u043d \u043f\u043b\u0430\u0442\u0451\u0436! \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u043d\u0443 \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u0440\u043e\u043a (\u0441 \u043c\u0430\u043f\u043f\u0438\u043d\u0433\u043e\u043c auto)!");
                    return;
                }
                if (ClientUtils.confirm((String)("\u0411\u0443\u0434\u0443\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e (" + payments.size() + ") \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b \u043a\u0430\u043a auto.\n\u0412 \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u043e\u043c \u0440\u0435\u0436\u0438\u043c\u0435 \u0440\u0430\u0431\u043e\u0442\u044b \u0442\u0430\u043a\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0442\u0443\u0442 \u0441\u043a\u0430\u043f\u043b\u0438\u0432\u0430\u0442\u044c\u0441\u044f, \u0430 \u0434\u043e\u043b\u0436\u043d\u044b \u043f\u043e\u043f\u0430\u0434\u0430\u0442\u044c \u0432 \u043b\u043e\u0433 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438.\n\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0432 \u0444\u0438\u043b\u044c\u0442\u0440\u0435 \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440 \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f, \u043a\u0430\u0436\u0434\u044b\u0439 \u0431\u0443\u0434\u0435\u0442 \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d \u043d\u0430 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u043c \u043f\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u043c.\n\u041f\u043e\u0441\u043b\u0435 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u0432 \u043b\u044e\u0431\u043e\u043c \u0441\u043b\u0443\u0447\u0430\u0435 \u043e\u0442\u0441\u044e\u0434\u0430 \u043f\u0440\u043e\u043f\u0430\u0434\u0443\u0442 \u0438 \u043f\u043e\u044f\u0432\u044f\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435 \u0441 \u0443\u0441\u043f\u0435\u0445\u043e\u043c \u0438\u043b\u0438 \u043e\u0448\u0438\u0431\u043a\u043e\u0439.\n\u041f\u0435\u0447\u0430\u0442\u0430\u044e\u0442\u0441\u044f \u0430\u0441\u0438\u043d\u0445\u0440\u043e\u043d\u043d\u043e \u0432 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0435. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0435\u0441\u043b\u0438 \u0437\u043d\u0430\u0435\u0442\u0435 \u0434\u043b\u044f \u0447\u0435\u0433\u043e \u044d\u0442\u043e."), (String)"\u041f\u0435\u0447\u0430\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439")) {
                    String message = ((CashcheckService)((ClientContext)ManagerQueue.this.getContext()).getPort(CashcheckService.class)).printCheckBatchAuto(ManagerQueue.newPaymentIdList(payments));
                    ClientUtils.showMessageDialog((Object)message, (String)"\u041f\u0435\u0447\u0430\u0442\u044c \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430");
                    ManagerQueue.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("printCheckCharge", "\u041f\u0435\u0447\u0430\u0442\u044c \u0447\u0435\u043a\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                List payments = ManagerQueue.this.model.getSelectedRows();
                if (payments == null || payments.size() != 1) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u043e\u0432\u043d\u043e \u043e\u0434\u043d\u0443 \u0441\u0442\u0440\u043e\u043a\u0443 (\u0441 \u043c\u0430\u043f\u043f\u0438\u043d\u0433\u043e\u043c manual)!");
                    return;
                }
                int currSelectPrinterId = ((IdTitle)ManagerQueue.this.registratorCB.getSelectedItem()).getId();
                if (currSelectPrinterId > 0) {
                    ClientUtils.showErrorMessageDialog((String)"\u0420\u0443\u0447\u043d\u044b\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \"\u0422\u0435\u043a\u0443\u0449\u0435\u0433\u043e\" \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                    return;
                }
                StringBuffer sb = new StringBuffer(1024);
                int colnum = 1;
                BigDecimal summaTotal = BigDecimal.ZERO;
                Payment row = (Payment)payments.get(0);
                sb.append(colnum++).append(") ");
                sb.append(row.getPaymentTypesTitle()).append(" | ");
                sb.append(row.getSumma()).append(" | ");
                sb.append(row.getContractTitle()).append(" | ");
                sb.append(row.getComment()).append("\n");
                summaTotal = summaTotal.add(row.getSumma());
                Object text = sb.toString();
                text = (String)text + "\u0418\u0442\u043e\u0433\u043e: " + summaTotal;
                if (ClientUtils.confirm((String)("\u041d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a \u043d\u0430 \u0422\u0415\u041a\u0423\u0429\u0415\u041c \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0435?\n\n" + (String)text), (String)"\u0427\u0435\u043a")) {
                    PrintCheckData pc = ((CashcheckService)((ClientContext)ManagerQueue.this.getContext()).getPort(CashcheckService.class)).returnCheckCharge(((Payment)payments.get(0)).getPaymentId());
                    String submitRet = pc.submit;
                    String summaRet = pc.summa;
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d \u0447\u0435\u043a \u043d\u0430 \u0441\u0443\u043c\u043c\u0443: " + summaRet + "\n\n\u0421\u0434\u0430\u0447\u0430: " + submitRet);
                    ManagerQueue.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("printAdvance", "\u041f\u0435\u0447\u0430\u0442\u044c \u0437\u0430\u0447\u0451\u0442\u043e\u0432 \u0430\u0432\u0430\u043d\u0441\u043e\u0432"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                PaymentAdvanceDialog dialog = new PaymentAdvanceDialog((ClientContext)ManagerQueue.this.getContext());
                dialog.showDialog();
            }
        };
    }

    public static List<Integer> newPaymentIdList(Collection<Payment> list) {
        ArrayList<Integer> result = new ArrayList<Integer>(list.size());
        for (Payment k : list) {
            result.add(k.getPaymentId());
        }
        return result;
    }

    public static BigDecimal getClientSumma(String text, BigDecimal summaTotal) {
        boolean corr;
        text = (String)text + "\u0418\u0442\u043e\u0433\u043e: " + summaTotal + "\n\n\u0421\u0443\u043c\u043c\u0430 \u043e\u0442 \u043a\u043b\u0438\u0435\u043d\u0442\u0430:";
        BigDecimal fsumma = null;
        do {
            corr = true;
            String summa = (String)JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u041d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a \u043d\u0430 \u0422\u0415\u041a\u0423\u0429\u0415\u041c \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0435?\n\n" + (String)text, "\u0427\u0435\u043a", 1, null, null, String.valueOf(summaTotal));
            if (summa == null) {
                return null;
            }
            try {
                fsumma = new BigDecimal(summa);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 " + summa + " \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e");
                corr = false;
                continue;
            }
            if (fsumma.compareTo(summaTotal) >= 0) continue;
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 " + summa + " \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u0442\u043e\u0433\u043e\u0432\u043e\u0439 \u0441\u0443\u043c\u043c\u044b " + summaTotal);
            corr = false;
        } while (!corr);
        return fsumma;
    }

    private void gotoContract() {
        Payment payment = (Payment)this.model.getSelectedRow();
        if (payment == null) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043d\u0438 \u043e\u0434\u0438\u043d \u043f\u043b\u0430\u0442\u0451\u0436! \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u043d\u0443 \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u0440\u043e\u043a!");
            return;
        }
        this.openContract(payment.getContractId());
    }

    private void initList() throws BGException {
        try {
            Result result = ((CashcheckService)((ClientContext)this.getContext()).getPort(CashcheckService.class)).registratorList();
            List list = result.getList();
            this.registratorCB.setData(list);
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0441\u043f\u0438\u0441\u043a\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u043e\u0432!");
        }
        this.registratorCB.insertItemAt((Object)new IdTitle(0, "--- \u0422\u0435\u043a\u0443\u0449\u0438\u0439 ---"), 0);
        this.registratorCB.setSelectedItem((Object)0);
    }

    private void setRegistratorBindedName(String registratorBindedName) {
        ((IdTitle)this.registratorCB.getItemAt(0)).setTitle("--- \u0422\u0435\u043a\u0443\u0449\u0438\u0439 (" + (registratorBindedName != null ? registratorBindedName : "?") + ") ---");
    }
}

