/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.BooleanTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleTabPanel;
import ru.bitel.bgbilling.modules.subscription.common.service.SubscriptionService;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;

public class PatternModuleTabPanelItemFactory
implements PatternModuleTabPanel.PatternModuleTabPanelItemFactory {
    public Collection<PatternModuleTabPanel.PatternModuleTabPanelItem> getPatternModuleTabPanelItems(int moduleId, String moduleTitle) {
        return Collections.singleton(new SetSubscription(moduleId));
    }

    private class SetSubscription
    extends PatternModuleTabPanel.PatternModuleTabPanelItem {
        private String title;
        private ClientContext clientContext;
        private TableModel tableModel;
        private BGUTable table;
        private SubscriptionService subscriptionService;

        private SetSubscription(int moduleId) {
            super((LayoutManager)new GridBagLayout(), moduleId);
            this.title = null;
            this.tableModel = new TableModel(TableModel.class.getName());
            this.table = new BGUTable((javax.swing.table.TableModel)((Object)this.tableModel));
            this.clientContext = new ClientContext("subscription", moduleId, -1, "");
            this.setTitle("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0438");
            this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    RowData rowData;
                    if (mouseEvent.getClickCount() == 2 && (rowData = (RowData)SetSubscription.this.tableModel.getSelectedRow()) != null) {
                        int column = SetSubscription.this.table.columnAtPoint(mouseEvent.getPoint());
                        if (column == 0) {
                            rowData.setValue(!rowData.getValue());
                        } else if (column == 1) {
                            rowData.setAvto(!rowData.isAvto());
                        }
                        SetSubscription.this.table.revalidate();
                        SetSubscription.this.table.repaint();
                    }
                }
            });
        }

        private SubscriptionService getSubscriptionService() {
            if (this.subscriptionService == null) {
                this.subscriptionService = (SubscriptionService)this.clientContext.getPort(SubscriptionService.class);
            }
            return this.subscriptionService;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        protected boolean isItemEnabled() {
            return true;
        }

        protected void init() {
            ArrayList data = new ArrayList();
            try {
                this.getSubscriptionService().subscriptionTypeList().forEach(s -> {
                    RowData rowData = new RowData();
                    rowData.setId(String.valueOf(s.getId()));
                    rowData.setTitle(s.getTitle());
                    data.add(rowData);
                });
                this.tableModel.setData(data);
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        protected void reset() {
            this.tableModel.getRows().forEach(r -> {
                r.setValue(false);
                r.setAvto(false);
            });
        }

        protected void serialise(Element element) {
            Element module = XMLUtils.createElement((Element)element, (String)"subscription");
            module.setAttribute("mid", String.valueOf(this.getModuleId()));
            Element addSubscription = XMLUtils.createElement((Element)module, (String)"addSubscription");
            this.tableModel.getRows().forEach(s -> {
                if (s.getValue()) {
                    Element item = XMLUtils.createElement((Element)addSubscription, (String)"item");
                    item.setAttribute("id", String.valueOf(s.getId()));
                    item.setAttribute("avto", String.valueOf(s.isAvto()));
                }
            });
        }

        protected void setData(Element element) {
            this.reset();
            XMLUtils.selectElements((Node)element, (String)("data/modules/subscription[@mid=" + this.getModuleId() + "]/addSubscription/item")).forEach(i -> {
                String id = i.getAttribute("id");
                for (RowData rowData : this.tableModel.getRows()) {
                    if (!rowData.getId().equals(id)) continue;
                    rowData.setValue(true);
                    rowData.setAvto(Boolean.valueOf(i.getAttribute("avto")));
                    break;
                }
            });
        }
    }

    public class TableModel
    extends BGTableModel<RowData> {
        public TableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("V", 30, 30, 30, "value", true).setTableCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
            this.addColumn("\u0410\u0432\u0442\u043e\u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435", 130, 130, 130, "avto", true).setTableCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class RowData {
        private String id;
        private String title;
        private boolean value;
        private boolean avto;

        public boolean isAvto() {
            return this.avto;
        }

        public void setAvto(boolean avto) {
            this.avto = avto;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean check) {
            this.value = check;
        }
    }
}

