/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.client;

import bitel.billing.module.common.ActualDateFilter;
import bitel.billing.module.common.BGControlPanelMonth;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;

public class ServicePropertiesPanel
extends ServicePanel {
    private BGTable table = new BGTable();
    private ActualDateFilter filter = new ActualDateFilter((BGPanel)this);
    private JPanel tablePanel = new JPanel();
    private JPanel editorsPanel = new JPanel();
    private BGControlPanelMonth monthPanel = new BGControlPanelMonth();

    public ServicePropertiesPanel() {
        this.setTabbedPanel();
        this.jbInit();
        this.table.setHeader(this.rb_name, "login");
        JPopupMenu popupMenu = this.createPopupMenu(this.table);
        this.initTransferContractPopup(popupMenu, this.table, "MoveLogin", "id", "lid");
        this.initWrapContractPopup(popupMenu, this.table, "WrapLogin", "id", "lid");
    }

    private void jbInit() {
        this.setLayout(this.cardLayout1);
        this.add(this.tablePanel, "table");
        this.add(this.editorsPanel, "editor");
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.add((Component)this.filter, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 5, 3), 0, 0));
        this.tablePanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.tablePanel.add((Component)this.getSetBalancePanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 0, 3), 0, 0));
        BGButtonPanelRestoreOkCancelHelp controlPanel = new BGButtonPanelRestoreOkCancelHelp();
        this.editorsPanel.setLayout(new GridBagLayout());
        this.editorsPanel.add((Component)this.editorsTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorsPanel.add((Component)controlPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        this.cardLayout1.show((Container)((Object)this), "table");
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ServicePropertiesPanel.this.table_mouseClicked(e);
            }
        });
        controlPanel.addActionListener(e -> this.actionPerformed(e));
    }

    private JPanel getSetBalancePanel() {
        JButton setBalanceButton = new JButton("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0431\u0430\u043b\u0430\u043d\u0441");
        setBalanceButton.addActionListener(e -> this.setBalance());
        JPanel setBalancePanel = new JPanel(new GridBagLayout());
        setBalancePanel.setBorder((Border)new BGTitleBorder("\u0420\u0443\u0447\u043d\u0430\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430"));
        setBalancePanel.add((Component)this.monthPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        setBalancePanel.add((Component)setBalanceButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        return setBalancePanel;
    }

    public void setData() {
        this.filter.updateDate();
        if (this.getContractId() > -1 && this.getModuleId() > -1) {
            this.cardLayout1.show((Container)((Object)this), "table");
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ContractInfo");
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAttribute("object_id", this.objectId);
            if (this.filter.isEnabled()) {
                request.setAttribute("actualItemsDate", TimeUtils.format((Calendar)this.filter.getDateCalendar(), (String)"dd.MM.yyyy"));
            }
            this.setDocument(this.getDocument(request));
        }
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
        }
    }

    public void newItem() {
        if (this.editorsPanel.isVisible()) {
            this.showMessageDialog();
            return;
        }
        this.initServiceSubPanel(this.editorsTabbedPane, 0);
        this.cardLayout1.show((Container)((Object)this), "editor");
    }

    public void editItem() {
        if (!this.editorsPanel.isVisible()) {
            String id = ClientUtils.getRowId((BGTable)this.table);
            if (id != null) {
                this.initServiceSubPanel(this.editorsTabbedPane, Utils.parseInt((String)id, (int)-1));
                this.cardLayout1.show((Container)((Object)this), "editor");
            }
        } else {
            this.showMessageDialog();
            return;
        }
    }

    public void deleteItem() {
        if (!this.editorsPanel.isVisible()) {
            String id = ClientUtils.getRowId((BGTable)this.table);
            if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                Request request = new Request();
                request.setModule(this.module);
                request.setAction("DeleteLogin");
                request.setModuleId(this.getModuleId());
                request.setContractId(this.getContractId());
                request.setAttribute("id", id);
                Document doc = this.getDocument(request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    this.cardLayout1.show((Container)((Object)this), "table");
                    this.setData();
                }
            }
        } else {
            this.showMessageDialog();
            return;
        }
    }

    private void table_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.editItem();
        }
    }

    private void setBalance() {
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("SetBalance");
        req.setContractId(this.getContractId());
        req.setAttribute("date", this.monthPanel.getDateString());
        ClientUtils.checkStatus((Document)this.getDocument(req));
    }
}

