/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.client.tariff;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;

public class PrefixTariffTreeNode
extends DefaultTariffTreeNode {
    private static final int MAX_WIDTH = 50;
    private static Icon icon = ClientUtils.getIcon((String)"pref");
    private JLabel view = new JLabel();
    private JTextArea prefix;

    public PrefixTariffTreeNode() {
        this.view.setIcon(icon);
    }

    protected JPanel getEditorPanel() {
        this.prefix = new JTextArea();
        JScrollPane prefScroll = new JScrollPane();
        JPanel propsPanel = new JPanel();
        prefScroll.getViewport().add(this.prefix);
        this.prefix.setColumns(30);
        this.prefix.setRows(4);
        this.prefix.setWrapStyleWord(true);
        this.prefix.setLineWrap(true);
        propsPanel.add(prefScroll);
        return propsPanel;
    }

    public Component getView() {
        String data = this.getData();
        StringTokenizer st = new StringTokenizer(data, ",");
        StringBuffer labelText = new StringBuffer("<html>");
        int line_size = 0;
        while (st.hasMoreTokens()) {
            String pref = st.nextToken();
            labelText.append(pref);
            if (st.hasMoreTokens()) {
                labelText.append(", ");
            }
            if ((line_size += pref.length()) <= 50) continue;
            line_size = 0;
            labelText.append("<br>");
        }
        this.view.setText(labelText.toString());
        return this.view;
    }

    protected void loadData() {
        this.prefix.setText(this.getData());
    }

    protected void serializeData() {
        String[] prefixArray = this.prefix.getText().split("\\s*,\\s*");
        ArrayList<String> prefixList = new ArrayList<String>();
        for (String prefix : prefixArray) {
            prefixList.add(prefix);
        }
        Collections.sort(prefixList);
        StringBuffer sorted = new StringBuffer(this.prefix.getText().length());
        for (String prefix : prefixList) {
            if (sorted.length() != 0) {
                sorted.append(",");
            }
            sorted.append(prefix);
        }
        this.setData(sorted.toString());
    }

    public String getPrefixes() {
        return this.getData();
    }

    public void serializeToXML(Element el) {
        el.setAttribute("values", this.getPrefixes());
        this.serializeChildsToXML(el);
    }

    public void loadFromXML(Element el) {
        String title = el.getAttribute("values");
        this.setData(title);
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

