window.onload = function() {
	init();
}

init = function() {
	var i = navigator.userAgent.indexOf("MSIE");
	if ( i!=0 ) {
		window.__browserIE = true;
		window.__browserVersion = parseFloat(navigator.userAgent.substring(i+5));
	}
}

$$ = function( element ) {
	return document.getElementById(element);
}

setPage = function ( page_num ) {
	var page = document.getElementById("idPageIndex");
	page.value = page_num;
	page.form.submit();
}

getWidth = function() {
	if (window.__browserIE&&window.__browserVersion<7)
		return (document.body.clientWidth > 1100)?"800px":((document.body.clientWidth > 900)?"100%":"600px");
	else
		return "100%";
}

// форматирование телефонного параметра
var prefixsSort = [];
	
function sortPrefixs()
{
	for ( var i = 0; i < prefixs.length; ++i )
	{
		var index = prefixs[i].replace(/[^\d]/g, '').length;
		var pref = ( prefixsSort[index] == undefined ) ? new Array() : prefixsSort[index];
		pref[pref.length] = prefixs[i];
		prefixsSort[index] = pref;
	} 
}

function doPhoneParamFormat(input)  
{
	// Первоначальная сортировка префиксов по количеству цифр.
	// Результат - многомерный массив, индекс - количество цифр в префиксе
	if ( typeof input.phonePrefix == 'undefined' )
	{
		input.phonePrefix = "";
	}
	
	if (!isDigit(input))
	{
	   return;
	}
	// На каждом шаге пытаемся найти более подходящий префикс
	searchPrefix(input);
    insertSpace(input);  
	
    var result = "";
	// Запрет ввода некорректных символов, проверка на количество	
	function isDigit(input)
	{
	    var value = input.value.replace(/\s+/g, '');
		if (input.phonePrefix.length != 0 && input.value.length > input.phonePrefix.length) {
			input.value = input.value.substring(0, input.phonePrefix.length);
			result = "Длина не может быть больше " + input.phonePrefix.replace(/\s+/g, '').length + " цифр";
 	    }
	    else if (!/^\d+$/.test(value) && input.value != '') {
			input.value = input.value.replace(/[^\d^\s]/g, '');	
			input.value = input.value.trim();				
			result = "Можно вводить только цифры!";	
	    }  
    	else {
			result = "";		
	    }
		
		var resultElement = document.getElementById("result_"+input.name);
		if ( resultElement == null )
		{
			if ( result != "" )
			{
				alert( result );
			}
		}
		else
		{
			resultElement.innerHTML = result;
		}
		
	    return result == '';
	}
	
	// Поиск префикса
	function searchPrefix(input)
	{
		// Цикл от количества цифр
		for (var i = input.value.length; i >= 0; --i)
		{
			var pref = prefixsSort[i];
			if ( pref == undefined )
			{
				continue;
			}
			
			// Ищем префикс с таким же количеством цифр
			for (var j = 0; j < pref.length; ++j)
			{
				// Цифры префикса
				var pr = pref[j].replace(/[^\d]/g, '');
				// Цифры нашего значения
				var value = input.value.replace(/\s+/g, '').substring(0, pr.length);
	            if (pr == value)
				{
					// Если префикс найден - выходим 
					input.phonePrefix = pref[j];
					return;
				}		
			}
		}
		// Если ни один не подошел - затираем предыдущее значение префикса
		input.phonePrefix = "";
	}
	
	// Расставляет пробелы в соответствии с найденным префиксом
    function insertSpace(input)
    {
		// Удаляем все пробелы
		input.value = input.value.replace(/\s+/g, '');
		for (var i = 0; (i < input.phonePrefix.length) && (i < input.value.length); ++i)
	    {
			// Если на i-ой позиции в префиксе пробел - ставим пробел и в нашу строку
		  	if (input.phonePrefix[i] == ' ')
		   	{
				input.value = input.value.substring(0, i) + ' ' + input.value.substring(i, input.value.length);
		   	}	
		}
	}
}

function checkCustomerAddress( customerAddress, text )
{
	if ( customerAddress.length < 7 )
	{
		alert( text );
		return false;
	}
	return true;
}

function checkSum( sumVal, sumMin, sumMax )
{
	var sum = parseFloat( sumVal.replace(",",".") );
	if ( isNaN( sum ) )
	{
		return 'Введена некорректная сумма';		
	}
	else if ( sum < sumMin || sum > sumMax )
	{
		return "Введите сумму от " + sumMin + " до " + sumMax;		
	}
	return undefined;
}

function checkPaymentSum( data )
{
	var text = checkSum( data.sum, data.sumMin, data.sumMax );
	if ( data.phoneNeed && data.phone.length < 7 )
	{
		alert( "Введите номер телефона" );
		return false;		
	}
	if ( text == undefined )
	{
		var sum = parseFloat( data.sum.replace(",",".") );
		return confirm('Вы подтверждаете платеж на сумму - ' + sum + ' ' + data.currency + '?');
	}
	else
	{
		alert( text )
	}
	return false;		
}

function doPay( form )
{
	return true;
}

function doAutopayment()
{
	jQuery('form.autopayment').submit();
	return true;
}

function getFormValue( form, name )
{
	var formValue = "";
	if ( form[name] !== undefined )
	{
		formValue = form[name].value;
	}
	return formValue;
}

function addInputHidden( form, name, value )
{
	if ( form[name] == undefined || form[name].value == undefined ) return;
	var input = document.createElement("input");
	input.type = "hidden";
	input.name = name;
	input.value = value;
	form.appendChild(input);
}

function onKeyUpPaymentSum( input )
{
	return true;
}

function onKeyUpPaymentPhone( input )
{
	let phone = input.value;
	if ( phone == '' ) return true;
	if ( !/^\+[0-9]{7,15}$/.test( phone ) )
	{
		phone = "+" + phone.replace( /[^0-9]/g, "" );
		if ( phone.length > 15 )
		{
			phone = phone.substring( 0, 15 );
		}
		input.value = phone; 
	}
	return true;
}

function showTab( tabName, tabId )
{
	jQuery('ul.tabs.'+tabName+' li a').removeClass('active')
	jQuery('ul.tabs.'+tabName+' li.'+tabId + ' a').addClass('active');
	jQuery('div.tab.'+tabName).hide();
	jQuery('div.tab.'+tabName+'.'+tabId).show();
	return false;
}

function showHelpMessage( text, title )
{
	if ( title == undefined ) title = "Подсказка";
	var helpMessage = jQuery(".helpMessage");
	jQuery(".helpTitle",helpMessage).html(title);
	jQuery(".helpText",helpMessage).html(text);
	helpMessage.show();
}

function hideHelpMessage()
{
	jQuery(".helpMessage").hide();
}

function getCustomerAddressValue( form )
{
	if ( form['customerAddress'] == undefined  ) return "";
	return form['customerAddress'].value;
}
