/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.EditorTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.smarthouse.client.AbstractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.BaseOptionTableModel;
import ru.bitel.bgbilling.modules.smarthouse.client.BasePackageTableModel;
import ru.bitel.bgbilling.modules.smarthouse.client.PackageDurationPanel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.BooleanEditor;
import ru.bitel.bgbilling.modules.smarthouse.client.common.EditorLabel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.EditorUtils;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageOption;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.RowData;
import ru.bitel.common.model.SearchResult;

public class PackageBasePanel
extends AbstractBasePanel<SmartHousePackageBase, BasePackageTableModel> {
    private static final String EDIT_OPTION = "editOption";
    private BasePackageTableModel tableModel = null;

    protected void jbInit() throws Exception {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)this.getTable()), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchResult searchResult = this.getSmartHousePackageService().packageBaseSearch(null, false, this.getTable().getSort(), this.getPages().getPage());
            this.getTableModel().setData(searchResult.getList());
            this.getPages().setPage(searchResult.getPage());
            this.recordCount.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)searchResult.getPage().getRecordCount()));
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new PackageDialogEditor("\u041d\u043e\u0432\u044b\u0439 \u043f\u0430\u043a\u0435\u0442", new SmartHousePackageBase()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            SmartHousePackageBase basePackage = (SmartHousePackageBase)this.getTableModel().getSelectedRow();
            if (basePackage == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            } else {
                new PackageDialogEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u043a\u0435\u0442\u0430", basePackage).open();
            }
        });
        new AbstractBGUPanel.DefaultAction(EDIT_OPTION, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u043f\u0446\u0438\u0439", ClientUtils.getIcon((String)"fugue/present")){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                SmartHousePackageBase basePackage = (SmartHousePackageBase)PackageBasePanel.this.getTableModel().getSelectedRow();
                if (basePackage == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                } else {
                    new OptionDialogEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u043f\u0446\u0438\u0439", basePackage).open();
                }
            }
        };
    }

    @Override
    protected void getPopupMenuItems() {
        Action action = this.getActionMap().get("edit");
        action.putValue("Name", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435");
        this.getPopupMenu().add(new JMenuItem(action));
        this.getPopupMenu().add(new JMenuItem(this.getActionMap().get(EDIT_OPTION)));
    }

    @Override
    protected BasePackageTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new BasePackageTableModel(BasePackageTableModel.class.getName());
        }
        return this.tableModel;
    }

    private JPanel getFilterPanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u0430:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new BGTextField(20), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JToggleButton("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0430\u0440\u0445\u0438\u0432\u043d\u044b\u0435"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)new JToggleButton("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.recordCount, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.getPages(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        return panel;
    }

    class PackageDialogEditor
    extends BGEditorDialog<SmartHousePackageBase> {
        private EditorTextField title;
        private EditorTextField comment;
        private PackageDurationPanel duration;
        private BGControlPanelPeriodNoB period;

        public PackageDialogEditor(String title, SmartHousePackageBase data) {
            super(title, (Object)data);
            this.title = new EditorTextField(40, "", PackageBasePanel.this.focusListener);
            this.comment = new EditorTextField(40, "", PackageBasePanel.this.focusListener);
            this.duration = new PackageDurationPanel();
            this.period = new BGControlPanelPeriodNoB(false);
        }

        public void doDialogPanel() {
            this.panel.add((Component)new EditorLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new EditorLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.comment, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new EditorLabel("\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.duration, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new EditorLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.title.setText(((SmartHousePackageBase)this.data).getTitle());
            this.comment.setText(((SmartHousePackageBase)this.data).getComment());
            this.period.setPeriod(((SmartHousePackageBase)this.data).getPeriod());
            this.duration.getValue().setText(String.valueOf(((SmartHousePackageBase)this.data).getDurationValue()));
            int unitCode = ((SmartHousePackageBase)this.data).getDurationUnitCode();
            int itemCount = this.duration.getUnit().getItemCount();
            for (int index = 0; index < itemCount; ++index) {
                if (((IdTitle)this.duration.getUnit().getItemAt(index)).getId() != unitCode) continue;
                this.duration.getUnit().setSelectedIndex(index);
                break;
            }
        }

        public boolean doApply() throws Exception {
            Color color = Color.YELLOW;
            boolean error = EditorUtils.checkTextField(this.title, color, false);
            if (error) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043b\u0435\u0439.");
                return false;
            }
            try {
                PackageBasePanel.this.getSmartHousePackageService().smartHousePackageBaseUpdate(SmartHousePackageBase.builder().setId(((SmartHousePackageBase)this.data).getId()).setTitle(this.title.getText()).setComment(this.comment.getText()).setPeriod(this.period.getPeriod()).setDurationValue(Utils.parseInt((String)this.duration.getValue().getText(), (int)1)).setDurationUnitCode(((IdTitle)this.duration.getUnit().getSelectedItem()).getId()).build());
                PackageBasePanel.this.performAction("refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
            return true;
        }
    }

    class OptionDialogEditor
    extends BGEditorDialog<SmartHousePackageBase> {
        private List<RowData> list;

        public OptionDialogEditor(String title, SmartHousePackageBase data) {
            super(title, (Object)data);
            this.list = new ArrayList<RowData>();
        }

        public void doDialogPanel() {
            BaseOptionTableModel baseOptionTableModel = new BaseOptionTableModel();
            BGUTable optionTable = new BGUTable((TableModel)((Object)baseOptionTableModel)){

                public TableCellEditor getCellEditor(int row, int column) {
                    return new BooleanEditor();
                }
            };
            optionTable.setContext((ClientContext)PackageBasePanel.this.getContext());
            optionTable.setSelectionMode(0);
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)optionTable, (int)600, (int)250), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            try {
                JSONArray optionNames = new JSONArray(((SmartHousePackageBase)this.data).getOptionNames());
                for (SmartHousePackageOption packageOption : PackageBasePanel.this.getSmartHousePackageService().packageOptionList()) {
                    boolean selected = false;
                    for (int index = 0; index < optionNames.length(); ++index) {
                        if (!packageOption.getName().equals(optionNames.getString(index))) continue;
                        selected = true;
                        break;
                    }
                    this.list.add(new RowData(new JSONObject().put("name", (Object)packageOption.getName()).put("title", (Object)packageOption.getTitle()).put("selected", selected)));
                }
                baseOptionTableModel.setData(this.list);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        public boolean doApply() throws Exception {
            try {
                JSONArray jsonArray = new JSONArray();
                for (RowData rowData : this.list) {
                    if (!rowData.getJson().optBoolean("selected")) continue;
                    jsonArray.put(rowData.getJson().get("name"));
                }
                ((SmartHousePackageBase)this.data).setOptionNames(jsonArray.toString());
                PackageBasePanel.this.getSmartHousePackageService().packageBaseOptionUpdate(((SmartHousePackageBase)this.data).getId(), ((SmartHousePackageBase)this.data).getOptionNames());
                PackageBasePanel.this.performAction("refresh");
                return true;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return super.doApply();
            }
        }
    }
}

