/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ContractTitlePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ParamTableRow;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostContractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostContractCameraPanel;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostContractGroupPanel;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostContractObjectPanel;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostContractUserPanel;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostEditorDialog;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostParamTable;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostParamTableModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostAccountService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class ForpostContractAccountsPanel
extends ForpostContractBasePanel {
    private BGUTable table;
    private ForpostParamTable accountDataTable;
    private AccountTableModel tableModel;
    private ForpostAccountService accountService;
    private ForpostParamTableModel accountDataTableModel;
    private ForpostAccountTitleActivePanel titlePanel = new ForpostAccountTitleActivePanel();
    private ForpostContractUserPanel userPanel = new ForpostContractUserPanel();
    private ForpostContractCameraPanel cameraPanel = new ForpostContractCameraPanel();
    private ForpostContractObjectPanel objectPanel = new ForpostContractObjectPanel();
    private ForpostContractGroupPanel groupPanel = new ForpostContractGroupPanel();

    @Override
    protected void jbInit() throws Exception {
        JScrollPane scrollPane = new JScrollPane(this.getAccountDataPanel());
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getAccountsPanel(), (Component)scrollPane, 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void showForpostAccountData(ForpostAccount forpostAccount) {
        boolean enabled = forpostAccount != null;
        this.titlePanel.setEnabled(enabled);
        this.cameraPanel.setEnabled(enabled);
        this.userPanel.setEnabled(enabled);
        this.objectPanel.setEnabled(enabled);
        this.groupPanel.setEnabled(enabled);
        if (enabled) {
            HashMap<String, String> titles = new HashMap<String, String>();
            titles.put("NetworkIP", "\u0410\u0434\u0440\u0435\u0441 IP-\u0441\u0435\u0442\u0438");
            titles.put("NetworkMask", "\u041c\u0430\u0441\u043a\u0430 IP-\u0441\u0435\u0442\u0438");
            titles.put("ContractNumber", "\u041d\u043e\u043c\u0435\u0440 \u0441\u0447\u0435\u0442\u0430");
            titles.put("Quota", "\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0430\u0440\u0445\u0438\u0432\u0430 \u0432 \u0441\u0435\u043a.");
            titles.put("MaxCameraOnlineTranslationCount", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0440\u0430\u043d\u0441\u043b\u044f\u0446\u0438\u0439 \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0439 \u043a\u0430\u043c\u0435\u0440\u044b");
            titles.put("MaxCameraArchivalTranslationCount", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0440\u0430\u043d\u0441\u043b\u044f\u0446\u0438\u0439 \u0438\u0437 \u0430\u0440\u0445\u0438\u0432\u0430 \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0439 \u043a\u0430\u043c\u0435\u0440\u044b");
            titles.put("MaxCameraUserOnlineTranslationCount", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0440\u0430\u043d\u0441\u043b\u044f\u0446\u0438\u0439 \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 \u043e\u0434\u043d\u043e\u0439 \u043a\u0430\u043c\u0435\u0440\u044b");
            titles.put("MaxCameraUserArchivalTranslationCount", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0440\u0430\u043d\u0441\u043b\u044f\u0446\u0438\u0439 \u0438\u0437 \u0430\u0440\u0445\u0438\u0432\u0430 \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 \u043e\u0434\u043d\u043e\u0439 \u043a\u0430\u043c\u0435\u0440\u044b");
            ArrayList<ParamTableRow> list = new ArrayList<ParamTableRow>();
            list.add(new ParamTableRow("MaxCameraCount", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0430\u043c\u0435\u0440", String.valueOf(forpostAccount.getMaxCameraCount())));
            list.add(new ParamTableRow("MaxLoginCount", "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439", String.valueOf(forpostAccount.getMaxLoginCount())));
            Utils.linesToPairsHash((String)forpostAccount.getData()).forEach((k, v) -> list.add(new ParamTableRow((String)k, titles.getOrDefault(k, (String)k), String.valueOf(v))));
            this.titlePanel.setForpostAccount(forpostAccount);
            this.accountDataTableModel.setData(list);
            this.cameraPanel.setAccountId(forpostAccount.getId());
            this.cameraPanel.performAction("camera.refresh");
            this.userPanel.setAccountId(forpostAccount.getId());
            this.userPanel.performAction("user.refresh");
            this.objectPanel.setAccountId(forpostAccount.getId());
            this.objectPanel.performAction("object.refresh");
            this.groupPanel.setAccountId(forpostAccount.getId());
            this.groupPanel.performAction("group.refresh");
        } else {
            this.titlePanel.setForpostAccount(null);
            this.accountDataTableModel.deleteRows();
            this.cameraPanel.clearTableModel();
            this.userPanel.clearTableModel();
            this.objectPanel.clearTableModel();
            this.groupPanel.clearTableModel();
        }
    }

    private JPanel getAccountsPanel() throws Exception {
        JButton linkAccountButton = new JButton("link");
        linkAccountButton.addActionListener(e -> this.getAccountLinkDialog(((ClientContext)this.getContext()).getContractId()).setVisible(true));
        JButton unlinkAccountButton = new JButton("unlink");
        unlinkAccountButton.addActionListener(e -> {
            try {
                ForpostAccount forpostAccount = (ForpostAccount)((AccountTableModel)this.getTableModel()).getSelectedRow();
                if (forpostAccount == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442");
                } else if (ClientUtils.confirm((String)"\u041e\u0442\u0432\u044f\u0437\u0430\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u043e\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", (String)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435")) {
                    this.getForpostAccountService().unlinkForpostAccount(forpostAccount.getId());
                    this.performAction("refresh");
                }
            }
            catch (BGException e1) {
                ClientUtils.showErrorMessageDialog((Throwable)e1);
            }
        });
        int gridx = 0;
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)linkAccountButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)unlinkAccountButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)panel, (String)"\u0410\u043a\u043a\u0430\u0443\u043d\u0442\u044b:");
        panel.add((Component)buttonPanel, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.getTable()), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getAccountDataPanel() {
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)panel, (String)"\u0414\u0430\u043d\u043d\u044b\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430");
        panel.add((Component)this.titlePanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 10, 0), 0, 0));
        panel.add((Component)this.getAccountParametersPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)((Object)this.cameraPanel), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)((Object)this.userPanel), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)((Object)this.objectPanel), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)((Object)this.groupPanel), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getAccountParametersPanel() {
        this.accountDataTableModel = new ForpostParamTableModel();
        CellEditorListener cellEditorListener = new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                ParamTableRow tableRow = (ParamTableRow)ForpostContractAccountsPanel.this.accountDataTableModel.getSelectedRow();
                try {
                    ForpostAccount forpostAccount = (ForpostAccount)((AccountTableModel)ForpostContractAccountsPanel.this.getTableModel()).getSelectedRow();
                    ForpostContractAccountsPanel.this.getForpostAccountService().updateForpostAccountParam(forpostAccount.getId(), tableRow.getName(), tableRow.getValue());
                    forpostAccount = ForpostContractAccountsPanel.this.getForpostAccountService().getForpostAccount(forpostAccount.getId());
                    List accounts = ((AccountTableModel)ForpostContractAccountsPanel.this.getTableModel()).getRows();
                    for (int index = 0; index < accounts.size(); ++index) {
                        if (((ForpostAccount)accounts.get(index)).getId() != forpostAccount.getId()) continue;
                        accounts.remove(index);
                        accounts.add(index, forpostAccount);
                        break;
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        };
        this.accountDataTable = new ForpostParamTable((TableModel)((Object)this.accountDataTableModel), cellEditorListener);
        Dimension dimension = new Dimension(300, 200);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.accountDataTable));
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new ContractTitlePanel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b:", null), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchResult searchResult = this.getForpostAccountService().searchForpostAccounts(((ClientContext)this.getContext()).getContractId(), null, this.getTable().getSort(), null);
            ((AccountTableModel)this.getTableModel()).setData(searchResult.getList());
            this.showForpostAccountData((ForpostAccount)((AccountTableModel)this.getTableModel()).getSelectedRow());
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            ForpostAccount forpostAccount = this.getForpostAccountService().getDefaultForpostAccount(((ClientContext)this.getContext()).getContractId());
            forpostAccount.setContractId(((ClientContext)this.getContext()).getContractId());
            new ForpostEditorDialog<ForpostAccount>(forpostAccount, "forpost.contractAccountAdd", (ClientContext)this.getContext(), (JPanel)((Object)this)).getDialog().setVisible(true);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> ClientUtils.showMessageDialog((Object)"\u0414\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0432 \u0440\u0430\u0437\u0434\u0435\u043b\u0435 \"\u0414\u0430\u043d\u043d\u044b\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430\""));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            ForpostAccount forpostAccount = (ForpostAccount)((AccountTableModel)this.getTableModel()).getSelectedRow();
            if (forpostAccount != null && ClientUtils.confirmDelete((Object)forpostAccount.getName())) {
                this.objectPanel.deleteAccountObjects(forpostAccount.getId());
                this.objectPanel.clearTableModel();
                this.objectPanel.setEnabled(false);
                this.userPanel.deleteAccountUsers(forpostAccount.getId());
                this.userPanel.clearTableModel();
                this.userPanel.setEnabled(false);
                this.cameraPanel.deleteAccountCameras(forpostAccount.getId());
                this.cameraPanel.clearTableModel();
                this.cameraPanel.setEnabled(false);
                this.getForpostAccountService().deleteForpostAccount(forpostAccount.getId());
                this.accountDataTableModel.deleteRows();
                this.performAction("refresh");
            }
        });
    }

    private JDialog getAccountLinkDialog(int contractId) {
        AccountTableModel linkAccountTableModel = new AccountTableModel(AccountTableModel.class.getName() + "1");
        BGUTable linkTable = new BGUTable((TableModel)((Object)linkAccountTableModel));
        linkTable.setSelectionMode(0);
        linkTable.setContext((ClientContext)this.getContext());
        Dimension dimension = new Dimension(600, 200);
        JScrollPane scrollPane = new JScrollPane((Component)linkTable);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        try {
            SearchResult searchResult = this.getForpostAccountService().searchForpostAccounts(0, null, null, null);
            linkAccountTableModel.setData(searchResult.getList());
        }
        catch (BGException e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430");
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            ForpostAccount forpostAccount = (ForpostAccount)linkAccountTableModel.getSelectedRow();
            if (forpostAccount == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442.");
                return;
            }
            try {
                this.getForpostAccountService().linkForpostAccount(forpostAccount.getId(), contractId);
                this.performAction("refresh");
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception e1) {
                ClientUtils.showErrorMessageDialog((Throwable)e1);
            }
        });
        return dialog;
    }

    @Override
    protected BGTableModel<?> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new AccountTableModel(AccountTableModel.class.getName());
        }
        return this.tableModel;
    }

    @Override
    protected BGUTable getTable() {
        if (this.table == null) {
            this.table = new BGUTable(this.getTableModel());
            this.table.setSelectionMode(0);
            this.table.getSelectionModel().addListSelectionListener(e -> this.showForpostAccountData((ForpostAccount)((AccountTableModel)this.getTableModel()).getSelectedRow()));
        }
        return this.table;
    }

    private ForpostAccountService getForpostAccountService() {
        if (this.accountService == null) {
            this.accountService = (ForpostAccountService)((ClientContext)this.getContext()).getPort(ForpostAccountService.class);
        }
        return this.accountService;
    }

    class ForpostAccountTitleActivePanel
    extends JPanel {
        private ForpostAccount forpostAccount;
        private AccountTitleTextField nameField;
        private JToggleButton buttonOn;
        private JToggleButton buttonOff;
        private JButton nameEditButton;

        public ForpostAccountTitleActivePanel() {
            this.nameField = new AccountTitleTextField();
            this.buttonOn = new JToggleButton("\u0414\u0430", true);
            this.buttonOff = new JToggleButton("\u041d\u0435\u0442", false);
            this.nameEditButton = new JButton(ClientUtils.getIcon((String)"edit"));
            ActionListener actionListener = e -> {
                try {
                    if (this.forpostAccount != null) {
                        ForpostContractAccountsPanel.this.getForpostAccountService().updateForpostAccountParam(this.forpostAccount.getId(), "IsActive", this.buttonOn.isSelected() ? "1" : "0");
                        this.forpostAccount.setIsActive(this.buttonOn.isSelected() ? 1 : 0);
                        ForpostContractAccountsPanel.this.getTable().invalidate();
                        ForpostContractAccountsPanel.this.getTable().repaint();
                    }
                }
                catch (Exception e1) {
                    ClientUtils.showErrorMessageDialog((Throwable)e1);
                }
            };
            this.buttonOn.addActionListener(actionListener);
            this.buttonOff.addActionListener(actionListener);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.buttonOn);
            buttonGroup.add(this.buttonOff);
            this.nameEditButton.addActionListener(e -> {
                JTextField nameEditField = new JTextField(40);
                nameEditField.setText(this.forpostAccount != null ? this.forpostAccount.getName() : "");
                BGOptionPane optionPane = new BGOptionPane((Object)nameEditField, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430");
                JDialog dialog = optionPane.getDialog();
                ((JButton)optionPane.getOptions()[0]).addActionListener(e1 -> {
                    try {
                        ForpostContractAccountsPanel.this.getForpostAccountService().updateForpostAccountParam(this.forpostAccount.getId(), "Name", nameEditField.getText());
                        this.forpostAccount.setName(nameEditField.getText());
                        this.nameField.setText(nameEditField.getText());
                        ForpostContractAccountsPanel.this.getTable().invalidate();
                        ForpostContractAccountsPanel.this.getTable().repaint();
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                    catch (Exception e2) {
                        ClientUtils.showErrorMessageDialog((Throwable)e2);
                    }
                });
                dialog.setVisible(true);
            });
            int gridx = 0;
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.nameField, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.nameEditButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0410\u043a\u0442\u0438\u0432\u0435\u043d:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 5), 0, 0));
            this.add((Component)this.buttonOn, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.buttonOff, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void setForpostAccount(ForpostAccount forpostAccount) {
            this.forpostAccount = forpostAccount;
            this.nameField.setText(forpostAccount != null ? forpostAccount.getName() : "");
            this.buttonOn.setSelected(forpostAccount != null ? forpostAccount.getIsActive() > 0 : true);
            this.buttonOff.setSelected(forpostAccount != null ? forpostAccount.getIsActive() == 0 : false);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.nameEditButton.setEnabled(enabled);
            this.buttonOn.setEnabled(enabled);
            this.buttonOff.setEnabled(enabled);
        }
    }

    class AccountTableModel
    extends BGTableModel<ForpostAccount> {
        public AccountTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", 100, 200, -1, "name", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u0435\u043d", Boolean.class, 70, 70, 70, "isActive", true);
        }

        public Object getValueAt(ForpostAccount forpostAccount, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("isActive".equals(identifier)) {
                return forpostAccount.getIsActive() > 0;
            }
            return super.getValueAt((Object)forpostAccount, column);
        }
    }

    class AccountTitleTextField
    extends JTextField {
        public AccountTitleTextField() {
            Color bgColor = this.getBackground();
            this.setHorizontalAlignment(0);
            this.setEditable(false);
            this.setBackground(bgColor);
            this.setFont(new Font("Dialog", 1, 13));
        }
    }
}

