/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.EditorTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ContractTitlePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.EditorLabel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ParamTableEditorType;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ParamTableRow;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostContractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostParamTable;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostParamTableModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUser;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class ForpostContractUserPanel
extends ForpostContractBasePanel {
    private UserTableModel tableModel;

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(new ContractTitlePanel("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438:", (JComponent)((Object)this)), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapScrollPane((JComponent)this.getTable(), (int)300, (int)100), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void deleteAccountUsers(int id) throws BGMessageException, BGException {
        this.getForpostService().forpostAccountUsersDelete(this.accountId);
    }

    @Override
    protected BGTableModel<?> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new UserTableModel();
        }
        return this.tableModel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.getUserDialog(this.getForpostService().forpostUserDefaultGet()).setVisible(true));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            ForpostUser forpostUser = (ForpostUser)((UserTableModel)this.getTableModel()).getSelectedRow();
            if (forpostUser == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\" \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f.");
            } else {
                this.getUserEditDialog(forpostUser).setVisible(true);
                this.performAction("user.refresh");
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            ForpostUser forpostUser = (ForpostUser)((UserTableModel)this.getTableModel()).getSelectedRow();
            if (forpostUser == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\" \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f.");
            } else if (ClientUtils.confirmDelete((Object)forpostUser.getLogin())) {
                this.getForpostService().forpostUserDelete(forpostUser.getId());
                this.performAction("user.refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("user.refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", ICON_REFRESH){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ((UserTableModel)ForpostContractUserPanel.this.getTableModel()).setData(ForpostContractUserPanel.this.getForpostService().forpostAccountUserSearch(ForpostContractUserPanel.this.accountId).getList());
            }
        };
    }

    private JDialog getUserDialog(ForpostUser forpostUser) {
        EditorTextField userLogin = new EditorTextField(30, "\u0421\u0442\u0440\u043e\u043a\u0430<br>\u041b\u043e\u0433\u0438\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", this.focusListener);
        EditorTextField userPassword = new EditorTextField(30, "\u0421\u0442\u0440\u043e\u043a\u0430<br>\u041f\u0430\u0440\u043e\u043b\u044c", this.focusListener);
        EditorTextField userEmail = new EditorTextField(30, "\u0421\u0442\u0440\u043e\u043a\u0430<br>E-mail", this.focusListener);
        Component[][] components = new Component[][]{{new EditorLabel("\u041b\u043e\u0433\u0438\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f"), userLogin}, {new EditorLabel("\u041f\u0430\u0440\u043e\u043b\u044c"), userPassword}, {new EditorLabel("E-mail"), userEmail}};
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        ClientUtils.addComponentToPanel((JPanel)panel, (int)gridy, (Component[][])components, (boolean)true);
        userLogin.setText(String.valueOf(forpostUser.getLogin() != null ? forpostUser.getLogin() : ""));
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            Color color = Color.YELLOW;
            boolean error = this.checkTextField(userLogin, color, false);
            if (error = this.checkTextField(userPassword, color, error)) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043b\u0435\u0439.");
                return;
            }
            forpostUser.setAccountId(this.accountId);
            forpostUser.setLogin(userLogin.getText());
            forpostUser.setPassword(userPassword.getText());
            forpostUser.put("Email", (Object)userEmail.getText());
            try {
                int id = this.getForpostService().forpostUserAdd(forpostUser);
                this.performAction("user.refresh");
                this.getTableModel().setSelectedRow(Integer.valueOf(id));
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return;
            }
        });
        return dialog;
    }

    private JDialog getUserEditDialog(final ForpostUser forpostUser) {
        final ForpostParamTableModel paramTableModel = new ForpostParamTableModel();
        CellEditorListener cellEditorListener = new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                ParamTableRow tableRow = (ParamTableRow)paramTableModel.getSelectedRow();
                try {
                    ForpostContractUserPanel.this.getForpostService().forpostUserParamUpdate(forpostUser.getId(), tableRow.getName(), tableRow.getValue());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        };
        ForpostParamTable paramTable = new ForpostParamTable((TableModel)((Object)paramTableModel), cellEditorListener);
        paramTable.setContext((ClientContext)this.getContext());
        paramTableModel.addRow(new ParamTableRow("Login", "\u041b\u043e\u0433\u0438\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", forpostUser.getLogin()));
        paramTableModel.addRow(new ParamTableRow("Password", "\u041f\u0430\u0440\u043e\u043b\u044c", forpostUser.getPassword()));
        paramTableModel.addRow(new ParamTableRow("Email", "Email", forpostUser.getString("Email")));
        paramTableModel.addRow(new ParamTableRow("Phone", "\u0422\u0435\u043b\u0435\u0444\u043e\u043d", forpostUser.getString("Phone")));
        paramTableModel.addRow(new ParamTableRow("FIO", "\u0424\u0418\u041e", forpostUser.getString("FIO")));
        paramTableModel.addRow(new ParamTableRow("IsReadOnly", "\u0417\u0430\u043f\u0440\u0435\u0442\u0438\u0442\u044c \u043f\u043e\u043b\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043a\u0430\u043c\u0435\u0440\u0430\u043c", forpostUser.getString("IsReadOnly"), ParamTableEditorType.ON_OFF));
        paramTableModel.addRow(new ParamTableRow("CanChangeOwnInfo", "\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u0438 \u043c\u0435\u043d\u044f\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c", forpostUser.getString("CanChangeOwnInfo"), ParamTableEditorType.ON_OFF));
        paramTableModel.addRow(new ParamTableRow("ChangePasswordAtNextLogin", "\u0417\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u043f\u0440\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u043c \u0432\u0445\u043e\u0434\u0435", forpostUser.getString("ChangePasswordAtNextLogin"), ParamTableEditorType.ON_OFF));
        paramTableModel.addRow(new ParamTableRow("AuthProviderID", "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043f\u043e\u0441\u043e\u0431\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u0430\u0440\u043e\u043b\u044f", forpostUser.getString("AuthProviderID")));
        paramTableModel.addRow(new ParamTableRow("IsActive", "\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442/\u0432\u044b\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", String.valueOf(forpostUser.getIsActive()), ParamTableEditorType.ON_OFF));
        int gridy = 0;
        Dimension dimension = new Dimension(900, 200);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.add((Component)new JScrollPane((Component)((Object)paramTable)), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", new JButton[]{new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c")});
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> dialog.setVisible(false));
        return dialog;
    }

    class UserTableModel
    extends BGTableModel<ForpostUser> {
        public UserTableModel() {
            super(UserTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041b\u043e\u0433\u0438\u043d", 150, 150, 150, "login", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u043e\u043b\u044c", 150, 150, 150, "isReadOnly", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0424\u0418\u041e", 100, 500, -1, "fio", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0435\u043b\u0435\u0444\u043e\u043d", 100, 500, -1, "phone", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("Email", 100, 500, -1, "email", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u0435\u043d", Boolean.class, 70, 70, 70, "isActive", true);
        }

        public Object getValueAt(ForpostUser forpostUser, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            Map map = Utils.linesToPairsHash((String)forpostUser.getData());
            if ("isActive".equals(identifier)) {
                return forpostUser.getIsActive() == 1;
            }
            if ("email".equals(identifier)) {
                return map.get("Email");
            }
            if ("phone".equals(identifier)) {
                return map.get("Phone");
            }
            if ("fio".equals(identifier)) {
                return map.get("FIO");
            }
            if ("isReadOnly".equals(identifier)) {
                String isReadOnly = (String)map.get("IsReadOnly");
                return isReadOnly == null ? "" : (isReadOnly.equals("1") ? "\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c" : "\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440");
            }
            return super.getValueAt((Object)forpostUser, column);
        }
    }
}

