/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.tariff.tree;

import bitel.billing.module.common.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffCostMode;
import ru.bitel.bgbilling.modules.smarthouse.client.common.IntCount;
import ru.bitel.common.Utils;

public class SmartHouseOptionCostTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"coin");
    private JLabel view = new JLabel();
    private Editor editor;

    public SmartHouseOptionCostTariffTreeNode() {
        this.view.setIcon(icon);
    }

    protected JPanel getEditorPanel() {
        if (this.editor == null) {
            this.editor = new Editor();
        }
        return this.editor;
    }

    public Component getView() {
        return this.view;
    }

    protected void loadData() {
        if (this.editor != null) {
            Map data = this.getDataInHash();
            this.editor.cost.setText(data.getOrDefault("cost", ""));
            this.editor.unitFrom.setText(data.getOrDefault("unitFrom", ""));
            this.editor.unitTo.setText(data.getOrDefault("unitTo", ""));
            switch (TariffCostMode.valueOf((String)data.getOrDefault("mode", TariffCostMode.ALL.name()))) {
                case PER_UNIT: {
                    this.editor.perUnit.setSelected(true);
                    break;
                }
                case ON_UNITS: {
                    this.editor.units.setSelected(true);
                    break;
                }
                default: {
                    this.editor.all.setSelected(true);
                }
            }
        }
    }

    protected void serializeData() {
        TariffCostMode mode;
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("cost", this.editor.cost.getText());
        Object object = mode = this.editor.perUnit.isSelected() ? TariffCostMode.PER_UNIT : null;
        mode = mode == null ? (this.editor.units.isSelected() ? TariffCostMode.ON_UNITS : TariffCostMode.ALL) : mode;
        data.put("mode", mode.name());
        if (TariffCostMode.ON_UNITS == mode) {
            data.put("unitFrom", this.editor.unitFrom.getText());
            data.put("unitTo", this.editor.unitTo.getText());
        }
        this.setDataInHash(data);
        this.updateView();
    }

    private void updateView() {
        Map data = this.getDataInHash();
        StringBuffer sb = new StringBuffer();
        sb.append("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c");
        switch (TariffCostMode.valueOf((String)data.getOrDefault("mode", TariffCostMode.ALL.name()))) {
            case PER_UNIT: {
                sb.append(" \u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443");
                break;
            }
            case ON_UNITS: {
                String unitTo;
                sb.append(" \u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443");
                String unitFrom = data.getOrDefault("unitFrom", "");
                if (Utils.notBlankString((String)unitFrom)) {
                    sb.append(" \u0441 ").append(unitFrom);
                }
                if (!Utils.notBlankString((String)(unitTo = data.getOrDefault("unitTo", "")))) break;
                sb.append(" \u043f\u043e ").append(unitTo);
                break;
            }
            default: {
                sb.append(" \u0432\u0441\u0435\u0433\u043e");
            }
        }
        sb.append(": ").append(data.getOrDefault("cost", "?"));
        this.view.setText(sb.toString());
    }

    protected void editOk() {
        int b;
        int a;
        if (this.editor.units.isSelected() && (a = Utils.parseInt((String)this.editor.unitFrom.getText(), (int)0)) > (b = Utils.parseInt((String)this.editor.unitTo.getText(), (int)0)) && Utils.notBlankString((String)this.editor.unitTo.getText())) {
            ClientUtils.showErrorMessageDialog((String)"'\u0441' \u0431\u043e\u043b\u044c\u0448\u0435 '\u043f\u043e'");
            return;
        }
        super.editOk();
    }

    public void setData(String data) {
        super.setData(data);
        this.loadData();
        this.updateView();
    }

    class Editor
    extends JPanel {
        private FloatTextField cost;
        private JRadioButton all;
        private JRadioButton perUnit;
        private JRadioButton units;
        private IntCount unitFrom;
        private IntCount unitTo;
        private ButtonGroup buttonGroup;

        public Editor() {
            super(new GridBagLayout());
            this.cost = new FloatTextField(10);
            this.all = new JRadioButton("\u0432\u0441\u0435\u0433\u043e", true);
            this.perUnit = new JRadioButton("\u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443");
            this.units = new JRadioButton("\u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443: ");
            this.unitFrom = new IntCount(5);
            this.unitTo = new IntCount(5);
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(this.all);
            this.buttonGroup.add(this.perUnit);
            this.buttonGroup.add(this.units);
            this.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.cost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.all, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.perUnit, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.getUnitPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        }

        private JPanel getUnitPanel() {
            int gridx = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.units, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("c "), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.unitFrom, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel(" \u043f\u043e "), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.unitTo, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }
    }
}

