/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.api;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCamera;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraBrand;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostGroup;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostMaster;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostObject;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostProtocol;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostPtzType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRecordType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRtspTransport;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUser;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseCameraModelsAndBrands;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseId;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseStatus;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;

public class ForpostManager {
    private static final String PARAM_ADMIN_LOGIN = "AdminLogin";
    private static final String PARAM_ADMIN_PASSWORD = "AdminPassword";
    private Logger logger = LogManager.getLogger();
    private String serverUrl = null;
    private String adminLogin = null;
    private String adminPassword = null;
    private int connectTimeout;
    private int readTimeout;
    private Map<String, String> requestProperties = null;

    public ForpostManager(int moduleId) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.serverUrl = moduleSetup.get("forpost.server.url");
        this.adminLogin = moduleSetup.get("forpost.admin.login");
        this.adminPassword = moduleSetup.get("forpost.admin.password");
        this.readTimeout = moduleSetup.getInt("forpost.request.timeout.read", 10000);
        this.connectTimeout = moduleSetup.getInt("forpost.request.timeout.connect", 10000);
    }

    public ResponseId addAccount(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/AddAccount", params, ResponseId.class);
    }

    public ResponseId editAccount(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/EditAccount", params, ResponseId.class);
    }

    public ResponseStatus deleteAccount(int id) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(id));
        return this.doRequest("/system-api/DeleteAccount", params, ResponseStatus.class);
    }

    public ForpostAccount[] getAccounts() throws Exception {
        return this.doRequest("/system-api/GetAccounts", new HashMap<String, String>(), ForpostAccount[].class);
    }

    public ForpostAccount[] getAccounts(int id, String name, String contractNumber) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (id > 0) {
            params.put("ID", String.valueOf(id));
        }
        if (name != null) {
            params.put("Name", name);
        }
        if (contractNumber != null) {
            params.put("ContractNumber", contractNumber);
        }
        return this.doRequest("/system-api/FindAccounts", params, ForpostAccount[].class);
    }

    public ResponseId addCamera(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/AddCamera", params, ResponseId.class);
    }

    public ResponseStatus syncCamera(int id) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(id));
        return this.doRequest("/system-api/SyncCamera", params, ResponseStatus.class);
    }

    public ResponseId editCamera(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/EditCamera", params, ResponseId.class);
    }

    public ResponseStatus deleteCamera(int id) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(id));
        return this.doRequest("/system-api/DeleteCamera", params, ResponseStatus.class);
    }

    public ForpostCamera[] getCameras(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/GetCameras", params, ForpostCamera[].class);
    }

    public ForpostMaster[] getMasters() throws Exception {
        return this.doRequest("/system-api/GetMasters", new HashMap<String, String>(), ForpostMaster[].class);
    }

    public ForpostCameraModel[] getCameraModels(int brandId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", brandId);
        return this.doRequest("/system-api/GetCameraModels", params, ForpostCameraModel[].class);
    }

    public ResponseCameraModelsAndBrands getCameraModelsAndBrands() throws Exception {
        return this.doRequest("/system-api/GetCameraModelsAndBrands", new HashMap<String, String>(), ResponseCameraModelsAndBrands.class);
    }

    public ForpostCameraBrand[] getCameraBrands() throws Exception {
        return this.doRequest("/system-api/GetCameraBrands", new HashMap<String, String>(), ForpostCameraBrand[].class);
    }

    public ForpostRecordType[] getRecordTypes() throws Exception {
        return this.doRequest("/system-api/GetRecordTypes", new HashMap<String, String>(), ForpostRecordType[].class);
    }

    public ForpostProtocol[] getProtocols() throws Exception {
        return this.doRequest("/system-api/GetProtocols", new HashMap<String, String>(), ForpostProtocol[].class);
    }

    public ForpostRtspTransport[] getRtspTransports() throws Exception {
        return this.doRequest("/system-api/GetRtspTransports", new HashMap<String, String>(), ForpostRtspTransport[].class);
    }

    public ForpostPtzType[] getPtzTypes() throws Exception {
        return this.doRequest("/system-api/GetPTZTypes", new HashMap<String, String>(), ForpostPtzType[].class);
    }

    public ForpostCamera[] getCameras(int accountId, int cameraId, int includeParentGroups) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", cameraId);
        this.addParam(params, "AccountID", accountId);
        this.addParam(params, "IncludeParentGroups", includeParentGroups);
        return this.doRequest("/system-api/GetCameras", params, ForpostCamera[].class);
    }

    public ForpostUser[] getAccountUsers(int accountId, int userId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", userId);
        this.addParam(params, "AccountID", accountId);
        return this.doRequest("/system-api/GetAccountUsers", params, ForpostUser[].class);
    }

    public ResponseId addUser(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/AddUser", params, ResponseId.class);
    }

    public ResponseId editUser(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/EditUser", params, ResponseId.class);
    }

    public ResponseStatus deleteUser(int userId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", userId);
        return this.doRequest("/system-api/DeleteUser", params, ResponseStatus.class);
    }

    public ForpostObject[] getObjects(int accountId, int objectId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", objectId);
        this.addParam(params, "AccountID", accountId);
        return this.doRequest("/system-api/GetObjects", params, ForpostObject[].class);
    }

    public ResponseId addObject(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/AddObject", params, ResponseId.class);
    }

    public ResponseId editObject(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/EditObject", params, ResponseId.class);
    }

    public ResponseStatus deleteObject(int objectId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", objectId);
        return this.doRequest("/system-api/DeleteObject", params, ResponseStatus.class);
    }

    public ResponseId addAccountGroup(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/AddAccountGroup", params, ResponseId.class);
    }

    public ResponseId editAccountGroup(int id, String name, int parentId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", id);
        this.addParam(params, "Name", name);
        this.addParam(params, "ParentID", parentId);
        return this.doRequest("/system-api/EditAccountGroup", params, ResponseId.class);
    }

    public ResponseStatus deleteAccountGroup(int groupId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", groupId);
        return this.doRequest("/system-api/DeleteAccountGroup", params, ResponseStatus.class);
    }

    public ForpostGroup[] getAccountGroups(int id, String name, int accountId, int cameraId, int bindAccountId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", id);
        this.addParam(params, "Name", name);
        this.addParam(params, "AccountID", accountId);
        this.addParam(params, "CameraID", cameraId);
        this.addParam(params, "BindAccountID", bindAccountId);
        return this.doRequest("/system-api/GetAccountGroups", params, ForpostGroup[].class);
    }

    private void addParam(Map<String, String> params, String name, int value) {
        if (value > 0) {
            params.put(name, String.valueOf(value));
        }
    }

    private void addParam(Map<String, String> params, String name, String value) {
        if (value != null) {
            params.put(name, value);
        }
    }

    protected <T> T doRequest(String uri, Map<String, String> params, Class<T> clazz) throws Exception {
        URL url = new URL(this.serverUrl + uri);
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setRequestMethod("POST");
        if (this.requestProperties != null && !this.requestProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.requestProperties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        connection.setDoOutput(true);
        connection.setDoInput(true);
        params.put(PARAM_ADMIN_LOGIN, this.adminLogin);
        params.put(PARAM_ADMIN_PASSWORD, this.adminPassword);
        StringBuffer outputText = new StringBuffer();
        params.keySet().forEach(e -> outputText.append((String)e).append("=").append(this.encodeString((String)params.get(e))).append("&"));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
        bw.write(outputText.toString().toCharArray());
        bw.close();
        connection.connect();
        StringBuilder result = null;
        InputStream inputStream = connection.getResponseCode() == 200 ? connection.getInputStream() : connection.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        if (reader.ready()) {
            String line = null;
            result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        reader.close();
        connection.disconnect();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0424\u043e\u0440\u043f\u043e\u0441\u0442: " + result.toString());
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        return (T)mapper.readValue(result.toString(), clazz);
    }

    private String encodeString(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception e) {
            this.logger.error("string = " + string, (Throwable)e);
            return "";
        }
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        this.requestProperties = requestProperties;
    }
}

