/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.api.flussonicwatcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.modules.smarthouse.server.api.flussonicwatcher.FlussonicWatcherData;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;

public class FlussonicWatcherManager {
    private Logger logger = LogManager.getLogger();
    private String serverUrl = null;
    private String apiKey = null;
    private int connectTimeout;
    private int readTimeout;
    private Map<String, String> requestProperties = null;
    private FlussonicWatcherData flussonicWatcherData;
    private static Map<Integer, FlussonicWatcherData> moduleLoginData = new HashMap<Integer, FlussonicWatcherData>();

    public FlussonicWatcherManager(int moduleId) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.serverUrl = moduleSetup.get("flussonicwatcher.server.url");
        this.apiKey = moduleSetup.get("flussonicwatcher.api.key");
        this.readTimeout = moduleSetup.getInt("flussonicwatcher.request.timeout.read", 10000);
        this.connectTimeout = moduleSetup.getInt("flussonicwatcher.request.timeout.connect", 10000);
        this.flussonicWatcherData = moduleLoginData.get(moduleId);
        if (this.flussonicWatcherData == null) {
            String login = moduleSetup.get("flussonicwatcher.server.login");
            String password = moduleSetup.get("flussonicwatcher.server.password");
            try {
                String loginResult = this.login(login, password);
                JSONObject jsonObject = new JSONObject(loginResult);
                FlussonicWatcherData flussonicWatcherData = new FlussonicWatcherData();
                flussonicWatcherData.setLoginResult(jsonObject);
                flussonicWatcherData.setSession(jsonObject.optString("session"));
                this.flussonicWatcherData = flussonicWatcherData;
                moduleLoginData.put(moduleId, flussonicWatcherData);
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
            }
        }
    }

    public String login(String login, String password) throws Exception {
        JSONObject data = new JSONObject();
        data.put("login", (Object)login);
        data.put("password", (Object)password);
        return this.doRequest("GET", "/vsaas/api/v2/auth/login", data.toString());
    }

    public String getUsers() throws Exception {
        return this.doRequest("GET", "/vsaas/api/v2/users", null);
    }

    public String getOrganizations() throws Exception {
        return this.doRequest("GET", "/vsaas/api/v2/organizations", null);
    }

    public String getCameras() throws Exception {
        return this.doRequest("GET", "/vsaas/api/v2/cameras", null);
    }

    protected String doRequest(String method, String uri, String output) throws Exception {
        if (this.serverUrl == null) {
            this.logger.error("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"flussonicwatcher.server.url=\"");
            return null;
        }
        URL url = new URL(this.serverUrl + uri);
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setRequestMethod(method);
        if (this.requestProperties != null && !this.requestProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.requestProperties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        connection.setRequestProperty("x-vsaas-api-key", this.apiKey);
        if (this.flussonicWatcherData != null && this.flussonicWatcherData.getSession() != null) {
            connection.setRequestProperty("x-vsaas-session", this.flussonicWatcherData.getSession());
        }
        connection.setDoOutput(output != null);
        connection.setDoInput(true);
        if (output != null) {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            bw.write(output.toCharArray());
            bw.close();
        }
        connection.connect();
        StringBuilder result = null;
        InputStream inputStream = connection.getResponseCode() == 200 ? connection.getInputStream() : connection.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        if (reader.ready()) {
            String line = null;
            result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        reader.close();
        connection.disconnect();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 Flussonic Watcher: " + result.toString());
        }
        return result.toString();
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        this.requestProperties = requestProperties;
    }
}

